untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqP3yewsItEyt0brb3YEc3gijyo3Qisxtng6/HAvU8XREpps7aM5LOl851uPTgwhxBHXCkPTOPwUH3BnmdzjcgXg0=

OpenBSD 5.8 errata 17, June 6, 2016:

SECOND REVISION

Correct a problem that prevents the DSA signing algorithm from running
in constant time even if the flag BN_FLG_CONSTTIME is set. This issue
was reported by Cesar Pereida (Aalto University), Billy Brumley
(Tampere University of Technology), and Yuval Yarom (The University of
Adelaide and NICTA). The fix was developed by Cesar Pereida.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 017_crypto.patch.sig \
            -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
	cd /usr/src/lib/libcrypto
	make obj
	make depend
	make
	make install

Index: lib/libssl/src/crypto/dsa/dsa_ossl.c
===================================================================
RCS file: /cvs/src/lib/libssl/src/crypto/dsa/dsa_ossl.c,v
retrieving revision 1.22
diff -u -p -u -p -r1.22 dsa_ossl.c
--- lib/libssl/src/crypto/dsa/dsa_ossl.c	18 Oct 2014 17:20:40 -0000	1.22
+++ lib/libssl/src/crypto/dsa/dsa_ossl.c	5 Jun 2016 20:17:48 -0000
@@ -247,9 +247,6 @@ dsa_sign_setup(DSA *dsa, BN_CTX *ctx_in,
 		if (!BN_rand_range(&k, dsa->q))
 			goto err;
 	} while (BN_is_zero(&k));
-	if ((dsa->flags & DSA_FLAG_NO_EXP_CONSTTIME) == 0) {
-		BN_set_flags(&k, BN_FLG_CONSTTIME);
-	}
 
 	if (dsa->flags & DSA_FLAG_CACHE_MONT_P) {
 		if (!BN_MONT_CTX_set_locked(&dsa->method_mont_p,
@@ -283,6 +280,11 @@ dsa_sign_setup(DSA *dsa, BN_CTX *ctx_in,
 	} else {
 		K = &k;
 	}
+
+	if ((dsa->flags & DSA_FLAG_NO_EXP_CONSTTIME) == 0) {
+		BN_set_flags(K, BN_FLG_CONSTTIME);
+	}
+
 	DSA_BN_MOD_EXP(goto err, dsa, r, dsa->g, K, dsa->p, ctx,
 	    dsa->method_mont_p);
 	if (!BN_mod(r,r,dsa->q,ctx))
