untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEmZzy+OuyHtZazgnu97xr6TH3a0vQKYZLtI6fRsJt1MkWyjiiNa7HljzVKEgaAgEP6NkiSonbXppMnYTAyGgjA0=

OpenBSD 6.1 errata 032, October 13th, 2017:

A local user could trigger a kernel panic by using an invalid TCB value.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 032_tcb_invalid.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/include/tcb.h
===================================================================
RCS file: /data/mirror/openbsd/cvs/src/sys/arch/amd64/include/tcb.h,v
retrieving revision 1.4.4.1
diff -u -p -r1.4.4.1 tcb.h
--- sys/arch/amd64/include/tcb.h	27 Sep 2017 18:06:45 -0000	1.4.4.1
+++ sys/arch/amd64/include/tcb.h	10 Oct 2017 18:09:15 -0000
@@ -28,7 +28,7 @@ void	tcb_set(struct proc *_p, void *_new
 #define TCB_SET(p, addr)	tcb_set(p, addr)
 
 /* address must be in canonical form; requiring lower-half is okay */
-#define TCB_INVALID(addr)	((u_long)(addr) > 0x0000ffffffffffff)
+#define TCB_INVALID(addr)	((u_long)(addr) > 0x00007fffffffffff)
 
 #else /* _KERNEL */
 
