untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZTdDWtYK+RTF9mz5OdmIwqhpJFLB9pB6i/XNyb4QzdOcpsE5Ld1dvvU0HVe8qR8W80avmiWRm7dh/e3QTbkgewM=

OpenBSD 6.3 errata 003, April 21, 2018:

ARP replies could be sent on the wrong member interface of a bridge(4).

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 003_arp.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/if_ether.c
===================================================================
RCS file: /cvs/src/sys/netinet/if_ether.c,v
retrieving revision 1.234
retrieving revision 1.234.2.1
diff -u -p -r1.234 -r1.234.2.1
--- sys/netinet/if_ether.c	13 Mar 2018 16:42:22 -0000	1.234
+++ sys/netinet/if_ether.c	17 Apr 2018 18:50:27 -0000	1.234.2.1
@@ -86,7 +86,8 @@ struct rtentry *arplookup(struct in_addr
 void in_arpinput(struct ifnet *, struct mbuf *);
 void in_revarpinput(struct ifnet *, struct mbuf *);
 int arpcache(struct ifnet *, struct ether_arp *, struct rtentry *);
-void arpreply(struct ifnet *, struct mbuf *, struct in_addr *, uint8_t *);
+void arpreply(struct ifnet *, struct mbuf *, struct in_addr *, uint8_t *,
+    unsigned int);
 
 struct niqueue arpinq = NIQUEUE_INITIALIZER(50, NETISR_ARP);
 
@@ -267,12 +268,16 @@ arprequest(struct ifnet *ifp, u_int32_t 
 }
 
 void
-arpreply(struct ifnet *ifp, struct mbuf *m, struct in_addr *sip, uint8_t *eaddr)
+arpreply(struct ifnet *ifp, struct mbuf *m, struct in_addr *sip, uint8_t *eaddr,
+    unsigned int rdomain)
 {
 	struct ether_header *eh;
 	struct ether_arp *ea;
 	struct sockaddr sa;
 
+	m_resethdr(m);
+	m->m_pkthdr.ph_rtableid = rdomain;
+
 	ea = mtod(m, struct ether_arp *);
 	ea->arp_op = htons(ARPOP_REPLY);
 	ea->arp_pro = htons(ETHERTYPE_IP); /* let's be sure! */
@@ -574,7 +579,7 @@ in_arpinput(struct ifnet *ifp, struct mb
 				goto out;
 			eaddr = LLADDR(satosdl(rt->rt_gateway));
 		}
-		arpreply(ifp, m, &itaddr, eaddr);
+		arpreply(ifp, m, &itaddr, eaddr, rdomain);
 		rtfree(rt);
 		return;
 	}
