untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajSZHI+kC0MJZZZz/i25AfDbFHbOkF82Z7rSbP3ActqY+0/3yKzPfGG8cXZnUs6q073DO5M7pPNnA3Oolxluhgw8=

OpenBSD 7.4 errata 005, November 21, 2023:

Overlong sequences of UTF-8 combining characters could crash tmux(1).

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 005_tmux.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install tmux(1):
    cd /usr/src/usr.bin/tmux
    make obj
    make
    make install

Index: usr.bin/tmux/screen-write.c
===================================================================
RCS file: /cvs/src/usr.bin/tmux/screen-write.c,v
diff -u -p -r1.222 screen-write.c
--- usr.bin/tmux/screen-write.c	15 Sep 2023 15:49:05 -0000	1.222
+++ usr.bin/tmux/screen-write.c	16 Nov 2023 17:14:17 -0000
@@ -2025,6 +2025,10 @@ screen_write_combine(struct screen_write
 			return (0);
 	}
 
+	/* Check if this combined character would be too long. */
+	if (last.data.size + ud->size > sizeof last.data.data)
+		return (0);
+
 	/* Combining; flush any pending output. */
 	screen_write_collect_flush(ctx, 0, __func__);
 
