untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8ooVU88a3J6qJ9Yi87hwgaLoqT+acUCFBrdxzqSQGKyyGm0cL+Ti9qmoU/3OOSRaLEif0wKXaSV0Ego9JCdHhEwQ=

OpenBSD 7.6 errata 002, October 29, 2024:

Fix memory allocation error in the Xkb X11 server extension. CVE-2024-9632

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 002_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/xkb/xkb.c
===================================================================
RCS file: /cvs/xenocara/xserver/xkb/xkb.c,v
diff -u -p -u -r1.24 xkb.c
--- xserver/xkb/xkb.c	22 Jan 2023 09:44:42 -0000	1.24
+++ xserver/xkb/xkb.c	12 Oct 2024 07:52:49 -0000
@@ -2992,13 +2992,13 @@ _XkbSetCompatMap(ClientPtr client, Devic
         XkbSymInterpretPtr sym;
         unsigned int skipped = 0;
 
-        if ((unsigned) (req->firstSI + req->nSI) > compat->num_si) {
-            compat->num_si = req->firstSI + req->nSI;
+        if ((unsigned) (req->firstSI + req->nSI) > compat->size_si) {
+            compat->num_si = compat->size_si = req->firstSI + req->nSI;
             compat->sym_interpret = reallocarray(compat->sym_interpret,
-                                                 compat->num_si,
+                                                 compat->size_si,
                                                  sizeof(XkbSymInterpretRec));
             if (!compat->sym_interpret) {
-                compat->num_si = 0;
+                compat->num_si = compat->size_si = 0;
                 return BadAlloc;
             }
         }
