/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.ColorCellEditor;
import net.sf.freecol.client.gui.panel.ColorCellRenderer;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;

public final class PlayersTable
extends JTable {
    public static final int NATION_COLUMN = 0;
    public static final int AVAILABILITY_COLUMN = 1;
    public static final int ADVANTAGE_COLUMN = 2;
    public static final int COLOR_COLUMN = 3;
    public static final int PLAYER_COLUMN = 4;
    private static final String[] columnNames = new String[]{Messages.message("nation"), Messages.message("playersTable.availability"), Messages.message("playersTable.advantage"), Messages.message("color"), Messages.message("player")};
    private final GUI gui;

    public PlayersTable(FreeColClient freeColClient, NationOptions nationOptions, Player myPlayer) {
        this.gui = freeColClient.getGUI();
        Specification spec = freeColClient.getGame().getSpecification();
        this.setModel(new PlayersTableModel(freeColClient.getPreGameController(), nationOptions, myPlayer));
        this.setRowHeight((int)(FontLibrary.getFontScaling() * 47.0f));
        this.getTableHeader().setReorderingAllowed(false);
        FreeColButton nationButton = Utility.localizedButton("nation");
        nationButton.addActionListener(ae -> this.gui.showColopediaPanel(ColopediaAction.PanelType.NATIONS.getKey()));
        JLabel availabilityLabel = Utility.localizedLabel("playersTable.availability");
        FreeColButton advantageButton = Utility.localizedButton("playersTable.advantage");
        advantageButton.addActionListener(ae -> this.gui.showColopediaPanel(ColopediaAction.PanelType.NATION_TYPES.getKey()));
        JLabel colorLabel = Utility.localizedLabel("color");
        JLabel playerLabel = Utility.localizedLabel("player");
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setOpaque(false);
        HeaderRenderer renderer = new HeaderRenderer(nationButton, availabilityLabel, advantageButton, colorLabel, playerLabel);
        JTableHeader header = this.getTableHeader();
        header.addMouseListener(new HeaderListener(header, renderer));
        TableColumnModel tcm = this.getColumnModel();
        TableColumn nationColumn = tcm.getColumn(0);
        nationColumn.setCellRenderer(new NationCellRenderer());
        nationColumn.setHeaderRenderer(renderer);
        nationColumn.setPreferredWidth(2 * tcm.getTotalColumnWidth() / tcm.getColumnCount());
        TableColumn availableColumn = tcm.getColumn(1);
        availableColumn.setCellRenderer(new AvailableCellRenderer());
        availableColumn.setCellEditor(new AvailableCellEditor());
        TableColumn advantagesColumn = tcm.getColumn(2);
        switch (nationOptions.getNationalAdvantages()) {
            case SELECTABLE: {
                advantagesColumn.setCellEditor(new AdvantageCellEditor(spec.getEuropeanNationTypes()));
                break;
            }
            case FIXED: {
                break;
            }
            case NONE: {
                spec.clearEuropeanNationalAdvantages();
                break;
            }
        }
        advantagesColumn.setCellRenderer(new AdvantageCellRenderer(nationOptions.getNationalAdvantages()));
        advantagesColumn.setHeaderRenderer(renderer);
        TableColumn colorsColumn = tcm.getColumn(3);
        colorsColumn.setCellRenderer(new ColorCellRenderer(true));
        colorsColumn.setCellEditor(new ColorCellEditor(freeColClient));
        TableColumn playerColumn = tcm.getColumn(4);
        playerColumn.setCellEditor(new PlayerCellEditor());
        playerColumn.setCellRenderer(new PlayerCellRenderer());
    }

    public void update() {
        ((PlayersTableModel)this.getModel()).update();
    }

    private static class PlayersTableModel
    extends AbstractTableModel {
        private final PreGameController preGameController;
        private final NationOptions nationOptions;
        private final Player thisPlayer;
        private final List<Nation> nations;
        private final Map<Nation, Player> nationMap;

        public PlayersTableModel(PreGameController preGameController, NationOptions nationOptions, Player thisPlayer) {
            Specification spec = thisPlayer.getSpecification();
            this.preGameController = preGameController;
            this.nationOptions = nationOptions;
            this.thisPlayer = thisPlayer;
            Predicate<Nation> nationPred = n -> !n.isUnknownEnemy() && nationOptions.getNations().get(n) != null;
            this.nations = CollectionUtils.transform(spec.getNations(), nationPred);
            this.nationMap = new HashMap<Nation, Player>(this.nations.size());
            for (Nation n2 : this.nations) {
                this.nationMap.put(n2, null);
            }
            this.nationMap.put(thisPlayer.getNation(), thisPlayer);
        }

        public void update() {
            for (Nation n : this.nations) {
                this.nationMap.put(n, null);
            }
            for (Player p : this.thisPlayer.getGame().getLivePlayerList(new Player[0])) {
                this.nationMap.put(p.getNation(), p);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Nation.class;
                }
                case 1: {
                    return NationOptions.NationState.class;
                }
                case 2: {
                    return NationType.class;
                }
                case 3: {
                    return Color.class;
                }
                case 4: {
                    return Player.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.nations.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= 0 && row < this.getRowCount() && column >= 0 && column < this.getColumnCount()) {
                Nation nation = this.nations.get(row);
                switch (column) {
                    case 0: {
                        return nation;
                    }
                    case 1: {
                        return this.nationOptions.getNationState(nation);
                    }
                    case 2: {
                        return this.nationMap.get(nation) == null ? nation.getType() : this.nationMap.get(nation).getNationType();
                    }
                    case 3: {
                        return nation.getColor();
                    }
                    case 4: {
                        return this.nationMap.get(nation);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (row >= 0 && row < this.getRowCount()) {
                Nation nation = this.nations.get(row);
                boolean ownRow = this.thisPlayer == this.nationMap.get(nation) && !this.thisPlayer.isReady();
                switch (column) {
                    case 1: {
                        return !ownRow && this.thisPlayer.isAdmin();
                    }
                    case 2: {
                        return nation.getType() instanceof EuropeanNationType && ownRow;
                    }
                    case 3: {
                        return nation.getType() instanceof EuropeanNationType;
                    }
                    case 4: {
                        return nation.getType() instanceof EuropeanNationType && this.nationMap.get(nation) == null;
                    }
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row >= 0 && row < this.getRowCount() && column > 0 && column < this.getColumnCount()) {
                Nation nation = this.nations.get(row);
                switch (column) {
                    case 2: {
                        this.preGameController.setNationType((NationType)value);
                        this.update();
                        break;
                    }
                    case 1: {
                        this.preGameController.setAvailable(this.nations.get(row), (NationOptions.NationState)value);
                        this.update();
                        break;
                    }
                    case 3: {
                        this.preGameController.setColor(nation, (Color)value);
                        this.update();
                        break;
                    }
                    case 4: {
                        if (this.nationOptions.getNationState(nation) != NationOptions.NationState.AVAILABLE) break;
                        this.preGameController.setNation(nation);
                        this.preGameController.setNationType(nation.getType());
                        this.update();
                        break;
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
        }
    }

    private static final class PlayerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = Utility.localizedButton("select");

        public PlayerCellEditor() {
            this.button.addActionListener(ae -> this.fireEditingStopped());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return Boolean.TRUE;
        }
    }

    private static class PlayerCellRenderer
    implements TableCellRenderer {
        private final JLabel label = new JLabel();
        private final JButton button = Utility.localizedButton("select");

        public PlayerCellRenderer() {
            this.label.setHorizontalAlignment(0);
            Utility.padBorder(this.button, 5, 10, 5, 10);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Player player = (Player)value;
            if (player == null) {
                NationOptions.NationState nationState;
                NationType nationType = (NationType)table.getValueAt(row, 2);
                if (nationType instanceof EuropeanNationType && (nationState = (NationOptions.NationState)table.getValueAt(row, 1)) == NationOptions.NationState.AVAILABLE) {
                    return this.button;
                }
                Nation nation = (Nation)table.getValueAt(row, 0);
                this.label.setText(nation.getRulerName());
            } else {
                this.label.setText(player.getName());
            }
            return this.label;
        }
    }

    private static class NationStateRenderer
    extends JLabel
    implements ListCellRenderer<NationOptions.NationState> {
        private NationStateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends NationOptions.NationState> list, NationOptions.NationState value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(Messages.getName(value));
            return this;
        }
    }

    private class NationCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private NationCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Nation nation = (Nation)value;
            this.setText(Messages.message(StringTemplate.template("countryName").add("%nation%", Messages.nameKey(nation.getId()))));
            this.setIcon(new ImageIcon(PlayersTable.this.gui.getFixedImageLibrary().getUnscaledSmallerNationImage(nation)));
            return this;
        }
    }

    private static class HeaderRenderer
    implements TableCellRenderer {
        private static final int NO_COLUMN = -1;
        private int pressedColumn = -1;
        private final Component[] components;

        public HeaderRenderer(Component ... components) {
            this.components = components;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.components[column] instanceof JButton) {
                boolean isPressed = column == this.pressedColumn;
                ((JButton)this.components[column]).getModel().setPressed(isPressed);
                ((JButton)this.components[column]).getModel().setArmed(isPressed);
            }
            return this.components[column];
        }

        public void setPressedColumn(int column) {
            this.pressedColumn = column;
        }
    }

    private static class HeaderListener
    extends MouseAdapter {
        private final JTableHeader header;
        private final HeaderRenderer renderer;

        public HeaderListener(JTableHeader header, HeaderRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            this.renderer.setPressedColumn(col);
            this.header.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    private final class AvailableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JComboBox<NationOptions.NationState> aiStateBox = new JComboBox<NationOptions.NationState>(new NationOptions.NationState[]{NationOptions.NationState.AI_ONLY, NationOptions.NationState.NOT_AVAILABLE});
        private final JComboBox<NationOptions.NationState> allStateBox = new JComboBox<NationOptions.NationState>(NationOptions.NationState.values());
        private JComboBox<NationOptions.NationState> activeBox = null;

        public AvailableCellEditor() {
            ActionListener listener = ae -> this.stopCellEditing();
            this.aiStateBox.setRenderer(new NationStateRenderer());
            this.aiStateBox.addActionListener(listener);
            this.allStateBox.setRenderer(new NationStateRenderer());
            this.allStateBox.addActionListener(listener);
        }

        private JComboBox<NationOptions.NationState> getActiveBox(int row) {
            NationType nationType = ((Nation)PlayersTable.this.getValueAt(row, 0)).getType();
            this.activeBox = nationType instanceof EuropeanNationType ? this.allStateBox : this.aiStateBox;
            return this.activeBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getActiveBox(row);
        }

        @Override
        public Object getCellEditorValue() {
            return this.activeBox == null ? null : this.activeBox.getSelectedItem();
        }
    }

    private static class AvailableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private final JComboBox<NationOptions.NationState> box = new JComboBox<NationOptions.NationState>(NationOptions.NationState.values());

        public AvailableCellRenderer() {
            this.box.setRenderer(new NationStateRenderer());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.box.setSelectedItem(value);
                NationOptions.NationState nationState = (NationOptions.NationState)value;
                Utility.localizeToolTip(this.box, StringTemplate.key(nationState.getShortDescriptionKey()));
            }
            return this.box;
        }
    }

    private static class AdvantageCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private final NationOptions.Advantages advantages;

        public AdvantageCellRenderer(NationOptions.Advantages advantages) {
            this.advantages = advantages;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label;
            Player player = (Player)table.getValueAt(row, 4);
            NationType nationType = ((Nation)table.getValueAt(row, 0)).getType();
            switch (this.advantages) {
                case SELECTABLE: {
                    label = Utility.localizedLabel(Messages.nameKey(player == null ? nationType : player.getNationType()));
                    break;
                }
                case FIXED: {
                    label = Utility.localizedLabel(Messages.nameKey(nationType));
                    break;
                }
                default: {
                    label = Utility.localizedLabel("none");
                }
            }
            label.setForeground(player != null && player.isReady() ? Color.GRAY : table.getForeground());
            label.setBackground(table.getBackground());
            Utility.localizeToolTip((JComponent)this, StringTemplate.key(this.advantages.getShortDescriptionKey()));
            return label;
        }
    }

    private static class AdvantageCellEditor
    extends DefaultCellEditor {
        private final JComboBox<EuropeanNationType> box;

        private AdvantageCellEditor(JComboBox<EuropeanNationType> box) {
            super(box);
            this.box = box;
        }

        public AdvantageCellEditor(List<EuropeanNationType> nationTypes) {
            this(new JComboBox<EuropeanNationType>(nationTypes.toArray(new EuropeanNationType[0])));
            this.box.setRenderer(new FreeColComboBoxRenderer());
        }

        @Override
        public Object getCellEditorValue() {
            return ((JComboBox)this.getComponent()).getSelectedItem();
        }
    }
}

