;;;============================================================================

;;; File: "gambit.sld"

;;; Copyright (c) 2005-2023 by Marc Feeley, All Rights Reserved.

;;;============================================================================

;;; Placeholder for all the Gambit runtime system.

(define-library (gambit)
  (namespace "")
  (export

;; Identifier bindings of R4RS

;; special forms
and
begin
case
cond
define
delay
do
if
lambda
let
let*
letrec
or
quasiquote
quote
set!

;; procedures
*
+
-
/
<
<=
=
>
>=
abs
acos
angle
append
apply
asin
assoc
assq
assv
atan
boolean?
caaaar
caaadr
caaar
caadar
caaddr
caadr
caar
cadaar
cadadr
cadar
caddar
cadddr
caddr
cadr
call-with-current-continuation
call-with-input-file
call-with-output-file
car
cdaaar
cdaadr
cdaar
cdadar
cdaddr
cdadr
cdar
cddaar
cddadr
cddar
cdddar
cddddr
cdddr
cddr
cdr
ceiling
char->integer
char-alphabetic?
char-ci<=?
char-ci<?
char-ci=?
char-ci>=?
char-ci>?
char-downcase
char-lower-case?
char-numeric?
char-ready?
char-upcase
char-upper-case?
char-whitespace?
char<=?
char<?
char=?
char>=?
char>?
char?
close-input-port
close-output-port
complex?
cons
cos
current-input-port
current-output-port
denominator
display
eof-object?
eq?
equal?
eqv?
even?
exact->inexact
exact?
exp
expt
floor
for-each
force
gcd
imag-part
inexact->exact
inexact?
input-port?
integer->char
integer?
lcm
length
list
list->string
list->vector
list-ref
list-tail
list?
load
log
magnitude
make-polar
make-rectangular
make-string
make-vector
map
max
member
memq
memv
min
modulo
negative?
newline
not
null?
number->string
number?
numerator
odd?
open-input-file
open-output-file
output-port?
pair?
peek-char
positive?
procedure?
quotient
rational?
rationalize
read
read-char
real-part
real?
remainder
reverse
round
set-car!
set-cdr!
sin
sqrt
string
string->list
string->number
string->symbol
string-append
string-ci<=?
string-ci<?
string-ci=?
string-ci>=?
string-ci>?
string-copy
string-fill!
string-length
string-ref
string-set!
string<=?
string<?
string=?
string>=?
string>?
string?
substring
symbol->string
symbol?
tan
transcript-off
transcript-on
truncate
vector
vector->list
vector-fill!
vector-length
vector-ref
vector-set!
vector?
with-input-from-file
with-output-to-file
write
write-char
zero?

;; Identifier bindings that R5RS adds to R4RS

;; special forms
define-syntax
;;let-syntax ;; not implemented
;;letrec-syntax ;; not implemented
syntax-rules

;; procedures
call-with-values
dynamic-wind
eval
interaction-environment
null-environment
scheme-report-environment
values

;; Identifier bindings that R7RS adds to R5RS

;; special forms
case-lambda
cond-expand
define-library
define-record-type
delay-force
guard
include
include-ci
let*-values
let-values
letrec*
letrec*-values
letrec-values
parameterize
syntax-error
unless
when

;; procedures
balanced-quotient
balanced-remainder
balanced/
binary-port?
boolean=?
bytevector
bytevector-append
bytevector-copy
bytevector-copy!
bytevector-length
bytevector-u8-ref
bytevector-u8-set!
bytevector?
call-with-port
ceiling-quotient
ceiling-remainder
ceiling/
char-foldcase
close-port
command-line
current-error-port
current-jiffy
current-second
delete-file
digit-value
emergency-exit
eof-object
error-object-irritants
error-object-message
error-object?
euclidean-quotient
euclidean-remainder
euclidean/
exact
exact-integer-sqrt
exact-integer?
exit
features
file-error?
file-exists?
finite?
floor-quotient
floor-remainder
floor/
flush-output-port
get-environment-variable
get-environment-variables
get-output-bytevector
get-output-string
inexact
infinite?
input-port-open?
jiffies-per-second
list-copy
list-set!
make-bytevector
make-list
make-parameter
make-promise
nan?
open-binary-input-file
open-binary-output-file
open-input-bytevector
open-input-string
open-output-string
output-port-open?
peek-u8
port?
promise?
read-bytevector
read-bytevector!
read-error?
read-line
read-string
read-u8
round-quotient
round-remainder
round/
square
string->utf8
string->vector
string-copy!
string-downcase
string-foldcase
string-for-each
string-map
string-upcase
symbol=?
textual-port?
truncate-quotient
truncate-remainder
truncate/
u8-ready?
utf8->string
vector->string
vector-append
vector-copy
vector-copy!
vector-for-each
vector-map
write-bytevector
write-shared
write-simple
write-string
write-u8

;; Identifier bindings added by Gambit

;; special forms
define-module-alias
define-structure
define-type
define-type-of-thread
c-define-type
c-declare
c-initialize
c-lambda
c-define
define-macro
future
import
declare
namespace
this-source-file
receive
time
define-cond-expand-feature
define-values
r7rs-guard
syntax
syntax-case

;; global variable
default-random-source

;; procedures
->char-set
abandoned-mutex-exception?
abort
acosh
address-info-family
address-info-protocol
address-info-socket-info
address-info-socket-type
address-info?
address-infos
all-bits-set?
any
any-bit-set?
any-bits-set?
append!
append-reverse
append-reverse!
apropos
arithmetic-shift
asinh
atanh
bit-count
bit-field
bit-field-any?
bit-field-clear
bit-field-every?
bit-field-replace
bit-field-replace-same
bit-field-reverse
bit-field-rotate
bit-field-set
bit-set?
bit-swap
bits
bits->list
bits->vector
bitwise-and
bitwise-andc1
bitwise-andc2
bitwise-eqv
bitwise-fold
bitwise-for-each
bitwise-if
bitwise-ior
bitwise-merge
bitwise-nand
bitwise-nor
bitwise-not
bitwise-orc1
bitwise-orc2
bitwise-unfold
bitwise-xor
box
box?
break
call-with-input-process
call-with-input-string
call-with-input-u8vector
call-with-input-vector
call-with-output-process
call-with-output-string
call-with-output-u8vector
call-with-output-vector
call/cc
car+cdr
cfun-conversion-exception-arguments
cfun-conversion-exception-code
cfun-conversion-exception-message
cfun-conversion-exception-procedure
cfun-conversion-exception?
char-set
char-set->list
char-set->string
char-set-adjoin
char-set-adjoin!
char-set-any
char-set-complement
char-set-complement!
char-set-contains?
char-set-copy
char-set-count
char-set-cursor
char-set-cursor-next
char-set-delete
char-set-delete!
char-set-diff+intersection
char-set-diff+intersection!
char-set-difference
char-set-difference!
char-set-every
char-set-filter
char-set-filter!
char-set-fold
char-set-for-each
char-set-hash
char-set-intersection
char-set-intersection!
char-set-map
char-set-ref
char-set-size
char-set-unfold
char-set-unfold!
char-set-union
char-set-union!
char-set-xor
char-set-xor!
char-set<=
char-set=
char-set?
circular-list
circular-list?
clear-bit-field
command-args
command-name
compilation-target
compile-file
compile-file-to-target
concatenate
concatenate!
condition-variable-broadcast!
condition-variable-name
condition-variable-signal!
condition-variable-specific
condition-variable-specific-set!
condition-variable?
configure-command-string
conjugate
cons*
console-port
continuation-capture
continuation-graft
continuation-return
continuation?
copy-bit
copy-bit-field
copy-file
cosh
cpu-time
create-directory
create-fifo
create-link
create-symbolic-link
create-temporary-directory
current-directory
current-exception-handler
current-processor
current-readtable
current-thread
current-time
current-user-interrupt-handler
datum->syntax
datum-parsing-exception-kind
datum-parsing-exception-parameters
datum-parsing-exception-readenv
datum-parsing-exception?
dead-end
deadlock-exception?
default-user-interrupt-handler
defer-user-interrupts
delete
delete!
delete-directory
delete-file-or-directory
directory-files
display-continuation-backtrace
display-continuation-dynamic-environment
display-continuation-environment
display-exception
display-exception-in-context
display-procedure-environment
divide-by-zero-exception-arguments
divide-by-zero-exception-procedure
divide-by-zero-exception?
dotted-list?
drop
drop-right
drop-right!
eighth
end-of-char-set?
eq?-hash
equal?-hash
eqv?-hash
err-code->string
error
error-exception-message
error-exception-parameters
error-exception?
every
every-bit-set?
executable-path
expression-parsing-exception-kind
expression-parsing-exception-parameters
expression-parsing-exception-source
expression-parsing-exception?
extract-bit-field
f32vector
f32vector->list
f32vector-append
f32vector-concatenate
f32vector-copy
f32vector-copy!
f32vector-fill!
f32vector-length
f32vector-ref
f32vector-set
f32vector-set!
f32vector-shrink!
f32vector-swap!
f32vector?
f64vector
f64vector->list
f64vector-append
f64vector-concatenate
f64vector-copy
f64vector-copy!
f64vector-fill!
f64vector-length
f64vector-ref
f64vector-set
f64vector-set!
f64vector-shrink!
f64vector-swap!
f64vector?
fifth
file-attributes
file-creation-time
file-device
file-exists-exception-arguments
file-exists-exception-procedure
file-exists-exception?
file-group
file-info
file-info-attributes
file-info-creation-time
file-info-device
file-info-group
file-info-inode
file-info-last-access-time
file-info-last-change-time
file-info-last-modification-time
file-info-mode
file-info-number-of-links
file-info-owner
file-info-size
file-info-type
file-info?
file-inode
file-last-access-and-modification-times-set!
file-last-access-time
file-last-change-time
file-last-modification-time
file-mode
file-number-of-links
file-owner
file-size
file-type
filter
filter!
first
first-set-bit
fixnum->flonum
fixnum-overflow-exception-arguments
fixnum-overflow-exception-procedure
fixnum-overflow-exception?
fixnum?
fl*
fl+
fl+*
fl-
fl/
fl<
fl<=
fl=
fl>
fl>=
flabs
flacos
flacosh
flasin
flasinh
flatan
flatanh
flceiling
flcos
flcosh
fldenominator
fleven?
flexp
flexpm1
flexpt
flfinite?
flfloor
flhypot
flilogb
flinfinite?
flinteger?
fllog
fllog1p
flmax
flmin
flnan?
flnegative?
flnumerator
flodd?
flonum?
flpositive?
flround
flscalbn
flsin
flsinh
flsqrt
flsquare
fltan
fltanh
fltruncate
flzero?
fold
fold-right
force-output
foreign-address
foreign-release!
foreign-released?
foreign-tags
foreign?
fourth
fx*
fx+
fx-
fx<
fx<=
fx=
fx>
fx>=
fxabs
fxand
fxandc1
fxandc2
fxarithmetic-shift
fxarithmetic-shift-left
fxarithmetic-shift-right
fxbit-count
fxbit-set?
fxeqv
fxeven?
fxfirst-set-bit
fxif
fxior
fxlength
fxmax
fxmin
fxmodulo
fxnand
fxnegative?
fxnor
fxnot
fxodd?
fxorc1
fxorc2
fxpositive?
fxquotient
fxremainder
fxsquare
fxwrap*
fxwrap+
fxwrap-
fxwrapabs
fxwraparithmetic-shift
fxwraparithmetic-shift-left
fxwraplogical-shift-right
fxwrapquotient
fxwrapsquare
fxxor
fxzero?
gc-report-set!
generate-proper-tail-calls
gensym
get-output-u8vector
get-output-vector
getenv
group-info
group-info-gid
group-info-members
group-info-name
group-info?
heap-overflow-exception?
help
help-browser
host-info
host-info-addresses
host-info-aliases
host-info-name
host-info?
host-name
identity
inactive-thread-exception-arguments
inactive-thread-exception-procedure
inactive-thread-exception?
initial-current-directory
initialized-thread-exception-arguments
initialized-thread-exception-procedure
initialized-thread-exception?
input-port-byte-position
input-port-bytes-buffered
input-port-char-position
input-port-characters-buffered
input-port-column
input-port-line
input-port-readtable
input-port-readtable-set!
input-port-timeout-set!
integer-length
integer-nth-root
integer-sqrt
invalid-hash-number-exception-arguments
invalid-hash-number-exception-procedure
invalid-hash-number-exception?
invalid-utf8-encoding-exception-arguments
invalid-utf8-encoding-exception-procedure
invalid-utf8-encoding-exception?
iota
join-timeout-exception-arguments
join-timeout-exception-procedure
join-timeout-exception?
keyword->string
keyword-expected-exception-arguments
keyword-expected-exception-procedure
keyword-expected-exception?
keyword-hash
keyword?
last
last-pair
length+
length-mismatch-exception-arg-id
length-mismatch-exception-arguments
length-mismatch-exception-procedure
length-mismatch-exception?
link-flat
link-incremental
list->bits
list->char-set
list->char-set!
list->f32vector
list->f64vector
list->s16vector
list->s32vector
list->s64vector
list->s8vector
list->table
list->u16vector
list->u32vector
list->u64vector
list->u8vector
list-set
list-sort
list-sort!
list-tabulate
list=
mailbox-receive-timeout-exception-arguments
mailbox-receive-timeout-exception-procedure
mailbox-receive-timeout-exception?
main
make-bitwise-generator
make-condition-variable
make-f32vector
make-f64vector
make-mutex
make-random-source
make-root-thread
make-s16vector
make-s32vector
make-s64vector
make-s8vector
make-table
make-thread
make-thread-group
make-tls-context
make-u16vector
make-u32vector
make-u64vector
make-u8vector
make-will
module-not-found-exception-arguments
module-not-found-exception-procedure
module-not-found-exception?
module-search-order-add!
module-search-order-reset!
module-whitelist-add!
module-whitelist-reset!
multiple-c-return-exception?
mutex-lock!
mutex-name
mutex-specific
mutex-specific-set!
mutex-state
mutex-unlock!
mutex?
network-info
network-info-aliases
network-info-name
network-info-number
network-info?
ninth
no-such-file-or-directory-exception-arguments
no-such-file-or-directory-exception-procedure
no-such-file-or-directory-exception?
noncontinuable-exception-reason
noncontinuable-exception?
nonempty-input-port-character-buffer-exception-arguments
nonempty-input-port-character-buffer-exception-procedure
nonempty-input-port-character-buffer-exception?
nonprocedure-operator-exception-arguments
nonprocedure-operator-exception-code
nonprocedure-operator-exception-operator
nonprocedure-operator-exception-rte
nonprocedure-operator-exception?
not-in-compilation-context-exception-arguments
not-in-compilation-context-exception-procedure
not-in-compilation-context-exception?
not-pair?
null-list?
number-of-arguments-limit-exception-arguments
number-of-arguments-limit-exception-procedure
number-of-arguments-limit-exception?
object->serial-number
object->string
object->u8vector
open-directory
open-dummy
open-event-queue
open-file
open-input-process
open-input-u8vector
open-input-vector
open-output-bytevector
open-output-process
open-output-u8vector
open-output-vector
open-process
open-string
open-string-pipe
open-tcp-client
open-tcp-server
open-u8vector
open-u8vector-pipe
open-udp
open-vector
open-vector-pipe
os-exception-arguments
os-exception-code
os-exception-message
os-exception-procedure
os-exception?
output-port-byte-position
output-port-char-position
output-port-column
output-port-line
output-port-readtable
output-port-readtable-set!
output-port-timeout-set!
output-port-width
partition
partition!
path-directory
path-expand
path-extension
path-normalize
path-strip-directory
path-strip-extension
path-strip-trailing-directory-separator
path-strip-volume
path-volume
permission-denied-exception-arguments
permission-denied-exception-procedure
permission-denied-exception?
poll-point
port-io-exception-handler-set!
port-settings-set!
pp
pretty-print
primordial-exception-handler
print
println
process-pid
process-status
process-times
processor-id
processor?
proper-list?
protocol-info
protocol-info-aliases
protocol-info-name
protocol-info-number
protocol-info?
r7rs-raise
r7rs-raise-continuable
r7rs-with-exception-handler
raise
random-f64vector
random-integer
random-real
random-source-make-f64vectors
random-source-make-integers
random-source-make-reals
random-source-make-u8vectors
random-source-pseudo-randomize!
random-source-randomize!
random-source-state-ref
random-source-state-set!
random-source?
random-u8vector
range-exception-arg-id
range-exception-arguments
range-exception-procedure
range-exception?
read-all
read-file-string
read-file-string-list
read-file-u8vector
read-substring
read-subu8vector
readtable-case-conversion?
readtable-case-conversion?-set
readtable-comment-handler
readtable-comment-handler-set
readtable-eval-allowed?
readtable-eval-allowed?-set
readtable-keywords-allowed?
readtable-keywords-allowed?-set
readtable-max-unescaped-char
readtable-max-unescaped-char-set
readtable-max-write-length
readtable-max-write-length-set
readtable-max-write-level
readtable-max-write-level-set
readtable-sharing-allowed?
readtable-sharing-allowed?-set
readtable-start-syntax
readtable-start-syntax-set
readtable-write-cdr-read-macros?
readtable-write-cdr-read-macros?-set
readtable-write-extended-read-macros?
readtable-write-extended-read-macros?-set
readtable?
real-time
remove
remove!
remq
rename-file
repl-backtrace-detail-level
repl-highlight-source-level
repl-error-port
repl-input-port
repl-output-port
repl-result-history-max-length-set!
repl-result-history-ref
replace-bit-field
reverse!
rpc-remote-error-exception-arguments
rpc-remote-error-exception-message
rpc-remote-error-exception-procedure
rpc-remote-error-exception?
s16vector
s16vector->list
s16vector-append
s16vector-concatenate
s16vector-copy
s16vector-copy!
s16vector-fill!
s16vector-length
s16vector-ref
s16vector-set
s16vector-set!
s16vector-shrink!
s16vector-swap!
s16vector?
s32vector
s32vector->list
s32vector-append
s32vector-concatenate
s32vector-copy
s32vector-copy!
s32vector-fill!
s32vector-length
s32vector-ref
s32vector-set
s32vector-set!
s32vector-shrink!
s32vector-swap!
s32vector?
s64vector
s64vector->list
s64vector-append
s64vector-concatenate
s64vector-copy
s64vector-copy!
s64vector-fill!
s64vector-length
s64vector-ref
s64vector-set
s64vector-set!
s64vector-shrink!
s64vector-swap!
s64vector?
s8vector
s8vector->list
s8vector-append
s8vector-concatenate
s8vector-copy
s8vector-copy!
s8vector-fill!
s8vector-length
s8vector-ref
s8vector-set
s8vector-set!
s8vector-shrink!
s8vector-swap!
s8vector?
scheduler-exception-reason
scheduler-exception?
script-directory
script-file
second
seconds->time
serial-number->object
service-info
service-info-aliases
service-info-name
service-info-port-number
service-info-protocol
service-info?
set-box!
setenv
seventh
sfun-conversion-exception-arguments
sfun-conversion-exception-code
sfun-conversion-exception-message
sfun-conversion-exception-procedure
sfun-conversion-exception?
shell-command
sinh
six.!
six.!x
six.&x
six.**x
six.*x
six.++x
six.+x
six.--x
six.-x
six.arrow
six.asyncx
six.awaitx
six.break
six.call
six.case
six.clause
six.compound
six.cons
six.continue
six.define-procedure
six.define-variable
six.do-while
six.dot
six.for
six.from-import
six.from-import-*
six.goto
six.identifier
six.if
six.import
six.index
six.infix
six.label
six.list
six.literal
six.make-array
six.new
six.notx
six.null
six.procedure
six.procedure-body
six.return
six.switch
six.typeofx
six.while
six.x!==y
six.x!=y
six.x%=y
six.x%y
six.x&&y
six.x&=y
six.x&y
six.x**=y
six.x**y
six.x*=y
six.x*y
six.x++
six.x+=y
six.x+y
six.x--
six.x-=y
six.x-y
six.x//=y
six.x//y
six.x/=y
six.x/y
six.x:-y
six.x:=y
six.x:y
six.x<<=y
six.x<<y
six.x<=y
six.x<y
six.x===y
six.x==y
six.x=y
six.x>=y
six.x>>=y
six.x>>>=y
six.x>>>y
six.x>>y
six.x>y
six.x?y:z
six.x@=y
six.x@y
six.x^=y
six.x^y
six.xandy
six.xinstanceofy
six.xiny
six.xisy
six.xory
six.yieldx
six.~x
|six.x,y|
|six.x\|=y|
|six.x\|\|y|
|six.x\|y|
sixth
socket-info-address
socket-info-family
socket-info-port-number
socket-info?
split-at
split-at!
stack-overflow-exception?
started-thread-exception-arguments
started-thread-exception-procedure
started-thread-exception?
step
step-level-set!
string->char-set
string->char-set!
string->keyword
string->uninterned-keyword
string->uninterned-symbol
string-ci=?-hash
string-concatenate
string-contains
string-contains-ci
string-prefix-ci?
string-prefix-length
string-prefix-length-ci
string-prefix?
string-set
string-shrink!
string-suffix-ci?
string-suffix-length
string-suffix-length-ci
string-suffix?
string-swap!
string=?-hash
subf32vector
subf32vector-fill!
subf32vector-move!
subf64vector
subf64vector-fill!
subf64vector-move!
subs16vector
subs16vector-fill!
subs16vector-move!
subs32vector
subs32vector-fill!
subs32vector-move!
subs64vector
subs64vector-fill!
subs64vector-move!
subs8vector
subs8vector-fill!
subs8vector-move!
substring-fill!
substring-move!
subu16vector
subu16vector-fill!
subu16vector-move!
subu32vector
subu32vector-fill!
subu32vector-move!
subu64vector
subu64vector-fill!
subu64vector-move!
subu8vector
subu8vector-fill!
subu8vector-move!
subvector
subvector-fill!
subvector-move!
symbol-hash
syntax->datum
syntax->list
syntax->vector
system-stamp
system-type
system-type-string
system-version
system-version-string
table->list
table-copy
table-for-each
table-length
table-merge
table-merge!
table-ref
table-search
table-set!
table?
take
take!
take-right
tanh
tcp-client-local-socket-info
tcp-client-peer-socket-info
tcp-client-self-socket-info
tcp-server-socket-info
tcp-service-register!
tcp-service-unregister!
tenth
terminated-thread-exception-arguments
terminated-thread-exception-procedure
terminated-thread-exception?
test-bit-field?
third
thread
thread-base-priority
thread-base-priority-set!
thread-group->thread-group-list
thread-group->thread-group-vector
thread-group->thread-list
thread-group->thread-vector
thread-group-name
thread-group-parent
thread-group-resume!
thread-group-specific
thread-group-specific-set!
thread-group-suspend!
thread-group-terminate!
thread-group?
thread-init!
thread-interrupt!
thread-join!
thread-mailbox-extract-and-rewind
thread-mailbox-next
thread-mailbox-rewind
thread-name
thread-priority-boost
thread-priority-boost-set!
thread-quantum
thread-quantum-set!
thread-receive
thread-resume!
thread-send
thread-sleep!
thread-specific
thread-specific-set!
thread-start!
thread-state
thread-state-abnormally-terminated-reason
thread-state-abnormally-terminated?
thread-state-initialized?
thread-state-normally-terminated-result
thread-state-normally-terminated?
thread-state-running-processor
thread-state-running?
thread-state-uninitialized?
thread-state-waiting-for
thread-state-waiting-timeout
thread-state-waiting?
thread-suspend!
thread-terminate!
thread-thread-group
thread-yield!
thread?
time->seconds
time?
timeout->time
top
touch
trace
tty-history
tty-history-max-length-set!
tty-history-set!
tty-mode-set!
tty-paren-balance-duration-set!
tty-text-attributes-set!
tty-type-set!
tty?
type-exception-arg-id
type-exception-arguments
type-exception-procedure
type-exception-type-id
type-exception?
u16vector
u16vector->list
u16vector-append
u16vector-concatenate
u16vector-copy
u16vector-copy!
u16vector-fill!
u16vector-length
u16vector-ref
u16vector-set
u16vector-set!
u16vector-shrink!
u16vector-swap!
u16vector?
u32vector
u32vector->list
u32vector-append
u32vector-concatenate
u32vector-copy
u32vector-copy!
u32vector-fill!
u32vector-length
u32vector-ref
u32vector-set
u32vector-set!
u32vector-shrink!
u32vector-swap!
u32vector?
u64vector
u64vector->list
u64vector-append
u64vector-concatenate
u64vector-copy
u64vector-copy!
u64vector-fill!
u64vector-length
u64vector-ref
u64vector-set
u64vector-set!
u64vector-shrink!
u64vector-swap!
u64vector?
u8vector
u8vector->list
u8vector->object
u8vector-append
u8vector-concatenate
u8vector-copy
u8vector-copy!
u8vector-fill!
u8vector-length
u8vector-ref
u8vector-set
u8vector-set!
u8vector-shrink!
u8vector-swap!
u8vector?
ucs-range->char-set
ucs-range->char-set!
udp-destination-set!
udp-local-socket-info
udp-read-subu8vector
udp-read-u8vector
udp-source-socket-info
udp-write-subu8vector
udp-write-u8vector
unbound-global-exception-code
unbound-global-exception-rte
unbound-global-exception-variable
unbound-global-exception?
unbound-key-exception-arguments
unbound-key-exception-procedure
unbound-key-exception?
unbound-os-environment-variable-exception-arguments
unbound-os-environment-variable-exception-procedure
unbound-os-environment-variable-exception?
unbound-serial-number-exception-arguments
unbound-serial-number-exception-procedure
unbound-serial-number-exception?
unbox
unbreak
uncaught-exception-arguments
uncaught-exception-procedure
uncaught-exception-reason
uncaught-exception?
uninitialized-thread-exception-arguments
uninitialized-thread-exception-procedure
uninitialized-thread-exception?
uninterned-keyword?
uninterned-symbol?
unknown-keyword-argument-exception-arguments
unknown-keyword-argument-exception-procedure
unknown-keyword-argument-exception?
unterminated-process-exception-arguments
unterminated-process-exception-procedure
unterminated-process-exception?
untrace
user-info
user-info-gid
user-info-home
user-info-name
user-info-shell
user-info-uid
user-info?
user-name
vector->bits
vector-any
vector-cas!
vector-concatenate
vector-cumulate
vector-every
vector-fold
vector-fold-right
vector-inc!
vector-set
vector-shrink!
vector-swap!
vector-unfold
vector-unfold-right
void
will-execute!
will-testator
will?
with-exception-catcher
with-exception-handler
with-input-from-port
with-input-from-process
with-input-from-string
with-input-from-u8vector
with-input-from-vector
with-output-to-port
with-output-to-process
with-output-to-string
with-output-to-u8vector
with-output-to-vector
write-file-string
write-file-string-list
write-file-u8vector
write-substring
write-subu8vector
wrong-number-of-arguments-exception-arguments
wrong-number-of-arguments-exception-procedure
wrong-number-of-arguments-exception?
wrong-number-of-values-exception-code
wrong-number-of-values-exception-rte
wrong-number-of-values-exception-vals
wrong-number-of-values-exception?
wrong-processor-c-return-exception?
xcons

))

;;;============================================================================
