/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.ReportSpec;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;

public abstract class ReportingExtension {
    public static final String NAME = "reporting";
    public static final String DEFAULT_REPORTS_DIR_NAME = "reports";
    private final ProjectInternal project;
    private final DirectoryProperty baseDirectory;
    private final ExtensiblePolymorphicDomainObjectContainer<ReportSpec> reports;

    @Inject
    public ReportingExtension(Project project) {
        this.project = (ProjectInternal)project;
        this.baseDirectory = project.getObjects().directoryProperty();
        this.reports = project.getObjects().polymorphicDomainObjectContainer(ReportSpec.class);
        this.baseDirectory.set(project.getLayout().getBuildDirectory().dir(DEFAULT_REPORTS_DIR_NAME));
    }

    @Deprecated
    public File getBaseDir() {
        ReportingExtension.logBaseDirDeprecation("getBaseDir()");
        return (File)this.baseDirectory.getAsFile().get();
    }

    @Deprecated
    public void setBaseDir(File baseDir) {
        ReportingExtension.logBaseDirDeprecation("setBaseDir(File)");
        this.baseDirectory.set(baseDir);
    }

    @Deprecated
    public void setBaseDir(final Object baseDir) {
        ReportingExtension.logBaseDirDeprecation("setBaseDir(Object)");
        this.baseDirectory.set(this.project.provider((Callable)new Callable<Directory>(){

            @Override
            public Directory call() throws Exception {
                DirectoryProperty result = ReportingExtension.this.project.getObjects().directoryProperty();
                result.set(ReportingExtension.this.project.file(baseDir));
                return (Directory)result.get();
            }
        }));
    }

    private static void logBaseDirDeprecation(String methodWithParams) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ReportingExtension.class, (String)methodWithParams).replaceWith((Object)"getBaseDirectory() property")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "reporting-base-dir")).nagUser();
    }

    public DirectoryProperty getBaseDirectory() {
        return this.baseDirectory;
    }

    public File file(String path) {
        return ((FileLookup)this.project.getServices().get(FileLookup.class)).getFileResolver((File)this.getBaseDirectory().getAsFile().get()).resolve((Object)path);
    }

    @ToBeReplacedByLazyProperty
    public String getApiDocTitle() {
        Object version = this.project.getVersion();
        if ("unspecified".equals(version)) {
            return this.project.getName() + " API";
        }
        return this.project.getName() + " " + version + " API";
    }

    @Incubating
    public ExtensiblePolymorphicDomainObjectContainer<ReportSpec> getReports() {
        return this.reports;
    }
}

