/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.rx;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import jadx.gui.utils.rx.CustomDisposable;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class RxUtils {
    public static Flowable<String> textFieldChanges(JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            DocumentUpdateListener listener = new DocumentUpdateListener(ev -> emitter.onNext((Object)textField.getText()));
            textField.getDocument().addDocumentListener(listener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> textField.getDocument().removeDocumentListener(listener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> textFieldEnterPress(final JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ev) {
                    if (ev.getKeyCode() == 10) {
                        emitter.onNext((Object)textField.getText());
                    }
                }
            };
            textField.addKeyListener(keyListener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> textField.removeKeyListener(keyListener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }
}

