/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.MethodInfo;

public class JsonRpcMethodsProcessor {
    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem jsonRpcMethods(List<JsonRPCProvidersBuildItem> rpcProviders) {
        final HashSet<String> classes = new HashSet<String>();
        for (JsonRPCProvidersBuildItem rpcProvider : rpcProviders) {
            classes.add(rpcProvider.getJsonRPCMethodProviderClass().getName());
        }
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return classes.contains(method.declaringClass().name().toString());
            }
        });
    }
}

