/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneComponentLocationMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationsMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONCOUNT;
    public static final int LOCATIONS;

    public XrSceneComponentLocationsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneComponentLocationsMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentLocationsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneComponentLocationsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int locationCount() {
        return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneComponentLocationMSFT *")
    public XrSceneComponentLocationMSFT.Buffer locations() {
        return XrSceneComponentLocationsMSFT.nlocations(this.address());
    }

    public XrSceneComponentLocationsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentLocationsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT type$Default() {
        return this.type(1000097006);
    }

    public XrSceneComponentLocationsMSFT next(@NativeType(value="void *") long value) {
        XrSceneComponentLocationsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locationCount(@NativeType(value="uint32_t") int value) {
        XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locations(@Nullable @NativeType(value="XrSceneComponentLocationMSFT *") XrSceneComponentLocationMSFT.Buffer value) {
        XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(int type, long next, int locationCount, @Nullable XrSceneComponentLocationMSFT.Buffer locations) {
        this.type(type);
        this.next(next);
        this.locationCount(locationCount);
        this.locations(locations);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(XrSceneComponentLocationsMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationsMSFT malloc() {
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT calloc() {
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneComponentLocationsMSFT create(long address) {
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneComponentLocationsMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneComponentLocationsMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationsMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneComponentLocationsMSFT malloc(MemoryStack stack) {
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT calloc(MemoryStack stack) {
        return (XrSceneComponentLocationsMSFT)XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneComponentLocationsMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nlocationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATIONCOUNT);
    }

    @Nullable
    public static XrSceneComponentLocationMSFT.Buffer nlocations(long struct) {
        return XrSceneComponentLocationMSFT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)LOCATIONS)), XrSceneComponentLocationsMSFT.nlocationCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlocationCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATIONCOUNT, value);
    }

    public static void nlocations(long struct, @Nullable XrSceneComponentLocationMSFT.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LOCATIONS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrSceneComponentLocationsMSFT.nlocationCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationsMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneComponentLocationsMSFT.__member((int)4), XrSceneComponentLocationsMSFT.__member((int)POINTER_SIZE), XrSceneComponentLocationsMSFT.__member((int)4), XrSceneComponentLocationsMSFT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONCOUNT = layout.offsetof(2);
        LOCATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationsMSFT ELEMENT_FACTORY = XrSceneComponentLocationsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneComponentLocationsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentLocationsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneComponentLocationsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int locationCount() {
            return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneComponentLocationMSFT *")
        public XrSceneComponentLocationMSFT.Buffer locations() {
            return XrSceneComponentLocationsMSFT.nlocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentLocationsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneComponentLocationsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer locationCount(@NativeType(value="uint32_t") int value) {
            XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
            return this;
        }

        public Buffer locations(@Nullable @NativeType(value="XrSceneComponentLocationMSFT *") XrSceneComponentLocationMSFT.Buffer value) {
            XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
            return this;
        }
    }
}

