/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.chart.defaultchartprovider;

import java.awt.Color;
import java.awt.Font;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartTheme;

@NonNullByDefault
public class ChartThemeWhite
implements ChartTheme {
    private static final String THEME_NAME = "white";
    private static final Color[] LINECOLORS = new Color[]{new Color(244, 67, 54), new Color(76, 175, 80), new Color(63, 81, 181), new Color(156, 39, 176), new Color(255, 152, 0), new Color(0, 188, 212), new Color(233, 30, 99), new Color(50, 50, 50), new Color(205, 220, 57)};
    private static final String FONT_NAME = "SansSerif";

    @Override
    public String getThemeName() {
        return THEME_NAME;
    }

    @Override
    public Color getPlotBackgroundColor() {
        return Color.WHITE;
    }

    @Override
    public Color getPlotGridLinesColor() {
        return new Color(216, 216, 216);
    }

    @Override
    public double getPlotGridLinesWidth(int dpi) {
        return Math.max(1.0, (double)dpi / 64.0);
    }

    @Override
    public double getPlotGridLinesDash(int dpi) {
        return Math.max(3.0, (double)dpi / 32.0);
    }

    @Override
    public Color getLegendBackgroundColor() {
        return new Color(255, 255, 255, 160);
    }

    @Override
    public Color getChartBackgroundColor() {
        return Color.WHITE;
    }

    @Override
    public Color getChartFontColor() {
        return Color.BLACK;
    }

    @Override
    public Color getLineColor(int series) {
        return LINECOLORS[series % LINECOLORS.length];
    }

    @Override
    public double getLineWidth(int dpi) {
        return Math.max(1.0, (double)dpi / 64.0);
    }

    @Override
    public Color getAxisTickLabelsColor() {
        return this.getChartFontColor();
    }

    @Override
    public Font getAxisTickLabelsFont(int dpi) {
        int fontsize = (int)Math.max(8L, Math.round((double)dpi / 8.5));
        return new Font(FONT_NAME, 0, fontsize);
    }

    @Override
    public Font getLegendFont(int dpi) {
        int fontsize = (int)Math.max(8L, Math.round((double)dpi / 9.6));
        return new Font(FONT_NAME, 0, fontsize);
    }

    @Override
    public int getChartPadding(int dpi) {
        return (int)Math.max(5L, Math.round((double)dpi / 19.0));
    }

    @Override
    public int getLegendSeriesLineLength(int dpi) {
        return (int)Math.max(10L, Math.round((double)dpi / 12.0));
    }
}

