/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.type;

import java.util.Properties;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.type.ApplicationType;
import org.graalvm.visualvm.application.type.EclipseApplicationType;
import org.graalvm.visualvm.application.type.MainClassApplicationTypeFactory;

public class EclipseApplicationTypeFactory
extends MainClassApplicationTypeFactory {
    private static final String MAIN_CLASS = "org.eclipse.equinox.launcher.Main";
    private static final String ECLIPSE_ID = "-Dosgi.requiredJavaVersion=";
    private static final String ECLIPSE_ID2 = "-XstartOnFirstThread";
    private static final String ECLIPSE_SYSPROP_ID = "eclipse.buildId";
    private static final String ECLIPSE_NAME = "Eclipse";

    @Override
    public ApplicationType createApplicationTypeFor(Application app, Jvm jvm, String mainClass) {
        String name;
        String args;
        if (MAIN_CLASS.equals(mainClass)) {
            String name2 = this.getName(jvm);
            if (name2 == null) {
                name2 = ECLIPSE_NAME;
            }
            return new EclipseApplicationType(app, name2);
        }
        if ((mainClass == null || mainClass.isEmpty()) && (args = jvm.getJvmArgs()) != null && (args.contains(ECLIPSE_ID) || args.contains(ECLIPSE_ID2)) && (name = this.getName(jvm)) != null) {
            return new EclipseApplicationType(app, name);
        }
        return null;
    }

    private String getName(Jvm jvm) {
        Properties p;
        if (jvm.isGetSystemPropertiesSupported() && (p = jvm.getSystemProperties()) != null && p.containsKey(ECLIPSE_SYSPROP_ID)) {
            return ECLIPSE_NAME;
        }
        return null;
    }
}

