/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.util.Calendar;
import java.util.Date;
import org.rrd4j.graph.Axis;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphGenerator;
import org.rrd4j.graph.TimeAxisSetting;
import org.rrd4j.graph.TimeLabelFormat;
import org.rrd4j.graph.TimeUnit;

class TimeAxis
extends Axis {
    private static final TimeAxisSetting[] tickSettings = new TimeAxisSetting[]{new TimeAxisSetting(0L, TimeUnit.SECOND, 30, TimeUnit.MINUTE, 5, TimeUnit.MINUTE, 5, 0), new TimeAxisSetting(2L, TimeUnit.MINUTE, 1, TimeUnit.MINUTE, 5, TimeUnit.MINUTE, 5, 0), new TimeAxisSetting(5L, TimeUnit.MINUTE, 2, TimeUnit.MINUTE, 10, TimeUnit.MINUTE, 10, 0), new TimeAxisSetting(10L, TimeUnit.MINUTE, 5, TimeUnit.MINUTE, 20, TimeUnit.MINUTE, 20, 0), new TimeAxisSetting(30L, TimeUnit.MINUTE, 10, TimeUnit.HOUR, 1, TimeUnit.HOUR, 1, 0), new TimeAxisSetting(60L, TimeUnit.MINUTE, 30, TimeUnit.HOUR, 2, TimeUnit.HOUR, 2, 0), new TimeAxisSetting(180L, TimeUnit.HOUR, 1, TimeUnit.HOUR, 6, TimeUnit.HOUR, 6, 0), new TimeAxisSetting(600L, TimeUnit.HOUR, 6, TimeUnit.DAY, 1, TimeUnit.DAY, 1, 86400), new TimeAxisSetting(1800L, TimeUnit.HOUR, 12, TimeUnit.DAY, 1, TimeUnit.DAY, 2, 86400), new TimeAxisSetting(3600L, TimeUnit.DAY, 1, TimeUnit.WEEK, 1, TimeUnit.WEEK, 1, 604800), new TimeAxisSetting(10800L, TimeUnit.WEEK, 1, TimeUnit.MONTH, 1, TimeUnit.WEEK, 2, 604800), new TimeAxisSetting(21600L, TimeUnit.MONTH, 1, TimeUnit.MONTH, 1, TimeUnit.MONTH, 1, 2592000), new TimeAxisSetting(172800L, TimeUnit.MONTH, 1, TimeUnit.MONTH, 3, TimeUnit.MONTH, 3, 2592000), new TimeAxisSetting(864000L, TimeUnit.YEAR, 1, TimeUnit.YEAR, 1, TimeUnit.YEAR, 1, 31536000)};
    private final ImageParameters im;
    private final ImageWorker worker;
    private final RrdGraphDef gdef;
    private final Mapper mapper;
    private TimeAxisSetting tickSetting;
    private final double secPerPix;
    private final Calendar calendar;

    TimeAxis(RrdGraph rrdGraph, ImageWorker worker) {
        this.im = rrdGraph.im;
        this.worker = worker;
        this.gdef = rrdGraph.gdef;
        this.mapper = new Mapper(this.gdef, this.im);
        this.secPerPix = (double)(this.im.end - this.im.start) / (double)this.im.xsize;
        this.calendar = Calendar.getInstance(this.gdef.tz, this.gdef.locale);
        this.calendar.setFirstDayOfWeek(this.gdef.firstDayOfWeek);
    }

    TimeAxis(RrdGraphGenerator generator) {
        this.im = generator.im;
        this.worker = generator.worker;
        this.gdef = generator.gdef;
        this.mapper = generator.mapper;
        this.secPerPix = (double)(this.im.end - this.im.start) / (double)this.im.xsize;
        this.calendar = Calendar.getInstance(this.gdef.tz, this.gdef.locale);
        this.calendar.setFirstDayOfWeek(this.gdef.firstDayOfWeek);
    }

    @Override
    boolean draw() {
        this.chooseTickSettings();
        if (this.tickSetting == null) {
            return false;
        }
        this.drawMinor();
        this.drawMajor();
        this.drawLabels();
        return true;
    }

    private void drawMinor() {
        if (!this.gdef.noMinorGrid) {
            this.adjustStartingTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
            Paint color = this.gdef.getColor(ElementsNames.grid);
            int y0 = this.im.yorigin;
            int y1 = y0 - this.im.ysize;
            int status = this.getTimeShift();
            while (status <= 0) {
                if (status == 0) {
                    long time = this.calendar.getTime().getTime() / 1000L;
                    int x = this.mapper.xtr(time);
                    if (this.gdef.drawTicks()) {
                        this.worker.drawLine(x, y0 - 1, x, y0 + 1, color, this.gdef.tickStroke);
                    }
                    this.worker.drawLine(x, y0, x, y1, color, this.gdef.gridStroke);
                }
                this.findNextTime(this.tickSetting.minorUnit, this.tickSetting.minorUnitCount);
                status = this.getTimeShift();
            }
        }
    }

    private void drawMajor() {
        this.adjustStartingTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
        Paint color = this.gdef.getColor(ElementsNames.mgrid);
        int y0 = this.im.yorigin;
        int y1 = y0 - this.im.ysize;
        int status = this.getTimeShift();
        while (status <= 0) {
            if (status == 0) {
                long time = this.calendar.getTime().getTime() / 1000L;
                int x = this.mapper.xtr(time);
                if (this.gdef.drawTicks()) {
                    this.worker.drawLine(x, y0 - 2, x, y0 + 2, color, this.gdef.tickStroke);
                }
                this.worker.drawLine(x, y0, x, y1, color, this.gdef.gridStroke);
            }
            this.findNextTime(this.tickSetting.majorUnit, this.tickSetting.majorUnitCount);
            status = this.getTimeShift();
        }
    }

    private void drawLabels() {
        Font font = this.gdef.getFont(FONTTAG_AXIS);
        Paint color = this.gdef.getColor(ElementsNames.font);
        this.adjustStartingTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
        int y = this.im.yorigin + (int)this.worker.getFontHeight(font) + 2;
        int status = this.getTimeShift();
        while (status <= 0) {
            int labelWidth;
            int x2;
            String label = this.tickSetting.format.format(this.calendar, this.gdef.locale);
            long time = this.calendar.getTime().getTime() / 1000L;
            int x1 = this.mapper.xtr(time);
            int x = x1 + ((x2 = this.mapper.xtr(time + (long)this.tickSetting.labelSpan)) - x1 - (labelWidth = (int)this.worker.getStringWidth(label, font))) / 2;
            if (x >= this.im.xorigin && x + labelWidth <= this.im.xorigin + this.im.xsize) {
                this.worker.drawString(label, x, y, font, color);
            }
            this.findNextTime(this.tickSetting.labelUnit, this.tickSetting.labelUnitCount);
            status = this.getTimeShift();
        }
    }

    private void findNextTime(TimeUnit timeUnit, int timeUnitCount) {
        switch (timeUnit) {
            case SECOND: {
                this.calendar.add(13, timeUnitCount);
                break;
            }
            case MINUTE: {
                this.calendar.add(12, timeUnitCount);
                break;
            }
            case HOUR: {
                this.calendar.add(11, timeUnitCount);
                break;
            }
            case DAY: {
                this.calendar.add(5, timeUnitCount);
                break;
            }
            case WEEK: {
                this.calendar.add(5, 7 * timeUnitCount);
                break;
            }
            case MONTH: {
                this.calendar.add(2, timeUnitCount);
                break;
            }
            case YEAR: {
                this.calendar.add(1, timeUnitCount);
            }
        }
    }

    private int getTimeShift() {
        long time = this.calendar.getTime().getTime() / 1000L;
        return time < this.im.start ? -1 : (time > this.im.end ? 1 : 0);
    }

    private void adjustStartingTime(TimeUnit timeUnit, int timeUnitCount) {
        this.calendar.setTime(new Date(this.im.start * 1000L));
        switch (timeUnit) {
            case SECOND: {
                this.calendar.add(13, -(this.calendar.get(13) % timeUnitCount));
                break;
            }
            case MINUTE: {
                this.calendar.set(13, 0);
                this.calendar.add(12, -(this.calendar.get(12) % timeUnitCount));
                break;
            }
            case HOUR: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.add(11, -(this.calendar.get(11) % timeUnitCount));
                break;
            }
            case DAY: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                break;
            }
            case WEEK: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                int diffDays = this.calendar.get(7) - this.calendar.getFirstDayOfWeek();
                if (diffDays < 0) {
                    diffDays += 7;
                }
                this.calendar.add(5, -diffDays);
                break;
            }
            case MONTH: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.add(2, -(this.calendar.get(2) % timeUnitCount));
                break;
            }
            case YEAR: {
                this.calendar.set(13, 0);
                this.calendar.set(12, 0);
                this.calendar.set(11, 0);
                this.calendar.set(5, 1);
                this.calendar.set(2, 0);
                this.calendar.add(1, -(this.calendar.get(1) % timeUnitCount));
            }
        }
    }

    private void chooseTickSettings() {
        if (this.gdef.timeAxisSetting != null) {
            this.tickSetting = new TimeAxisSetting(this.gdef.timeAxisSetting);
        } else {
            for (TimeAxisSetting i : tickSettings) {
                if (this.secPerPix < (double)i.secPerPix) break;
                this.tickSetting = i;
            }
        }
        if (this.gdef.timeLabelFormat != null) {
            this.tickSetting = this.tickSetting.withLabelFormat(this.gdef.timeLabelFormat);
        } else {
            this.gdef.formatProvider.apply(this.tickSetting.labelUnit).ifPresent(f -> {
                this.tickSetting = this.tickSetting.withLabelFormat((TimeLabelFormat)f);
            });
        }
    }
}

