/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class ConfigurableCaret
extends DefaultCaret {
    private transient Segment seg = new Segment();
    private CaretStyle style;
    private ChangeableHighlightPainter selectionPainter;
    private boolean alwaysVisible;
    private boolean pasteOnMiddleMouseClick;
    private int selectionStart;
    private int selectionEnd;
    private SelectionType selectionType;

    public ConfigurableCaret() {
        this(CaretStyle.THICK_VERTICAL_LINE_STYLE);
    }

    public ConfigurableCaret(CaretStyle style) {
        this.setStyle(style);
        this.selectionPainter = new ChangeableHighlightPainter();
        this.pasteOnMiddleMouseClick = true;
    }

    private void adjustCaret(MouseEvent e) {
        if ((e.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(e);
        } else {
            this.positionCaret(e);
        }
    }

    private void adjustFocus(boolean inWindow) {
        RTextArea textArea = this.getTextArea();
        if (textArea != null && textArea.isEnabled() && textArea.isRequestFocusEnabled()) {
            if (inWindow) {
                textArea.requestFocusInWindow();
            } else {
                textArea.requestFocus();
            }
        }
    }

    @Override
    protected synchronized void damage(Rectangle r) {
        if (r != null) {
            this.validateWidth(r);
            this.x = r.x - 1;
            this.y = r.y;
            this.width = r.width + 4;
            this.height = r.height;
            this.repaint();
        }
    }

    @Override
    public void deinstall(JTextComponent c) {
        if (!(c instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.deinstall(c);
        c.setNavigationFilter(null);
    }

    public boolean getPasteOnMiddleMouseClick() {
        return this.pasteOnMiddleMouseClick;
    }

    protected RTextArea getTextArea() {
        return (RTextArea)this.getComponent();
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangeableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public CaretStyle getStyle() {
        return this.style;
    }

    @Override
    public void install(JTextComponent c) {
        if (!(c instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        super.install(c);
        c.setNavigationFilter(new FoldAwareNavigationFilter());
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed()) {
            RTextArea textArea = this.getTextArea();
            int nclicks = e.getClickCount();
            if (SwingUtilities.isMiddleMouseButton(e) && this.getPasteOnMiddleMouseClick() && nclicks == 1 && textArea.isEditable() && textArea.isEnabled()) {
                JTextComponent c = (JTextComponent)e.getSource();
                try {
                    Toolkit tk = c.getToolkit();
                    Clipboard buffer = tk.getSystemSelection();
                    if (buffer != null) {
                        Transferable trans;
                        this.adjustCaret(e);
                        TransferHandler th = c.getTransferHandler();
                        if (th != null && (trans = buffer.getContents(null)) != null) {
                            th.importData(c, trans);
                        }
                        this.adjustFocus(true);
                    } else {
                        textArea.paste();
                    }
                }
                catch (HeadlessException he) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        block7: {
            if (!e.isConsumed() && SwingUtilities.isLeftMouseButton(e) && (SelectionType.WORD == this.selectionType || SelectionType.LINE == this.selectionType)) {
                JTextComponent tc = this.getComponent();
                int offs = tc.viewToModel(e.getPoint());
                if (offs < 0) {
                    return;
                }
                boolean wordSelection = SelectionType.WORD == this.selectionType;
                try {
                    if (offs > this.selectionEnd) {
                        int endOffs = wordSelection ? Utilities.getWordEnd(tc, offs) : Utilities.getRowEnd(tc, offs);
                        this.select(this.selectionStart, endOffs);
                        break block7;
                    }
                    if (offs < this.selectionStart) {
                        int endOffs = wordSelection ? Utilities.getWordStart(tc, offs) : Utilities.getRowStart(tc, offs);
                        this.select(this.selectionEnd, endOffs);
                        break block7;
                    }
                    this.select(this.selectionStart, this.selectionEnd);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(tc);
                }
            } else {
                super.mouseDragged(e);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JTextComponent c;
        super.mousePressed(e);
        if (SwingUtilities.isLeftMouseButton(e)) {
            switch (e.getClickCount()) {
                case 1: {
                    this.selectionType = SelectionType.CHAR;
                    break;
                }
                case 2: {
                    if (e.isConsumed()) break;
                    this.selectionType = SelectionType.WORD;
                    break;
                }
                default: {
                    if (e.isConsumed() && !this.getComponent().getDragEnabled()) break;
                    this.selectionType = SelectionType.LINE;
                }
            }
            if (SelectionType.LINE == this.selectionType) {
                JTextComponent tc = this.getComponent();
                Action a = tc.getActionMap().get("select-line");
                a.actionPerformed(new ActionEvent(tc, 1001, null, e.getWhen(), e.getModifiers()));
            }
            if (SelectionType.WORD == this.selectionType || SelectionType.LINE == this.selectionType) {
                int dot = this.getDot();
                int mark = this.getMark();
                this.selectionStart = Math.min(dot, mark);
                this.selectionEnd = Math.max(dot, mark);
            }
        } else if (SwingUtilities.isRightMouseButton(e) && !e.isConsumed() && (c = this.getComponent()) != null && c.isEnabled() && c.isRequestFocusEnabled()) {
            c.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectionType = null;
        super.mouseReleased(e);
    }

    @Override
    public void paint(Graphics g) {
        if (this.isVisible() || this.alwaysVisible) {
            try {
                RTextArea textArea = this.getTextArea();
                g.setColor(textArea.getCaretColor());
                TextUI mapper = textArea.getUI();
                Rectangle r = mapper.modelToView(textArea, this.getDot());
                this.validateWidth(r);
                if (this.width > 0 && this.height > 0 && !this.contains(r.x, r.y, r.width, r.height)) {
                    Rectangle clip = g.getClipBounds();
                    if (clip != null && !clip.contains(this)) {
                        this.repaint();
                    }
                    this.damage(r);
                }
                r.height -= 2;
                switch (this.style) {
                    case BLOCK_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g.setXORMode(textAreaBg);
                        g.fillRect(r.x, r.y, r.width, r.height);
                        break;
                    }
                    case BLOCK_BORDER_STYLE: {
                        g.drawRect(r.x, r.y, r.width - 1, r.height);
                        break;
                    }
                    case UNDERLINE_STYLE: {
                        Color textAreaBg = textArea.getBackground();
                        if (textAreaBg == null) {
                            textAreaBg = Color.white;
                        }
                        g.setXORMode(textAreaBg);
                        int y = r.y + r.height;
                        g.drawLine(r.x, y, r.x + r.width - 1, y);
                        break;
                    }
                    default: {
                        int lineY = r.y + 1;
                        g.drawLine(r.x, lineY, r.x, lineY + r.height);
                        break;
                    }
                    case THICK_VERTICAL_LINE_STYLE: {
                        int lineY = r.y + 1;
                        g.drawLine(r.x, lineY, r.x, lineY + r.height);
                        ++r.x;
                        g.drawLine(r.x, lineY, r.x, lineY + r.height);
                        break;
                    }
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    private void select(int mark, int dot) {
        if (mark != this.getMark()) {
            this.setDot(mark);
        }
        if (dot != this.getDot()) {
            this.moveDot(dot);
        }
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        if (alwaysVisible != this.alwaysVisible) {
            this.alwaysVisible = alwaysVisible;
            if (!this.isVisible()) {
                this.repaint();
            }
        }
    }

    public void setPasteOnMiddleMouseClick(boolean paste) {
        this.pasteOnMiddleMouseClick = paste;
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        ((ChangeableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(rounded);
    }

    @Override
    public void setSelectionVisible(boolean visible) {
        super.setSelectionVisible(true);
    }

    public void setStyle(CaretStyle style) {
        if (style == null) {
            style = CaretStyle.THICK_VERTICAL_LINE_STYLE;
        }
        if (style != this.style) {
            this.style = style;
            this.repaint();
        }
    }

    private void validateWidth(Rectangle rect) {
        if (rect != null && rect.width <= 1) {
            try {
                RTextArea textArea = this.getTextArea();
                textArea.getDocument().getText(this.getDot(), 1, this.seg);
                Font font = textArea.getFont();
                FontMetrics fm = textArea.getFontMetrics(font);
                rect.width = fm.charWidth(this.seg.array[this.seg.offset]);
                if (rect.width == 0) {
                    rect.width = fm.charWidth(' ');
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                rect.width = 8;
            }
        }
    }

    private class FoldAwareNavigationFilter
    extends NavigationFilter {
        private FoldAwareNavigationFilter() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            block11: {
                RSyntaxTextArea rsta;
                RTextArea textArea = ConfigurableCaret.this.getTextArea();
                if (textArea instanceof RSyntaxTextArea && (rsta = (RSyntaxTextArea)ConfigurableCaret.this.getTextArea()).isCodeFoldingEnabled()) {
                    int lastDot = ConfigurableCaret.this.getDot();
                    FoldManager fm = rsta.getFoldManager();
                    int line = 0;
                    try {
                        line = textArea.getLineOfOffset(dot);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (fm.isLineHidden(line)) {
                        try {
                            if (dot > lastDot) {
                                int lineCount = textArea.getLineCount();
                                while (++line < lineCount && fm.isLineHidden(line)) {
                                }
                                if (line >= lineCount) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                                    return;
                                }
                                dot = textArea.getLineStartOffset(line);
                                break block11;
                            }
                            if (dot >= lastDot) break block11;
                            while (--line >= 0 && fm.isLineHidden(line)) {
                            }
                            if (line >= 0) {
                                dot = textArea.getLineEndOffset(line) - 1;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }
            }
            super.setDot(fb, dot, bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            super.moveDot(fb, dot, bias);
        }
    }

    public static enum SelectionType {
        CHAR,
        WORD,
        LINE;

    }
}

