/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.multimap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.function.multimap.BaseFunction;

public final class PutFunction<K, V>
implements BaseFunction<K, V, Void> {
    public static final AdvancedExternalizer<PutFunction> EXTERNALIZER = new Externalizer();
    private final V value;
    private final boolean supportsDuplicates;

    public PutFunction(V value, boolean supportsDuplicates) {
        this.value = value;
        this.supportsDuplicates = supportsDuplicates;
    }

    public Void apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            Bucket<V> newBucket = ((Bucket)existing.get()).add(this.value, this.supportsDuplicates);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
            }
        } else {
            entryView.set(new Bucket<V>(this.value), new MetaParam.Writable[0]);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<PutFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends PutFunction>> getTypeClasses() {
            return Collections.singleton(PutFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.PUT_KEY_VALUE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, PutFunction object) throws IOException {
            output.writeObject(object.value);
            output.writeBoolean(object.supportsDuplicates);
        }

        public PutFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new PutFunction(input.readObject(), input.readBoolean());
        }
    }
}

