/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import jakarta.xml.bind.JAXBException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.keycloak.common.util.Base64;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.SignatureType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.xml.sax.SAXException;

public class SignatureUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static void marshall(SignatureType signature, OutputStream os) throws JAXBException, SAXException {
        throw logger.notImplementedYet("NYI");
    }

    public static String getXMLSignatureAlgorithmURI(String algo) {
        String xmlSignatureAlgo = null;
        if ("DSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_DSA.get();
        } else if ("RSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_RSA.get();
        }
        return xmlSignatureAlgo;
    }

    public static byte[] sign(String stringToBeSigned, PrivateKey signingKey) throws GeneralSecurityException {
        if (stringToBeSigned == null) {
            throw logger.nullArgumentError("stringToBeSigned");
        }
        if (signingKey == null) {
            throw logger.nullArgumentError("signingKey");
        }
        String algo = signingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initSign(signingKey);
        sig.update(stringToBeSigned.getBytes(GeneralConstants.SAML_CHARSET));
        return sig.sign();
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, PublicKey validatingKey) throws GeneralSecurityException {
        if (signedContent == null) {
            throw logger.nullArgumentError("signedContent");
        }
        if (signatureValue == null) {
            throw logger.nullArgumentError("signatureValue");
        }
        if (validatingKey == null) {
            throw logger.nullArgumentError("validatingKey");
        }
        String algo = validatingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initVerify(validatingKey);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, String signatureAlgorithm, X509Certificate validatingCert) throws GeneralSecurityException {
        if (signedContent == null) {
            throw logger.nullArgumentError("signedContent");
        }
        if (signatureValue == null) {
            throw logger.nullArgumentError("signatureValue");
        }
        if (signatureAlgorithm == null) {
            throw logger.nullArgumentError("signatureAlgorithm");
        }
        if (validatingCert == null) {
            throw logger.nullArgumentError("validatingCert");
        }
        Signature sig = SignatureUtil.getSignature(signatureAlgorithm);
        sig.initVerify(validatingCert);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    public static KeyValueType createKeyValue(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey pubKey = (RSAPublicKey)key;
            byte[] modulus = pubKey.getModulus().toByteArray();
            byte[] exponent = pubKey.getPublicExponent().toByteArray();
            RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
            rsaKeyValue.setModulus(Base64.encodeBytes((byte[])modulus).getBytes(GeneralConstants.SAML_CHARSET));
            rsaKeyValue.setExponent(Base64.encodeBytes((byte[])exponent).getBytes(GeneralConstants.SAML_CHARSET));
            return rsaKeyValue;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey pubKey = (DSAPublicKey)key;
            byte[] P = pubKey.getParams().getP().toByteArray();
            byte[] Q = pubKey.getParams().getQ().toByteArray();
            byte[] G = pubKey.getParams().getG().toByteArray();
            byte[] Y = pubKey.getY().toByteArray();
            DSAKeyValueType dsaKeyValue = new DSAKeyValueType();
            dsaKeyValue.setP(Base64.encodeBytes((byte[])P).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setQ(Base64.encodeBytes((byte[])Q).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setG(Base64.encodeBytes((byte[])G).getBytes(GeneralConstants.SAML_CHARSET));
            dsaKeyValue.setY(Base64.encodeBytes((byte[])Y).getBytes(GeneralConstants.SAML_CHARSET));
            return dsaKeyValue;
        }
        throw logger.unsupportedType(key.toString());
    }

    private static Signature getSignature(String algo) throws GeneralSecurityException {
        Signature sig = null;
        if ("DSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance("SHA1withDSA");
        } else if ("RSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance("SHA1withRSA");
        } else {
            throw logger.signatureUnknownAlgo(algo);
        }
        return sig;
    }
}

