/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.Config;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.client.AuthenticatedClientSessionUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.user.UserSessionUpdater;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.listeners.RemoteUserSessionExpirationListener;
import org.keycloak.models.sessions.infinispan.remote.RemoteUserSessionProvider;
import org.keycloak.models.sessions.infinispan.remote.transaction.ClientSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.RemoteChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.remote.transaction.UserSessionTransaction;
import org.keycloak.models.sessions.infinispan.transaction.InfinispanTransactionProvider;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class RemoteUserSessionProviderFactory
implements UserSessionProviderFactory<RemoteUserSessionProvider>,
EnvironmentDependentProviderFactory,
ProviderEventListener,
ServerInfoAwareProviderFactory {
    private static final int DEFAULT_BATCH_SIZE = 1024;
    private static final String CONFIG_MAX_BATCH_SIZE = "batchSize";
    private volatile SharedStateImpl<String, RemoteUserSessionEntity> userSessionState;
    private volatile SharedStateImpl<String, RemoteUserSessionEntity> offlineUserSessionState;
    private volatile SharedStateImpl<ClientSessionKey, RemoteAuthenticatedClientSessionEntity> clientSessionState;
    private volatile SharedStateImpl<ClientSessionKey, RemoteAuthenticatedClientSessionEntity> offlineClientSessionState;
    private volatile BlockingManager blockingManager;
    private volatile int batchSize = 1024;
    private volatile int maxRetries = 10;
    private volatile int backOffBaseTimeMillis = 10;
    private volatile RemoteUserSessionExpirationListener expirationListener;

    public RemoteUserSessionProvider create(KeycloakSession session) {
        InfinispanTransactionProvider provider = (InfinispanTransactionProvider)session.getProvider(InfinispanTransactionProvider.class);
        UserSessionTransaction tx = this.createTransaction(session);
        provider.registerTransaction(tx);
        return new RemoteUserSessionProvider(session, tx, this.batchSize);
    }

    public void init(Config.Scope config) {
        this.batchSize = Math.max(1, config.getInt(CONFIG_MAX_BATCH_SIZE, Integer.valueOf(1024)));
        this.maxRetries = InfinispanUtils.getMaxRetries(config);
        this.backOffBaseTimeMillis = InfinispanUtils.getRetryBaseTimeMillis(config);
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            this.lazyInit(session);
        }
        factory.register((ProviderEventListener)this);
    }

    public void close() {
        if (this.expirationListener != null) {
            this.userSessionState.cache().removeClientListener((Object)this.expirationListener);
            this.offlineUserSessionState.cache().removeClientListener((Object)this.expirationListener);
        }
        this.expirationListener = null;
        this.blockingManager = null;
        this.userSessionState = null;
        this.offlineUserSessionState = null;
        this.clientSessionState = null;
        this.offlineClientSessionState = null;
    }

    public String getId() {
        return "remote";
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isRemoteInfinispan() && !MultiSiteUtils.isPersistentSessionsEnabled();
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(CONFIG_MAX_BATCH_SIZE).type("int").helpText("Batch size when streaming session from the remote cache").defaultValue((Object)1024).add();
        InfinispanUtils.configureMaxRetries(builder);
        InfinispanUtils.configureRetryBaseTime(builder);
        return builder.build();
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CONFIG_MAX_BATCH_SIZE, Integer.toString(this.batchSize));
        InfinispanUtils.maxRetriesToOperationalInfo(map, this.maxRetries);
        InfinispanUtils.retryBaseTimeMillisToOperationalInfo(map, this.backOffBaseTimeMillis);
        return map;
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof UserModel.UserRemovedEvent) {
            UserModel.UserRemovedEvent ure = (UserModel.UserRemovedEvent)event;
            this.onUserRemoved(ure);
        }
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanTransactionProvider.class, InfinispanConnectionProvider.class);
    }

    private void onUserRemoved(UserModel.UserRemovedEvent event) {
        ((UserSessionProvider)event.getKeycloakSession().getProvider(UserSessionProvider.class, this.getId())).removeUserSessions(event.getRealm(), event.getUser());
        ((UserSessionPersisterProvider)event.getKeycloakSession().getProvider(UserSessionPersisterProvider.class)).onUserRemoved(event.getRealm(), event.getUser());
    }

    private void lazyInit(KeycloakSession session) {
        if (this.blockingManager != null) {
            return;
        }
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.userSessionState = new SharedStateImpl(connections.getRemoteCache("sessions"));
        this.offlineUserSessionState = new SharedStateImpl(connections.getRemoteCache("offlineSessions"));
        this.clientSessionState = new SharedStateImpl(connections.getRemoteCache("clientSessions"));
        this.offlineClientSessionState = new SharedStateImpl(connections.getRemoteCache("offlineClientSessions"));
        this.blockingManager = connections.getBlockingManager();
        this.expirationListener = new RemoteUserSessionExpirationListener(session.getKeycloakSessionFactory(), this.blockingManager, this.userSessionState.cache().getRemoteCacheContainer().getMarshaller());
        this.userSessionState.cache().addClientListener((Object)this.expirationListener);
        this.offlineUserSessionState.cache().addClientListener((Object)this.expirationListener);
    }

    private UserSessionTransaction createTransaction(KeycloakSession session) {
        this.lazyInit(session);
        return new UserSessionTransaction(new UserSessionChangeLogTransaction(UserSessionUpdater.onlineFactory(), this.userSessionState), new UserSessionChangeLogTransaction(UserSessionUpdater.offlineFactory(), this.offlineUserSessionState), new ClientSessionChangeLogTransaction(AuthenticatedClientSessionUpdater.onlineFactory(), this.clientSessionState), new ClientSessionChangeLogTransaction(AuthenticatedClientSessionUpdater.offlineFactory(), this.offlineClientSessionState));
    }

    private class SharedStateImpl<K, V>
    implements RemoteChangeLogTransaction.SharedState<K, V> {
        private final RemoteCache<K, V> cache;

        private SharedStateImpl(RemoteCache<K, V> cache) {
            this.cache = cache;
        }

        @Override
        public RemoteCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public int maxRetries() {
            return RemoteUserSessionProviderFactory.this.maxRetries;
        }

        @Override
        public int backOffBaseTimeMillis() {
            return RemoteUserSessionProviderFactory.this.backOffBaseTimeMillis;
        }

        @Override
        public BlockingManager blockingManager() {
            return RemoteUserSessionProviderFactory.this.blockingManager;
        }
    }
}

