/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipContentLocation
implements ContentLocation {
    private HashMap entries;
    private String name;
    private String contentId;
    private ContentLocation parent;
    private ZipRepository repository;
    private String comment;
    private long time;

    public ZipContentLocation(ZipRepository repository, ContentLocation parent, String name) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.name = name;
        this.entries = new HashMap();
        this.contentId = RepositoryUtilities.buildName(this, "/") + '/';
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        ContentEntity contentEntity = (ContentEntity)this.entries.get(name);
        if (contentEntity == null) {
            throw new ContentIOException("Not found:" + name);
        }
        return contentEntity;
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("Entry already exists");
        }
        if (RepositoryUtilities.isInvalidPathName(name)) {
            throw new ContentCreationException("Entry-Name is not valid");
        }
        ZipContentItem item = new ZipContentItem(name, this.repository, this);
        this.entries.put(name, item);
        return item;
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("Entry already exists");
        }
        if (RepositoryUtilities.isInvalidPathName(name)) {
            throw new ContentCreationException("Entry-Name is not valid");
        }
        ZipContentLocation item = new ZipContentLocation(this.repository, this, name);
        this.entries.put(name, item);
        if (!"/".equals(this.contentId)) {
            try {
                ZipEntry entry = new ZipEntry(this.contentId + name + '/');
                this.repository.writeDirectory(entry);
            }
            catch (IOException e) {
                throw new ContentCreationException("Failed to create directory.", e);
            }
        }
        return item;
    }

    @Override
    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return this.contentId;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            return this.comment;
        }
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                if (value instanceof Date) {
                    Date n = (Date)value;
                    this.time = n.getTime();
                    return true;
                }
                if (value instanceof Number) {
                    Number n = (Number)value;
                    this.time = n.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            if (value != null) {
                this.comment = String.valueOf(value);
                return true;
            }
            this.comment = null;
            return true;
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

