/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class SuppliedParameterReference
extends Expression {
    int slotNumber;
    SequenceType type;

    public SuppliedParameterReference(int slot) {
        this.slotNumber = slot;
    }

    public SuppliedParameterReference(int slot, Container container) {
        this.slotNumber = slot;
        this.setContainer(container);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSuppliedType(SequenceType type) {
        this.type = type;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public ItemType getItemType() {
        if (this.type != null) {
            return this.type.getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    public int getIntrinsicDependencies() {
        return 128;
    }

    public int computeCardinality() {
        if (this.type != null) {
            return this.type.getCardinality();
        }
        return 57344;
    }

    public Expression copy() {
        return new SuppliedParameterReference(this.slotNumber);
    }

    public Sequence evaluateVariable(XPathContext c) throws XPathException {
        if (this.slotNumber == -1) {
            return c.getStackFrame().popDynamicValue();
        }
        try {
            return c.evaluateLocalVariable(this.slotNumber);
        }
        catch (AssertionError e) {
            StandardErrorListener.printStackTrace(c.getConfiguration().getLogger(), c);
            throw new AssertionError((Object)(((Throwable)((Object)e)).getMessage() + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.evaluateVariable(context).iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.evaluateVariable(context).head();
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("suppliedParam");
        destination.emitAttribute("slot", this.slotNumber + "");
        destination.endElement();
    }

    public String toString() {
        return "suppliedParam(" + this.slotNumber + ")";
    }
}

