/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.AbstractBufferMemoryIO;
import jnr.ffi.provider.jffi.MemoryUtil;

public class ByteBufferMemoryIO
extends AbstractBufferMemoryIO {
    public ByteBufferMemoryIO(Runtime runtime2, ByteBuffer buffer) {
        super(runtime2, buffer, ByteBufferMemoryIO.address(buffer));
    }

    @Override
    public Pointer getPointer(long offset2) {
        return MemoryUtil.newPointer(this.getRuntime(), this.getAddress(offset2));
    }

    @Override
    public Pointer getPointer(long offset2, long size2) {
        return MemoryUtil.newPointer(this.getRuntime(), this.getAddress(offset2), size2);
    }

    @Override
    public void putPointer(long offset2, Pointer value2) {
        this.putAddress(offset2, value2 != null ? value2.address() : 0L);
    }

    private static long address(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            long address2 = MemoryIO.getInstance().getDirectBufferAddress(buffer);
            return address2 != 0L ? address2 + (long)buffer.position() : 0L;
        }
        return 0L;
    }
}

