/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.event;

import com.google.gson.Gson;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.websocket.WebSocketAdapter;
import org.openhab.core.io.websocket.event.EventWebSocket;
import org.openhab.core.io.websocket.event.ItemEventUtility;
import org.openhab.core.items.ItemRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(immediate=true, service={EventSubscriber.class, WebSocketAdapter.class})
public class EventWebSocketAdapter
implements EventSubscriber,
WebSocketAdapter {
    public static final String ADAPTER_ID = "event-subscriber";
    private final Gson gson = new Gson();
    private final EventPublisher eventPublisher;
    private final ItemEventUtility itemEventUtility;
    private final Set<EventWebSocket> webSockets = new CopyOnWriteArraySet<EventWebSocket>();

    @Activate
    public EventWebSocketAdapter(@Reference EventPublisher eventPublisher, @Reference ItemRegistry itemRegistry) {
        this.eventPublisher = eventPublisher;
        this.itemEventUtility = new ItemEventUtility(this.gson, itemRegistry);
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of("ALL");
    }

    public void receive(Event event) {
        this.webSockets.forEach(ws -> ws.processEvent(event));
    }

    public void registerListener(EventWebSocket eventWebSocket) {
        this.webSockets.add(eventWebSocket);
    }

    public void unregisterListener(EventWebSocket eventWebSocket) {
        this.webSockets.remove(eventWebSocket);
    }

    @Override
    public String getId() {
        return ADAPTER_ID;
    }

    @Override
    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        return new EventWebSocket(this.gson, this, this.itemEventUtility, this.eventPublisher);
    }
}

