/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.shard_stores;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.NodeAttributes;
import org.opensearch.client.opensearch.indices.shard_stores.ShardStoreAllocation;
import org.opensearch.client.opensearch.indices.shard_stores.ShardStoreException;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardStore
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardStore> {
    @Nonnull
    private final ShardStoreAllocation allocation;
    @Nullable
    private final String allocationId;
    @Nonnull
    private final Map<String, NodeAttributes> nodes;
    @Nullable
    private final ShardStoreException storeException;
    public static final JsonpDeserializer<ShardStore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStore::setupShardStoreDeserializer);

    private ShardStore(Builder builder) {
        this.allocation = ApiTypeHelper.requireNonNull(builder.allocation, this, "allocation");
        this.allocationId = builder.allocationId;
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.storeException = builder.storeException;
    }

    public static ShardStore of(Function<Builder, ObjectBuilder<ShardStore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final ShardStoreAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public final String allocationId() {
        return this.allocationId;
    }

    @Nonnull
    public final Map<String, NodeAttributes> nodes() {
        return this.nodes;
    }

    @Nullable
    public final ShardStoreException storeException() {
        return this.storeException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, NodeAttributes> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeKey("allocation");
        this.allocation.serialize(generator, mapper);
        if (this.allocationId != null) {
            generator.writeKey("allocation_id");
            generator.write(this.allocationId);
        }
        if (this.storeException != null) {
            generator.writeKey("store_exception");
            this.storeException.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardStoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocation, ShardStoreAllocation._DESERIALIZER, "allocation");
        op.add(Builder::allocationId, JsonpDeserializer.stringDeserializer(), "allocation_id");
        op.add(Builder::storeException, ShardStoreException._DESERIALIZER, "store_exception");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).nodes == null) {
                ((Builder)builder).nodes = new HashMap();
            }
            ((Builder)builder).nodes.put(name, NodeAttributes._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.allocation.hashCode();
        result = 31 * result + Objects.hashCode(this.allocationId);
        result = 31 * result + Objects.hashCode(this.nodes);
        result = 31 * result + Objects.hashCode(this.storeException);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardStore other = (ShardStore)o;
        return this.allocation.equals(other.allocation) && Objects.equals(this.allocationId, other.allocationId) && Objects.equals(this.nodes, other.nodes) && Objects.equals(this.storeException, other.storeException);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardStore> {
        private ShardStoreAllocation allocation;
        @Nullable
        private String allocationId;
        @Nullable
        private Map<String, NodeAttributes> nodes;
        @Nullable
        private ShardStoreException storeException;

        public Builder() {
        }

        private Builder(ShardStore o) {
            this.allocation = o.allocation;
            this.allocationId = o.allocationId;
            this.nodes = Builder._mapCopy(o.nodes);
            this.storeException = o.storeException;
        }

        private Builder(Builder o) {
            this.allocation = o.allocation;
            this.allocationId = o.allocationId;
            this.nodes = Builder._mapCopy(o.nodes);
            this.storeException = o.storeException;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allocation(ShardStoreAllocation value) {
            this.allocation = value;
            return this;
        }

        @Nonnull
        public final Builder allocationId(@Nullable String value) {
            this.allocationId = value;
            return this;
        }

        @Nonnull
        public final Builder nodes(Map<String, NodeAttributes> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, NodeAttributes value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        @Nonnull
        public final Builder nodes(String key, Function<NodeAttributes.Builder, ObjectBuilder<NodeAttributes>> fn) {
            return this.nodes(key, fn.apply(new NodeAttributes.Builder()).build());
        }

        @Nonnull
        public final Builder storeException(@Nullable ShardStoreException value) {
            this.storeException = value;
            return this;
        }

        @Nonnull
        public final Builder storeException(Function<ShardStoreException.Builder, ObjectBuilder<ShardStoreException>> fn) {
            return this.storeException(fn.apply(new ShardStoreException.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardStore build() {
            this._checkSingleUse();
            return new ShardStore(this);
        }
    }
}

