/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.dafny.conversion;

import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ToNative {

    public static class Aggregate {
        public static <T, R> List<R> GenericToList(DafnySequence<T> dafnyValues, Function<T, R> converter) {
            ArrayList returnList = new ArrayList(dafnyValues.length());
            dafnyValues.forEach(value -> returnList.add(converter.apply(value)));
            return returnList;
        }

        public static <T, R> Set<R> GenericToSet(DafnySet<T> dafnyValues, Function<T, R> converter) {
            LinkedHashSet returnSet = new LinkedHashSet(dafnyValues.size(), 1.0f);
            dafnyValues.Elements().forEach(value -> returnSet.add(converter.apply(value)));
            return returnSet;
        }

        public static <IN_KEY, IN_VALUE, OUT_KEY, OUT_VALUE> Map<OUT_KEY, OUT_VALUE> GenericToMap(DafnyMap<IN_KEY, IN_VALUE> dafnyValues, Function<IN_KEY, OUT_KEY> keyConverter, Function<IN_VALUE, OUT_VALUE> valueConverter) {
            LinkedHashMap returnMap = new LinkedHashMap(dafnyValues.size(), 1.0f);
            dafnyValues.forEach((k, v) -> returnMap.put(keyConverter.apply(k), valueConverter.apply(v)));
            return returnMap;
        }
    }

    public static class Simple {
        public static ByteBuffer ByteBuffer(DafnySequence<? extends Byte> dafnySequence) {
            return ByteBuffer.wrap((byte[])dafnySequence.toRawArray());
        }

        public static String String(DafnySequence<? extends Character> dafnySequence) {
            Stream<Character> chars = StreamSupport.stream(dafnySequence.spliterator(), false);
            return chars.map(Object::toString).collect(Collectors.joining());
        }

        public static Double Double(DafnySequence<? extends Byte> dafnySequence) {
            return Simple.ByteBuffer(dafnySequence).getDouble();
        }

        public static Date Date(DafnySequence<? extends Character> dafnySequence) {
            BigDecimal dateValue = new BigDecimal(Simple.String(dafnySequence));
            return new Date(dateValue.scaleByPowerOfTen(3).longValue());
        }

        public static Instant Instant(DafnySequence<? extends Character> dafnySequence) {
            BigDecimal dateValue = new BigDecimal(Simple.String(dafnySequence));
            return Instant.ofEpochMilli(dateValue.scaleByPowerOfTen(3).longValue());
        }

        public static String DafnyUtf8Bytes(DafnySequence<? extends Byte> dafnySequence) {
            Charset utf8 = StandardCharsets.UTF_8;
            CharsetDecoder coder = utf8.newDecoder();
            ByteBuffer inBuffer = Simple.ByteBuffer(dafnySequence);
            inBuffer.position(0);
            try {
                CharBuffer outBuffer = coder.decode(inBuffer);
                outBuffer.position(0);
                return outBuffer.toString();
            }
            catch (CharacterCodingException ex) {
                throw new RuntimeException("Could not encode input to Dafny Bytes.", ex);
            }
        }
    }
}

