/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

public class DefaultCache {
    private final int entryCapacity;

    protected DefaultCache(BuilderImpl builder) {
        this.entryCapacity = builder.entryCapacity();
    }

    public int entryCapacity() {
        return this.entryCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected int entryCapacity;
        private boolean _entryCapacitySet = false;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DefaultCache model) {
            this.entryCapacity = model.entryCapacity();
            this._entryCapacitySet = true;
        }

        @Override
        public Builder entryCapacity(int entryCapacity) {
            this.entryCapacity = entryCapacity;
            this._entryCapacitySet = true;
            return this;
        }

        @Override
        public int entryCapacity() {
            return this.entryCapacity;
        }

        @Override
        public DefaultCache build() {
            if (!this._entryCapacitySet) {
                throw new IllegalArgumentException("Missing value for required field `entryCapacity`");
            }
            if (this._entryCapacitySet && this.entryCapacity() < 1) {
                throw new IllegalArgumentException("`entryCapacity` must be greater than or equal to 1");
            }
            return new DefaultCache(this);
        }
    }

    public static interface Builder {
        public Builder entryCapacity(int var1);

        public int entryCapacity();

        public DefaultCache build();
    }
}

