/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.panama;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.ref.Cleaner;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLLibrary;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.panama.OpenSSLX509Certificate;
import org.apache.tomcat.util.openssl.SSL_CTX_set_verify$callback;
import org.apache.tomcat.util.openssl.SSL_set_info_callback$cb;
import org.apache.tomcat.util.openssl.SSL_set_verify$callback;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Compatibility;
import org.apache.tomcat.util.openssl.openssl_h_Macros;
import org.apache.tomcat.util.res.StringManager;

public final class OpenSSLEngine
extends SSLEngine
implements SSLUtil.ProtocolInfo {
    private static final Log log = LogFactory.getLog(OpenSSLEngine.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLEngine.class);
    private static final Certificate[] EMPTY_CERTIFICATES = new Certificate[0];
    public static final Set<String> AVAILABLE_CIPHER_SUITES;
    public static final Set<String> IMPLEMENTED_PROTOCOLS_SET;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    private static final int OCSP_MAX_SKEW = 900;
    private static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final ConcurrentHashMap<Long, EngineState> states;
    private final EngineState state;
    private final Arena engineArena;
    private final Cleaner.Cleanable cleanable;
    private MemorySegment bufSegment;
    private Accepted accepted = Accepted.NOT;
    private boolean handshakeFinished;
    private int currentHandshake;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String version;
    private volatile String cipher;
    private volatile String applicationProtocol;
    private volatile Certificate[] peerCerts;
    private volatile ClientAuthMode clientAuth = ClientAuthMode.NONE;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private boolean sendHandshakeError = false;
    private final boolean clientMode;
    private final String fallbackApplicationProtocol;
    private final OpenSSLSessionContext sessionContext;
    private final boolean alpn;
    private final boolean initialized;
    private final boolean certificateVerificationOptionalNoCA;
    private String selectedProtocol = null;
    private final OpenSSLSession session;
    private static final int ASN1_SEQUENCE = 48;
    private static final int ASN1_OID = 6;
    private static final int ASN1_STRING = 134;
    private static final byte[] OCSP_OID;

    private static EngineState getState(MemorySegment ssl) {
        return states.get(ssl.address());
    }

    OpenSSLEngine(Cleaner cleaner, MemorySegment sslCtx, String fallbackApplicationProtocol, boolean clientMode, OpenSSLSessionContext sessionContext, boolean alpn, boolean initialized, int certificateVerificationDepth, boolean certificateVerificationOptionalNoCA, boolean noOcspCheck, boolean ocspSoftFail, int ocspTimeout, int ocspVerifyFlags) {
        if (sslCtx == null) {
            throw new IllegalArgumentException(sm.getString("engine.noSSLContext"));
        }
        this.engineArena = Arena.ofAuto();
        this.bufSegment = this.engineArena.allocate(18713L);
        this.session = new OpenSSLSession();
        MemorySegment ssl = openssl_h.SSL_new(sslCtx);
        openssl_h.SSL_set_info_callback(ssl, SSL_set_info_callback$cb.allocate(new InfoCallback(), this.engineArena));
        if (clientMode) {
            openssl_h.SSL_set_connect_state(ssl);
        } else {
            openssl_h.SSL_set_accept_state(ssl);
        }
        openssl_h_Compatibility.SSL_set_verify_result(ssl, openssl_h.X509_V_OK());
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment internalBIOPointer = localArena.allocate(ValueLayout.ADDRESS);
            MemorySegment networkBIOPointer = localArena.allocate(ValueLayout.ADDRESS);
            openssl_h.BIO_new_bio_pair(internalBIOPointer, 0L, networkBIOPointer, 0L);
            MemorySegment internalBIO = internalBIOPointer.get(ValueLayout.ADDRESS, 0L);
            MemorySegment networkBIO = networkBIOPointer.get(ValueLayout.ADDRESS, 0L);
            openssl_h.SSL_set_bio(ssl, internalBIO, internalBIO);
            this.state = new EngineState(ssl, networkBIO, certificateVerificationDepth, noOcspCheck, ocspSoftFail, ocspTimeout, ocspVerifyFlags);
        }
        this.fallbackApplicationProtocol = fallbackApplicationProtocol;
        this.clientMode = clientMode;
        this.sessionContext = sessionContext;
        this.alpn = alpn;
        this.initialized = initialized;
        this.certificateVerificationOptionalNoCA = certificateVerificationOptionalNoCA;
        this.cleanable = cleaner.register(this, this.state);
    }

    public String getNegotiatedProtocol() {
        return this.selectedProtocol;
    }

    public synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.cleanable.clean();
            this.engineClosed = true;
            this.isOutboundDone = true;
            this.isInboundDone = true;
            this.bufSegment = null;
        }
    }

    private int writePlaintextData(MemorySegment ssl, ByteBuffer src) throws SSLException {
        int sslWrote;
        MemorySegment srcSegment;
        OpenSSLEngine.clearLastError();
        int pos = src.position();
        int len = Math.min(src.remaining(), 16384);
        MemorySegment memorySegment = srcSegment = src.isDirect() ? MemorySegment.ofBuffer(src) : this.bufSegment;
        if (!src.isDirect()) {
            MemorySegment.copy(src.array(), pos, this.bufSegment, ValueLayout.JAVA_BYTE, 0L, len);
        }
        if ((sslWrote = openssl_h.SSL_write(ssl, srcSegment, len)) > 0) {
            src.position(pos + sslWrote);
            return sslWrote;
        }
        this.checkLastError();
        return 0;
    }

    private int writeEncryptedData(MemorySegment networkBIO, ByteBuffer src) throws SSLException {
        int netWrote;
        MemorySegment srcSegment;
        OpenSSLEngine.clearLastError();
        int pos = src.position();
        int len = src.remaining();
        MemorySegment memorySegment = srcSegment = src.isDirect() ? MemorySegment.ofBuffer(src) : this.bufSegment;
        if (!src.isDirect()) {
            MemorySegment.copy(src.array(), pos, this.bufSegment, ValueLayout.JAVA_BYTE, 0L, len);
        }
        if ((netWrote = openssl_h.BIO_write(networkBIO, srcSegment, len)) > 0) {
            src.position(pos + netWrote);
            return netWrote;
        }
        this.checkLastError();
        return 0;
    }

    private int readPlaintextData(MemorySegment ssl, ByteBuffer dst) throws SSLException {
        OpenSSLEngine.clearLastError();
        int pos = dst.position();
        int len = Math.min(dst.remaining(), 18713);
        MemorySegment dstSegment = dst.isDirect() ? MemorySegment.ofBuffer(dst) : this.bufSegment;
        int sslRead = openssl_h.SSL_read(ssl, dstSegment, len);
        if (sslRead > 0) {
            if (!dst.isDirect()) {
                MemorySegment.copy(dstSegment, ValueLayout.JAVA_BYTE, 0L, dst.array(), pos, sslRead);
            }
            dst.position(pos + sslRead);
            return sslRead;
        }
        this.checkLastError();
        return 0;
    }

    private int readEncryptedData(MemorySegment networkBIO, ByteBuffer dst, int pending) throws SSLException {
        OpenSSLEngine.clearLastError();
        int pos = dst.position();
        MemorySegment dstSegment = dst.isDirect() ? MemorySegment.ofBuffer(dst) : this.bufSegment;
        int bioRead = openssl_h.BIO_read(networkBIO, dstSegment, pending);
        if (bioRead > 0) {
            if (!dst.isDirect()) {
                MemorySegment.copy(dstSegment, ValueLayout.JAVA_BYTE, 0L, dst.array(), pos, bioRead);
            }
            dst.position(pos + bioRead);
            return bioRead;
        }
        this.checkLastError();
        return 0;
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (srcs == null || dst == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= srcs.length || offset + length > srcs.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(srcs.length)}));
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        }
        int bytesProduced = 0;
        int pendingNet = (int)openssl_h.BIO_ctrl_pending(this.state.networkBIO);
        if (pendingNet > 0) {
            int capacity = dst.remaining();
            if (capacity < pendingNet) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
            }
            try {
                bytesProduced = this.readEncryptedData(this.state.networkBIO, dst, pendingNet);
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
            if (this.isOutboundDone()) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), 0, bytesProduced);
        }
        int bytesConsumed = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer src = srcs[i];
            if (src == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            while (src.hasRemaining()) {
                int bytesWritten;
                try {
                    bytesWritten = this.writePlaintextData(this.state.ssl, src);
                    bytesConsumed += bytesWritten;
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesWritten == 0) {
                    throw new IllegalStateException(sm.getString("engine.failedToWriteBytes"));
                }
                pendingNet = (int)openssl_h.BIO_ctrl_pending(this.state.networkBIO);
                if (pendingNet <= 0) continue;
                int capacity = dst.remaining();
                if (capacity < pendingNet) {
                    return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesProduced);
                }
                try {
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced += this.readEncryptedData(this.state.networkBIO, dst, pendingNet));
            }
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        int written;
        if (this.destroyed) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
        }
        if (src == null || dsts == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullBuffer"));
        }
        if (offset >= dsts.length || offset + length > dsts.length) {
            throw new IndexOutOfBoundsException(sm.getString("engine.invalidBufferArray", new Object[]{Integer.toString(offset), Integer.toString(length), Integer.toString(dsts.length)}));
        }
        int capacity = 0;
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullBufferInArray"));
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            capacity += dst.remaining();
        }
        if (this.accepted == Accepted.NOT) {
            this.beginHandshakeImplicitly();
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if ((!this.handshakeFinished || this.engineClosed) && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            return new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        }
        int len = src.remaining();
        if (len > 18713) {
            this.shutdown();
            throw new SSLException(sm.getString("engine.oversizedPacket"));
        }
        try {
            written = this.writeEncryptedData(this.state.networkBIO, src);
        }
        catch (Exception e) {
            throw new SSLException(e);
        }
        int pendingApp = this.pendingReadableBytesInSSL();
        if (!this.handshakeFinished) {
            pendingApp = 0;
        }
        int bytesProduced = 0;
        int idx = offset;
        if (capacity == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), written, 0);
        }
        while (pendingApp > 0) {
            if (idx == endOffset) {
                throw new IllegalStateException(sm.getString("engine.invalidDestinationBuffersState"));
            }
            while (idx < endOffset) {
                int bytesRead;
                ByteBuffer dst = dsts[idx];
                if (!dst.hasRemaining()) {
                    ++idx;
                    continue;
                }
                if (pendingApp <= 0) break;
                try {
                    bytesRead = this.readPlaintextData(this.state.ssl, dst);
                }
                catch (Exception e) {
                    throw new SSLException(e);
                }
                if (bytesRead == 0) {
                    throw new IllegalStateException(sm.getString("engine.failedToReadAvailableBytes"));
                }
                bytesProduced += bytesRead;
                pendingApp -= bytesRead;
                capacity -= bytesRead;
                if (dst.hasRemaining()) continue;
                ++idx;
            }
            if (capacity == 0) break;
            if (pendingApp != 0) continue;
            pendingApp = this.pendingReadableBytesInSSL();
        }
        if (!this.receivedShutdown && (openssl_h.SSL_get_shutdown(this.state.ssl) & openssl_h.SSL_RECEIVED_SHUTDOWN()) == openssl_h.SSL_RECEIVED_SHUTDOWN()) {
            this.receivedShutdown = true;
            this.closeInbound();
        }
        if (bytesProduced == 0 && (written == 0 || written > 0 && !src.hasRemaining() && this.handshakeFinished)) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), written, 0);
        }
        return new SSLEngineResult(this.getEngineStatus(), this.getHandshakeStatus(), written, bytesProduced);
    }

    private int pendingReadableBytesInSSL() throws SSLException {
        OpenSSLEngine.clearLastError();
        int lastPrimingReadResult = openssl_h.SSL_read(this.state.ssl, MemorySegment.NULL, 0);
        if (lastPrimingReadResult <= 0) {
            this.checkLastError();
        }
        int pendingReadableBytesInSSL = openssl_h.SSL_pending(this.state.ssl);
        if ("TLSv1".equals(this.version) && lastPrimingReadResult == 0 && pendingReadableBytesInSSL == 0) {
            lastPrimingReadResult = openssl_h.SSL_read(this.state.ssl, MemorySegment.NULL, 0);
            if (lastPrimingReadResult <= 0) {
                this.checkLastError();
            }
            pendingReadableBytesInSSL = openssl_h.SSL_pending(this.state.ssl);
        }
        return pendingReadableBytesInSSL;
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.accepted != Accepted.NOT && !this.receivedShutdown) {
            throw new SSLException(sm.getString("engine.inboundClose"));
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.isOutboundDone) {
            return;
        }
        this.isOutboundDone = true;
        this.engineClosed = true;
        if (this.accepted != Accepted.NOT && !this.destroyed) {
            int mode = openssl_h.SSL_get_shutdown(this.state.ssl);
            if ((mode & openssl_h.SSL_SENT_SHUTDOWN()) != openssl_h.SSL_SENT_SHUTDOWN()) {
                openssl_h.SSL_shutdown(this.state.ssl);
            }
        } else {
            this.shutdown();
        }
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return AVAILABLE_CIPHER_SUITES.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        if (this.destroyed) {
            return new String[0];
        }
        String[] enabled = OpenSSLLibrary.getCiphers(this.state.ssl);
        for (int i = 0; i < enabled.length; ++i) {
            String mapped = OpenSSLCipherConfigurationParser.openSSLToJsse((String)enabled[i]);
            if (mapped == null) continue;
            enabled[i] = mapped;
        }
        return enabled;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] cipherSuites) {
        if (this.initialized) {
            return;
        }
        if (cipherSuites == null) {
            throw new IllegalArgumentException(sm.getString("engine.nullCipherSuite"));
        }
        if (this.destroyed) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String cipherSuite : cipherSuites) {
            if (cipherSuite == null) break;
            String converted = OpenSSLCipherConfigurationParser.jsseToOpenSSL((String)cipherSuite);
            if (!AVAILABLE_CIPHER_SUITES.contains(cipherSuite)) {
                log.debug((Object)sm.getString("engine.unsupportedCipher", new Object[]{cipherSuite, converted}));
            }
            if (converted != null) {
                cipherSuite = converted;
            }
            buf.append(cipherSuite);
            buf.append(':');
        }
        if (buf.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("engine.emptyCipherSuite"));
        }
        buf.setLength(buf.length() - 1);
        String cipherSuiteSpec = buf.toString();
        try (Arena localArena = Arena.ofConfined();){
            openssl_h.SSL_set_cipher_list(this.state.ssl, localArena.allocateFrom(cipherSuiteSpec));
        }
        catch (Exception e) {
            throw new IllegalStateException(sm.getString("engine.failedCipherSuite", new Object[]{cipherSuiteSpec}), e);
        }
    }

    @Override
    public String[] getSupportedProtocols() {
        return IMPLEMENTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        if (this.destroyed) {
            return new String[0];
        }
        ArrayList<String> enabled = new ArrayList<String>();
        enabled.add("SSLv2Hello");
        long opts = openssl_h_Compatibility.SSL_get_options(this.state.ssl);
        if ((opts & openssl_h.SSL_OP_NO_TLSv1()) == 0L) {
            enabled.add("TLSv1");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_1()) == 0L) {
            enabled.add("TLSv1.1");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_2()) == 0L) {
            enabled.add("TLSv1.2");
        }
        if ((opts & openssl_h.SSL_OP_NO_TLSv1_3()) == 0L) {
            enabled.add("TLSv1.3");
        }
        if ((opts & (long)openssl_h.SSL_OP_NO_SSLv2()) == 0L) {
            enabled.add("SSLv2");
        }
        if ((opts & openssl_h.SSL_OP_NO_SSLv3()) == 0L) {
            enabled.add("SSLv3");
        }
        int size = enabled.size();
        return enabled.toArray(new String[size]);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (this.initialized) {
            return;
        }
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        if (this.destroyed) {
            return;
        }
        boolean sslv2 = false;
        boolean sslv3 = false;
        boolean tlsv1 = false;
        boolean tlsv1_1 = false;
        boolean tlsv1_2 = false;
        boolean tlsv1_3 = false;
        block16: for (String p : protocols) {
            if (!IMPLEMENTED_PROTOCOLS_SET.contains(p)) {
                throw new IllegalArgumentException(sm.getString("engine.unsupportedProtocol", new Object[]{p}));
            }
            switch (p) {
                case "SSLv2": {
                    sslv2 = true;
                    continue block16;
                }
                case "SSLv3": {
                    sslv3 = true;
                    continue block16;
                }
                case "TLSv1": {
                    tlsv1 = true;
                    continue block16;
                }
                case "TLSv1.1": {
                    tlsv1_1 = true;
                    continue block16;
                }
                case "TLSv1.2": {
                    tlsv1_2 = true;
                    continue block16;
                }
                case "TLSv1.3": {
                    tlsv1_3 = true;
                }
            }
        }
        openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_ALL());
        if (!sslv2) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_SSLv2());
        }
        if (!sslv3) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_SSLv3());
        }
        if (!tlsv1) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1());
        }
        if (!tlsv1_1) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_1());
        }
        if (!tlsv1_2) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_2());
        }
        if (!tlsv1_3) {
            openssl_h_Compatibility.SSL_set_options(this.state.ssl, openssl_h.SSL_OP_NO_TLSv1_3());
        }
    }

    @Override
    public SSLSession getSession() {
        return this.session;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.engineClosed || this.destroyed) {
            throw new SSLException(sm.getString("engine.engineClosed"));
        }
        switch (this.accepted.ordinal()) {
            case 0: {
                this.handshake();
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case 1: {
                this.accepted = Accepted.EXPLICIT;
                break;
            }
            case 2: {
                this.renegotiate();
            }
        }
    }

    private byte[] getPeerCertificate() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment x509 = openssl_h_Compatibility.SSL_get_peer_certificate(this.state.ssl);
            MemorySegment bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            int length = openssl_h.i2d_X509(x509, bufPointer);
            if (length <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] certificate = buf.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            openssl_h.X509_free(x509);
            openssl_h_Macros.OPENSSL_free(buf);
            byte[] byArray = certificate;
            return byArray;
        }
    }

    private byte[][] getPeerCertChain() {
        MemorySegment sk = openssl_h.SSL_get_peer_cert_chain(this.state.ssl);
        int len = openssl_h_Compatibility.OPENSSL_sk_num(sk);
        if (len <= 0) {
            return null;
        }
        byte[][] certificateChain = new byte[len][];
        try (Arena localArena = Arena.ofConfined();){
            for (int i = 0; i < len; ++i) {
                MemorySegment bufPointer;
                MemorySegment x509 = openssl_h_Compatibility.OPENSSL_sk_value(sk, i);
                int length = openssl_h.i2d_X509(x509, bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL));
                if (length < 0) {
                    certificateChain[i] = new byte[0];
                    continue;
                }
                MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
                byte[] certificate = buf.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                certificateChain[i] = certificate;
                openssl_h_Macros.OPENSSL_free(buf);
            }
            byte[][] byArrayArray = certificateChain;
            return byArrayArray;
        }
    }

    private String getProtocolNegotiated() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment lenAddress = localArena.allocate(ValueLayout.JAVA_INT);
            MemorySegment protocolPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            openssl_h.SSL_get0_alpn_selected(this.state.ssl, protocolPointer, lenAddress);
            if (MemorySegment.NULL.equals(protocolPointer)) {
                String string = null;
                return string;
            }
            int length = lenAddress.get(ValueLayout.JAVA_INT, 0L);
            if (length == 0) {
                String string = null;
                return string;
            }
            MemorySegment protocolAddress = protocolPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] name = protocolAddress.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Protocol negotiated [" + new String(name) + "]"));
            }
            String string = new String(name);
            return string;
        }
    }

    private void beginHandshakeImplicitly() throws SSLException {
        this.handshake();
        this.accepted = Accepted.IMPLICIT;
    }

    private void handshake() throws SSLException {
        this.currentHandshake = this.state.handshakeCount;
        OpenSSLEngine.clearLastError();
        int code = openssl_h.SSL_do_handshake(this.state.ssl);
        if (code <= 0) {
            this.checkLastError();
        } else {
            if (this.alpn) {
                this.selectedProtocol = this.getProtocolNegotiated();
            }
            this.session.lastAccessedTime = System.currentTimeMillis();
            this.handshakeFinished = true;
        }
    }

    private void renegotiate() throws SSLException {
        int code;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Start renegotiate");
        }
        OpenSSLEngine.clearLastError();
        if (openssl_h.SSL_get_version(this.state.ssl).getString(0L).equals("TLSv1.3")) {
            this.state.phaState = PHAState.START;
            code = openssl_h.SSL_verify_client_post_handshake(this.state.ssl);
        } else {
            code = openssl_h.SSL_renegotiate(this.state.ssl);
        }
        if (code <= 0) {
            this.checkLastError();
        }
        this.handshakeFinished = false;
        this.peerCerts = null;
        this.currentHandshake = this.state.handshakeCount;
        int code2 = openssl_h.SSL_do_handshake(this.state.ssl);
        if (code2 <= 0) {
            this.checkLastError();
        }
    }

    private void checkLastError() throws SSLException {
        String sslError = OpenSSLLibrary.getLastError();
        if (sslError != null) {
            if (!this.handshakeFinished) {
                this.sendHandshakeError = true;
            } else {
                throw new SSLException(sslError);
            }
        }
    }

    private static void clearLastError() {
        OpenSSLLibrary.getLastError();
    }

    private SSLEngineResult.Status getEngineStatus() {
        return this.engineClosed ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.accepted == Accepted.NOT || this.destroyed) {
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        if (!this.handshakeFinished) {
            if (this.sendHandshakeError || openssl_h.BIO_ctrl_pending(this.state.networkBIO) != 0L) {
                if (this.sendHandshakeError) {
                    this.sendHandshakeError = false;
                    ++this.currentHandshake;
                }
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.state.handshakeCount != this.currentHandshake && openssl_h.SSL_renegotiate_pending(this.state.ssl) == 0 && this.state.phaState != PHAState.START) {
                if (this.alpn) {
                    this.selectedProtocol = this.getProtocolNegotiated();
                }
                this.session.lastAccessedTime = System.currentTimeMillis();
                this.version = openssl_h.SSL_get_version(this.state.ssl).getString(0L);
                this.handshakeFinished = true;
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.engineClosed) {
            if (openssl_h.BIO_ctrl_pending(this.state.networkBIO) != 0L) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (!this.isInboundDone()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    @Override
    public void setUseClientMode(boolean clientMode) {
        if (clientMode != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public void setNeedClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.REQUIRE : ClientAuthMode.NONE);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuthMode.REQUIRE;
    }

    @Override
    public void setWantClientAuth(boolean b) {
        this.setClientAuth(b ? ClientAuthMode.OPTIONAL : ClientAuthMode.NONE);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.clientAuth == ClientAuthMode.OPTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuthMode mode) {
        if (this.clientMode) {
            return;
        }
        OpenSSLEngine openSSLEngine = this;
        synchronized (openSSLEngine) {
            if (this.clientAuth == mode) {
                return;
            }
            this.state.certificateVerifyMode = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> openssl_h.SSL_VERIFY_NONE();
                case 2 -> openssl_h.SSL_VERIFY_FAIL_IF_NO_PEER_CERT();
                case 1 -> this.certificateVerificationOptionalNoCA ? 3 : openssl_h.SSL_VERIFY_PEER();
            };
            int value = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> openssl_h.SSL_VERIFY_NONE();
                case 2 -> openssl_h.SSL_VERIFY_PEER() | openssl_h.SSL_VERIFY_FAIL_IF_NO_PEER_CERT();
                case 1 -> openssl_h.SSL_VERIFY_PEER();
            };
            openssl_h.SSL_set_verify(this.state.ssl, value, SSL_set_verify$callback.allocate(new VerifyCallback(), this.engineArena));
            this.clientAuth = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processOCSP(EngineState state, MemorySegment x509ctx) {
        int ocspResponse;
        block21: {
            ocspResponse = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            MemorySegment x509 = openssl_h.X509_STORE_CTX_get_current_cert(x509ctx);
            if (!MemorySegment.NULL.equals(x509)) {
                if (openssl_h.X509_check_issued(x509, x509) == openssl_h.X509_V_OK()) {
                    openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_OK());
                } else {
                    try (Arena localArena = Arena.ofConfined();){
                        MemorySegment issuer = MemorySegment.NULL;
                        try {
                            int nid;
                            if (openssl_h_Compatibility.OPENSSL && !openssl_h_Compatibility.OPENSSL3) {
                                issuer = openssl_h_Compatibility.X509_STORE_CTX_get0_current_issuer(x509ctx);
                            } else {
                                MemorySegment x509IssuerPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
                                int res = openssl_h.X509_STORE_CTX_get1_issuer(x509IssuerPointer, x509ctx, x509);
                                if (res > 0) {
                                    issuer = x509IssuerPointer.get(ValueLayout.ADDRESS, 0L);
                                }
                            }
                            if (MemorySegment.NULL.equals(issuer) || (nid = openssl_h.X509_get_ext_by_NID(x509, openssl_h.NID_info_access(), -1)) < 0) break block21;
                            MemorySegment ext = openssl_h.X509_get_ext(x509, nid);
                            MemorySegment os = openssl_h.X509_EXTENSION_get_data(ext);
                            int length = openssl_h.ASN1_STRING_length(os);
                            MemorySegment data = openssl_h.ASN1_STRING_get0_data(os);
                            byte[] asn1String = data.reinterpret(length, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                            Asn1Parser parser = new Asn1Parser(asn1String);
                            ArrayList<String> urls = new ArrayList<String>();
                            try {
                                OpenSSLEngine.parseOCSPURLs(parser, urls);
                            }
                            catch (Exception e) {
                                log.error((Object)sm.getString("engine.ocspParseError"), (Throwable)e);
                            }
                            if (urls.isEmpty()) break block21;
                            for (String urlString : urls) {
                                try {
                                    URL url = new URI(urlString).toURL();
                                    ocspResponse = OpenSSLEngine.processOCSPRequest(state, url, issuer, x509, x509ctx, localArena);
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)sm.getString("engine.ocspResponse", new Object[]{urlString, Integer.toString(ocspResponse)}));
                                    }
                                }
                                catch (MalformedURLException | URISyntaxException e) {
                                    log.warn((Object)sm.getString("engine.invalidOCSPURL", new Object[]{urlString}));
                                }
                                if (ocspResponse == openssl_h.V_OCSP_CERTSTATUS_UNKNOWN()) continue;
                                break;
                            }
                        }
                        finally {
                            openssl_h.X509_free(issuer);
                        }
                    }
                }
            }
        }
        return ocspResponse;
    }

    private static void parseOCSPURLs(Asn1Parser parser, ArrayList<String> urls) {
        while (!parser.eof()) {
            int tag = parser.peekTag();
            if (tag == 48) {
                parser.parseTag(48);
                parser.parseFullLength();
                continue;
            }
            if (tag == 6) {
                parser.parseTag(6);
                int oidLen = parser.parseLength();
                byte[] oid = new byte[oidLen];
                parser.parseBytes(oid);
                if (Arrays.compareUnsigned(oid, 0, OCSP_OID.length, OCSP_OID, 0, OCSP_OID.length) != 0) continue;
                parser.parseTag(134);
                int urlLen = parser.parseLength();
                byte[] url = new byte[urlLen];
                parser.parseBytes(url);
                urls.add(new String(url));
                continue;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int processOCSPRequest(EngineState state, URL url, MemorySegment issuer, MemorySegment x509, MemorySegment x509ctx, Arena localArena) {
        if (openssl_h_Compatibility.BORINGSSL) return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
        if (openssl_h_Compatibility.isLibreSSLPre35()) {
            return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
        }
        MemorySegment ocspRequest = MemorySegment.NULL;
        MemorySegment ocspResponse = MemorySegment.NULL;
        HttpURLConnection connection = null;
        MemorySegment basicResponse = MemorySegment.NULL;
        MemorySegment certId = MemorySegment.NULL;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int read;
            ocspRequest = openssl_h.OCSP_REQUEST_new();
            if (MemorySegment.NULL.equals(ocspRequest)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment id = openssl_h.OCSP_cert_to_id(MemorySegment.NULL, x509, issuer);
            if (MemorySegment.NULL.equals(id)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment ocspOneReq = openssl_h.OCSP_request_add0_id(ocspRequest, id);
            if (MemorySegment.NULL.equals(ocspOneReq)) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            openssl_h.OCSP_request_add1_nonce(ocspRequest, '\u0000', -1);
            MemorySegment bufPointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            int requestLength = openssl_h.i2d_OCSP_REQUEST(ocspRequest, bufPointer);
            if (requestLength <= 0) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment buf = bufPointer.get(ValueLayout.ADDRESS, 0L);
            byte[] ocspRequestData = buf.reinterpret(requestLength, localArena, null).toArray(ValueLayout.JAVA_BYTE);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(state.ocspTimeout);
            connection.setReadTimeout(state.ocspTimeout);
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setFixedLengthStreamingMode(requestLength);
            connection.setRequestProperty("Content-Type", "application/ocsp-request");
            connection.connect();
            connection.getOutputStream().write(ocspRequestData);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            InputStream is = connection.getInputStream();
            byte[] responseBuf = new byte[1024];
            while ((read = is.read(responseBuf)) > 0) {
                baos.write(responseBuf, 0, read);
            }
            byte[] responseData = baos.toByteArray();
            MemorySegment nativeResponseData = localArena.allocateFrom(ValueLayout.JAVA_BYTE, responseData);
            MemorySegment nativeResponseDataPointer = localArena.allocateFrom(ValueLayout.ADDRESS, nativeResponseData);
            ocspResponse = openssl_h.d2i_OCSP_RESPONSE(MemorySegment.NULL, nativeResponseDataPointer, responseData.length);
            if (MemorySegment.NULL.equals(ocspResponse)) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_APPLICATION_VERIFICATION());
                return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            }
            if (openssl_h.OCSP_response_status(ocspResponse) != openssl_h.OCSP_RESPONSE_STATUS_SUCCESSFUL()) return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
            basicResponse = openssl_h.OCSP_response_get1_basic(ocspResponse);
            if (openssl_h.OCSP_check_nonce(ocspRequest, basicResponse) == 0) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_OCSP_RESP_INVALID());
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment certStack = openssl_h.OCSP_resp_get0_certs(basicResponse);
            if (openssl_h.OCSP_basic_verify(basicResponse, certStack, openssl_h.X509_STORE_CTX_get0_store(x509ctx), state.ocspVerifyFlags) <= 0) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_OCSP_SIGNATURE_FAILURE());
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            certId = openssl_h.OCSP_cert_to_id(MemorySegment.NULL, x509, issuer);
            if (MemorySegment.NULL.equals(certId)) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_OCSP_RESP_INVALID());
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            MemorySegment singleResponse = openssl_h.OCSP_resp_get0(basicResponse, openssl_h.OCSP_resp_find(basicResponse, certId, -1));
            MemorySegment thisUpdatePointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            MemorySegment nextUpdatePointer = localArena.allocateFrom(ValueLayout.ADDRESS, MemorySegment.NULL);
            int status = openssl_h.OCSP_single_get0_status(singleResponse, MemorySegment.NULL, MemorySegment.NULL, thisUpdatePointer, nextUpdatePointer);
            if (openssl_h.OCSP_check_validity(thisUpdatePointer.get(ValueLayout.ADDRESS, 0L), nextUpdatePointer.get(ValueLayout.ADDRESS, 0L), 900L, -1L) <= 0) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_OCSP_NOT_YET_VALID());
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            if (openssl_h.OCSP_check_validity(thisUpdatePointer.get(ValueLayout.ADDRESS, 0L), nextUpdatePointer.get(ValueLayout.ADDRESS, 0L), 900L, 900L) <= 0) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_OCSP_HAS_EXPIRED());
                int n = openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
                return n;
            }
            int n = status;
            return n;
        }
        catch (IOException ioe) {
            log.warn((Object)sm.getString("engine.ocspRequestError", new Object[]{url.toString()}), (Throwable)ioe);
            openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_UNABLE_TO_GET_CRL());
            return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("engine.ocspRequestError", new Object[]{url.toString()}), (Throwable)e);
            openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_APPLICATION_VERIFICATION());
            return openssl_h.V_OCSP_CERTSTATUS_UNKNOWN();
        }
        finally {
            openssl_h.OCSP_CERTID_free(certId);
            openssl_h.OCSP_BASICRESP_free(basicResponse);
            openssl_h.OCSP_RESPONSE_free(ocspResponse);
            openssl_h.OCSP_REQUEST_free(ocspRequest);
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public void setEnableSessionCreation(boolean b) {
        if (!b) {
            String msg = sm.getString("engine.noRestrictSessionCreation");
            throw new UnsupportedOperationException(msg);
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return true;
    }

    static {
        LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(128);
        availableCipherSuites.addAll(OpenSSLLibrary.findCiphers("ALL"));
        AVAILABLE_CIPHER_SUITES = Collections.unmodifiableSet(availableCipherSuites);
        IMPLEMENTED_PROTOCOLS_SET = Set.of("SSLv2Hello", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3");
        states = new ConcurrentHashMap();
        OCSP_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1};
    }

    private static class EngineState
    implements Runnable {
        private final Arena stateArena = Arena.ofShared();
        private final MemorySegment ssl;
        private final MemorySegment networkBIO;
        private final int certificateVerificationDepth;
        private final boolean noOcspCheck;
        private final boolean ocspSoftFail;
        private final int ocspTimeout;
        private final int ocspVerifyFlags;
        private PHAState phaState = PHAState.NONE;
        private int certificateVerifyMode = 0;
        private int handshakeCount = 0;

        private EngineState(MemorySegment ssl, MemorySegment networkBIO, int certificateVerificationDepth, boolean noOcspCheck, boolean ocspSoftFail, int ocspTimeout, int ocspVerifyFlags) {
            states.put(ssl.address(), this);
            this.certificateVerificationDepth = certificateVerificationDepth;
            this.noOcspCheck = noOcspCheck;
            this.ocspSoftFail = ocspSoftFail;
            this.ocspTimeout = ocspTimeout;
            this.ocspVerifyFlags = ocspVerifyFlags;
            this.ssl = ssl.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, openssl_h::SSL_free);
            this.networkBIO = networkBIO.reinterpret(ValueLayout.ADDRESS.byteSize(), this.stateArena, openssl_h::BIO_free);
        }

        @Override
        public void run() {
            states.remove(this.ssl.address());
            this.stateArena.close();
        }
    }

    private static enum Accepted {
        NOT,
        IMPLICIT,
        EXPLICIT;

    }

    private static enum ClientAuthMode {
        NONE,
        OPTIONAL,
        REQUIRE;

    }

    private class OpenSSLSession
    implements SSLSession {
        private Map<String, Object> values;
        private long lastAccessedTime = -1L;

        private OpenSSLSession() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getId() {
            byte[] id = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                block13: {
                    if (OpenSSLEngine.this.destroyed) break block13;
                    try (Arena localArena = Arena.ofConfined();){
                        MemorySegment lenPointer = localArena.allocate(ValueLayout.JAVA_INT);
                        MemorySegment session = openssl_h.SSL_get_session(OpenSSLEngine.this.state.ssl);
                        if (MemorySegment.NULL.equals(session)) {
                            byte[] byArray = new byte[]{};
                            return byArray;
                        }
                        MemorySegment sessionId = openssl_h.SSL_SESSION_get_id(session, lenPointer);
                        int len = lenPointer.get(ValueLayout.JAVA_INT, 0L);
                        id = len == 0 ? new byte[]{} : sessionId.reinterpret(len, localArena, null).toArray(ValueLayout.JAVA_BYTE);
                    }
                }
                return id;
            }
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return OpenSSLEngine.this.sessionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getCreationTime() {
            long creationTime = 0L;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                MemorySegment session;
                if (!OpenSSLEngine.this.destroyed && !MemorySegment.NULL.equals(session = openssl_h.SSL_get_session(OpenSSLEngine.this.state.ssl))) {
                    creationTime = openssl_h.SSL_SESSION_get_time(session);
                }
            }
            return creationTime * 1000L;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime > 0L ? this.lastAccessedTime : this.getCreationTime();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void putValue(String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (value == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullValue"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                values = this.values = new HashMap<String, Object>(2);
            }
            Object old = values.put(name, value);
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
            }
            this.notifyUnbound(old, name);
        }

        @Override
        public Object getValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            if (this.values == null) {
                return null;
            }
            return this.values.get(name);
        }

        @Override
        public void removeValue(String name) {
            if (name == null) {
                throw new IllegalArgumentException(sm.getString("engine.nullName"));
            }
            Map<String, Object> values = this.values;
            if (values == null) {
                return;
            }
            Object old = values.remove(name);
            this.notifyUnbound(old, name);
        }

        @Override
        public String[] getValueNames() {
            Map<String, Object> values = this.values;
            if (values == null || values.isEmpty()) {
                return new String[0];
            }
            return values.keySet().toArray(new String[0]);
        }

        private void notifyUnbound(Object value, String name) {
            if (value instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            Certificate[] c = OpenSSLEngine.this.peerCerts;
            if (c == null) {
                Certificate[] certificates;
                byte[] clientCert;
                byte[][] chain;
                OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
                synchronized (openSSLEngine) {
                    if (OpenSSLEngine.this.destroyed || openssl_h.SSL_in_init(OpenSSLEngine.this.state.ssl) != 0) {
                        throw new SSLPeerUnverifiedException(sm.getString("engine.unverifiedPeer"));
                    }
                    chain = OpenSSLEngine.this.getPeerCertChain();
                    clientCert = !OpenSSLEngine.this.clientMode ? OpenSSLEngine.this.getPeerCertificate() : null;
                }
                if (chain == null && clientCert == null) {
                    return null;
                }
                int len = 0;
                if (chain != null) {
                    len += chain.length;
                }
                int i = 0;
                if (clientCert != null) {
                    certificates = new Certificate[++len];
                    certificates[i++] = new OpenSSLX509Certificate(clientCert);
                } else {
                    certificates = new Certificate[len];
                }
                if (chain != null) {
                    int a = 0;
                    while (i < certificates.length) {
                        certificates[i] = new OpenSSLX509Certificate(chain[a++]);
                        ++i;
                    }
                }
                OpenSSLEngine.this.peerCerts = certificates;
                c = certificates;
            }
            return c;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return EMPTY_CERTIFICATES;
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            Certificate[] peer = this.getPeerCertificates();
            if (peer == null || peer.length == 0) {
                return null;
            }
            return this.principal(peer);
        }

        @Override
        public Principal getLocalPrincipal() {
            Certificate[] local = this.getLocalCertificates();
            if (local == null || local.length == 0) {
                return null;
            }
            return this.principal(local);
        }

        private Principal principal(Certificate[] certs) {
            return ((X509Certificate)certs[0]).getSubjectX500Principal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getCipherSuite() {
            if (OpenSSLEngine.this.cipher == null) {
                String ciphers;
                OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
                synchronized (openSSLEngine) {
                    if (!OpenSSLEngine.this.handshakeFinished) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    if (OpenSSLEngine.this.destroyed) {
                        return OpenSSLEngine.INVALID_CIPHER;
                    }
                    ciphers = openssl_h.SSL_CIPHER_get_name(openssl_h.SSL_get_current_cipher(OpenSSLEngine.this.state.ssl)).getString(0L);
                }
                String c = OpenSSLCipherConfigurationParser.openSSLToJsse((String)ciphers);
                if (c != null) {
                    OpenSSLEngine.this.cipher = c;
                }
            }
            return OpenSSLEngine.this.cipher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProtocol() {
            String applicationProtocol = OpenSSLEngine.this.applicationProtocol;
            if (applicationProtocol == null) {
                applicationProtocol = OpenSSLEngine.this.fallbackApplicationProtocol;
                if (applicationProtocol != null) {
                    OpenSSLEngine.this.applicationProtocol = applicationProtocol.replace(':', '_');
                } else {
                    applicationProtocol = "";
                    OpenSSLEngine.this.applicationProtocol = "";
                }
            }
            String version = null;
            OpenSSLEngine openSSLEngine = OpenSSLEngine.this;
            synchronized (openSSLEngine) {
                if (!OpenSSLEngine.this.destroyed) {
                    version = openssl_h.SSL_get_version(OpenSSLEngine.this.state.ssl).getString(0L);
                }
            }
            if (applicationProtocol.isEmpty()) {
                return version;
            }
            return version + ":" + applicationProtocol;
        }

        @Override
        public String getPeerHost() {
            return null;
        }

        @Override
        public int getPeerPort() {
            return 0;
        }

        @Override
        public int getPacketBufferSize() {
            return 18713;
        }

        @Override
        public int getApplicationBufferSize() {
            return 16384;
        }
    }

    private static class InfoCallback
    implements SSL_set_info_callback$cb.Function {
        private InfoCallback() {
        }

        @Override
        public void apply(MemorySegment ssl, int where, int ret) {
            EngineState state = OpenSSLEngine.getState(ssl);
            if (state == null) {
                log.warn((Object)sm.getString("engine.noSSL", new Object[]{ssl.address()}));
                return;
            }
            if (0 != (where & openssl_h.SSL_CB_HANDSHAKE_DONE())) {
                ++state.handshakeCount;
            }
        }
    }

    private static enum PHAState {
        NONE,
        START,
        COMPLETE;

    }

    static class VerifyCallback
    implements SSL_set_verify$callback.Function,
    SSL_CTX_set_verify$callback.Function {
        VerifyCallback() {
        }

        @Override
        public int apply(int preverify_ok, MemorySegment x509ctx) {
            boolean verifyErrorIsOptional;
            MemorySegment ssl = openssl_h.X509_STORE_CTX_get_ex_data(x509ctx, openssl_h.SSL_get_ex_data_X509_STORE_CTX_idx());
            EngineState state = OpenSSLEngine.getState(ssl);
            if (state == null) {
                log.warn((Object)sm.getString("engine.noSSL", new Object[]{ssl.address()}));
                return 0;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Verification in engine with mode [" + state.certificateVerifyMode + "] for " + String.valueOf(state.ssl)));
            }
            int ok = preverify_ok;
            int errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx);
            int errdepth = openssl_h.X509_STORE_CTX_get_error_depth(x509ctx);
            state.phaState = PHAState.COMPLETE;
            if (state.certificateVerifyMode == -1 || state.certificateVerifyMode == openssl_h.SSL_VERIFY_NONE()) {
                return 1;
            }
            boolean bl = verifyErrorIsOptional = errnum == openssl_h.X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT() || errnum == openssl_h.X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN() || errnum == openssl_h.X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY() || errnum == openssl_h.X509_V_ERR_CERT_UNTRUSTED() || errnum == openssl_h.X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE();
            if ((verifyErrorIsOptional || errnum == openssl_h.X509_V_OK()) && state.certificateVerifyMode == 3) {
                ok = 1;
                openssl_h_Compatibility.SSL_set_verify_result(state.ssl, openssl_h.X509_V_OK());
            }
            if (ok == 0 && errnum == openssl_h.X509_V_ERR_UNABLE_TO_GET_CRL()) {
                ok = 1;
            }
            if (ok == 0 && errnum == openssl_h.X509_V_ERR_CRL_HAS_EXPIRED()) {
                openssl_h.X509_STORE_CTX_set_error(x509ctx, -1);
            }
            if (!state.noOcspCheck && ok > 0) {
                if (verifyErrorIsOptional) {
                    openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_APPLICATION_VERIFICATION());
                    errnum = openssl_h.X509_V_ERR_APPLICATION_VERIFICATION();
                    ok = 0;
                } else {
                    int ocspResponse = OpenSSLEngine.processOCSP(state, x509ctx);
                    if (ocspResponse == openssl_h.V_OCSP_CERTSTATUS_REVOKED()) {
                        ok = 0;
                        errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx);
                        openssl_h.X509_STORE_CTX_set_error(x509ctx, openssl_h.X509_V_ERR_CERT_REVOKED());
                    } else if (!(ocspResponse != openssl_h.V_OCSP_CERTSTATUS_UNKNOWN() || (errnum = openssl_h.X509_STORE_CTX_get_error(x509ctx)) == 0 || state.ocspSoftFail && errnum == openssl_h.X509_V_ERR_UNABLE_TO_GET_CRL())) {
                        ok = 0;
                    }
                }
            }
            if (errdepth > state.certificateVerificationDepth) {
                ok = 0;
            }
            return ok;
        }
    }
}

