/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.openssl;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Compatibility;

public class openssl_h_Macros {
    public static long SSL_CTX_set_max_proto_version(MemorySegment sslCtx, long version) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set_max_proto_version";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_LONG);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set_max_proto_version"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set_max_proto_version", sslCtx, version);
                }
                return mh$.invokeExact(sslCtx, version);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MAX_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_min_proto_version(MemorySegment sslCtx, long version) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set_min_proto_version";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_LONG);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set_min_proto_version"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set_min_proto_version", sslCtx, version);
                }
                return mh$.invokeExact(sslCtx, version);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_MIN_PROTO_VERSION(), version, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_get_cache_size(MemorySegment sslCtx) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_sess_get_cache_size";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_sess_get_cache_size"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_sess_get_cache_size", sslCtx);
                }
                return mh$.invokeExact(sslCtx);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_SIZE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_sess_set_cache_size(MemorySegment sslCtx, long cacheSize) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_sess_set_cache_size";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_LONG);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_sess_set_cache_size"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_sess_set_cache_size", sslCtx, cacheSize);
                }
                return mh$.invokeExact(sslCtx, cacheSize);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_SIZE(), cacheSize, MemorySegment.NULL);
    }

    public static long SSL_CTX_get_session_cache_mode(MemorySegment sslCtx) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_get_session_cache_mode";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_get_session_cache_mode"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_get_session_cache_mode", sslCtx);
                }
                return mh$.invokeExact(sslCtx);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_GET_SESS_CACHE_MODE(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set_session_cache_mode(MemorySegment sslCtx, long cacheMode) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set_session_cache_mode";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_LONG);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set_session_cache_mode"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set_session_cache_mode", sslCtx, cacheMode);
                }
                return mh$.invokeExact(sslCtx, cacheMode);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_SESS_CACHE_MODE(), cacheMode, MemorySegment.NULL);
    }

    public static long SSL_CTX_add0_chain_cert(MemorySegment sslCtx, MemorySegment x509) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_add0_chain_cert";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_add0_chain_cert"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_add0_chain_cert", sslCtx, x509);
                }
                return mh$.invokeExact(sslCtx, x509);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_CHAIN_CERT(), 0L, x509);
    }

    public static long SSL_CTX_set_tlsext_ticket_keys(MemorySegment sslCtx, MemorySegment keys, long keyLength) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set_tlsext_ticket_keys";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_LONG);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set_tlsext_ticket_keys"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set_tlsext_ticket_keys", sslCtx, keys, keyLength);
                }
                return mh$.invokeExact(sslCtx, keys, keyLength);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TLSEXT_TICKET_KEYS(), keyLength, keys);
    }

    public static long BIO_read_filename(MemorySegment bio, MemorySegment name) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_C_SET_FILENAME(), openssl_h.BIO_CLOSE() | openssl_h.BIO_FP_READ(), name);
    }

    public static long SSL_CTX_set_tmp_dh(MemorySegment sslCtx, MemorySegment dh2) {
        if (openssl_h_Compatibility.BORINGSSL) {
            return 1L;
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_DH(), 0L, dh2);
    }

    public static long SSL_CTX_set_tmp_ecdh(MemorySegment sslCtx, MemorySegment ecdh) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set_tmp_ecdh";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set_tmp_ecdh"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set_tmp_ecdh", sslCtx, ecdh);
                }
                return mh$.invokeExact(sslCtx, ecdh);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_TMP_ECDH(), 0L, ecdh);
    }

    public static long SSL_CTX_set_dh_auto(MemorySegment sslCtx, int onoff) {
        if (openssl_h_Compatibility.BORINGSSL) {
            return 1L;
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_DH_AUTO(), 1L, MemorySegment.NULL);
    }

    public static void OPENSSL_free(MemorySegment segment) {
        openssl_h.CRYPTO_free(segment, MemorySegment.NULL, 0);
    }

    public static long BIO_reset(MemorySegment bio) {
        return openssl_h.BIO_ctrl(bio, openssl_h.BIO_CTRL_RESET(), 0L, MemorySegment.NULL);
    }

    public static long SSL_CTX_set1_groups(MemorySegment sslCtx, MemorySegment groupsList, int listLength) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set1_groups";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_POINTER, openssl_h.C_INT);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set1_groups"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set1_groups", sslCtx, groupsList, listLength);
                }
                return mh$.invokeExact(sslCtx, groupsList, listLength);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_GROUPS(), listLength, groupsList);
    }

    public static long SSL_CTX_set1_groups_list(MemorySegment sslCtx, MemorySegment groupsList) {
        if (openssl_h_Compatibility.BORINGSSL) {
            class Holder {
                static final String NAME = "SSL_CTX_set1_groups_list";
                static final FunctionDescriptor DESC = FunctionDescriptor.of(openssl_h.C_LONG, openssl_h.C_POINTER, openssl_h.C_POINTER);
                static final MethodHandle MH = Linker.nativeLinker().downcallHandle(openssl_h.findOrThrow("SSL_CTX_set1_groups_list"), DESC, new Linker.Option[0]);

                Holder() {
                }
            }
            MethodHandle mh$ = Holder.MH;
            try {
                if (openssl_h.TRACE_DOWNCALLS) {
                    openssl_h.traceDowncall("SSL_CTX_set1_groups_list", sslCtx, groupsList);
                }
                return mh$.invokeExact(sslCtx, groupsList);
            }
            catch (Throwable ex$) {
                throw new AssertionError("should not reach here", ex$);
            }
        }
        return openssl_h.SSL_CTX_ctrl(sslCtx, openssl_h.SSL_CTRL_SET_GROUPS_LIST(), 0L, groupsList);
    }

    public static long X509_LOOKUP_add_dir(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_ADD_DIR(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }

    public static long X509_LOOKUP_load_file(MemorySegment x509Lookup, MemorySegment name, long type) {
        return openssl_h.X509_LOOKUP_ctrl(x509Lookup, openssl_h.X509_L_FILE_LOAD(), name, openssl_h.X509_FILETYPE_PEM(), MemorySegment.NULL);
    }

    public static MemorySegment d2i_ECPKParameters$SYMBOL() {
        return openssl_h.findOrThrow("d2i_ECPKParameters");
    }
}

