/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class H02FrameDecoder
extends BaseFrameDecoder {
    private static final int MESSAGE_SHORT = 32;
    private static final int MESSAGE_LONG = 45;
    private int messageLength;

    public H02FrameDecoder(int messageLength) {
        this.messageLength = messageLength;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        char marker = (char)buf.getByte(buf.readerIndex());
        while (marker != '*' && marker != '$' && marker != 'X' && buf.readableBytes() > 0) {
            buf.skipBytes(1);
            if (buf.readableBytes() <= 0) continue;
            marker = (char)buf.getByte(buf.readerIndex());
        }
        switch (marker) {
            case '*': {
                int index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)35);
                if (index == -1) break;
                ByteBuf result = buf.readRetainedSlice(index + 1 - buf.readerIndex());
                while (buf.isReadable() && (buf.getByte(buf.readerIndex()) == 13 || buf.getByte(buf.readerIndex()) == 10)) {
                    buf.readByte();
                }
                return result;
            }
            case '$': {
                if (this.messageLength == 0) {
                    this.messageLength = buf.readableBytes() == 45 ? 45 : 32;
                }
                if (buf.readableBytes() < this.messageLength) break;
                return buf.readRetainedSlice(this.messageLength);
            }
            case 'X': {
                if (buf.readableBytes() < 32) break;
                return buf.readRetainedSlice(32);
            }
            default: {
                return null;
            }
        }
        return null;
    }
}

