/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderInternal;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilderOptions;
import org.gradle.plugins.ide.internal.tooling.IsolatedGradleProjectParameter;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.IsolatedGradleProjectInternal;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleProjectTask;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.provider.model.internal.IntermediateToolingModelProvider;

@NonNullApi
public class IsolatedProjectsSafeGradleProjectBuilder
implements GradleProjectBuilderInternal {
    private static final String MODEL_NAME = "org.gradle.tooling.model.GradleProject";
    private final IntermediateToolingModelProvider intermediateToolingModelProvider;

    public IsolatedProjectsSafeGradleProjectBuilder(IntermediateToolingModelProvider intermediateToolingModelProvider) {
        this.intermediateToolingModelProvider = intermediateToolingModelProvider;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(MODEL_NAME);
    }

    public Object buildAll(String modelName, Project project) {
        return this.buildForRoot(project);
    }

    @Override
    public DefaultGradleProject buildForRoot(Project project) {
        IsolatedProjectsSafeGradleProjectBuilder.requireRootProject(project);
        ProjectInternal rootProject = (ProjectInternal)project;
        IsolatedGradleProjectParameter parameter = IsolatedProjectsSafeGradleProjectBuilder.createParameter(GradleProjectBuilderOptions.shouldRealizeTasks());
        IsolatedGradleProjectInternal rootIsolatedModel = this.getRootIsolatedModel(rootProject, parameter);
        return this.build((Project)rootProject, rootProject, rootIsolatedModel, parameter);
    }

    private static void requireRootProject(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new IllegalArgumentException(String.format("%s can only be requested on the root project, got %s", MODEL_NAME, project));
        }
    }

    private IsolatedGradleProjectInternal getRootIsolatedModel(ProjectInternal rootProject, IsolatedGradleProjectParameter parameter) {
        return this.getIsolatedModels((Project)rootProject, Collections.singletonList(rootProject), parameter).get(0);
    }

    private DefaultGradleProject build(Project root, ProjectInternal project, IsolatedGradleProjectInternal isolatedModel, IsolatedGradleProjectParameter parameter) {
        DefaultGradleProject model = IsolatedProjectsSafeGradleProjectBuilder.buildWithoutChildren(project, isolatedModel);
        Collection children = ProjectHierarchyUtils.getChildProjectsForInternalUse((Project)project);
        List<IsolatedGradleProjectInternal> isolatedChildrenModels = this.getIsolatedModels(root, children, parameter);
        model.setChildren(this.buildChildren(root, model, parameter, children, isolatedChildrenModels));
        return model;
    }

    private List<DefaultGradleProject> buildChildren(Project rootProject, DefaultGradleProject parent, IsolatedGradleProjectParameter parameter, Collection<Project> children, List<IsolatedGradleProjectInternal> isolatedChildrenModels) {
        return Streams.zip(children.stream(), isolatedChildrenModels.stream(), (c, ic) -> this.build(rootProject, (ProjectInternal)c, (IsolatedGradleProjectInternal)ic, parameter)).map(it -> it.setParent(parent)).collect(Collectors.toList());
    }

    private List<IsolatedGradleProjectInternal> getIsolatedModels(Project root, Collection<Project> projects, IsolatedGradleProjectParameter parameter) {
        return this.intermediateToolingModelProvider.getModels(root, new ArrayList<Project>(projects), IsolatedGradleProjectInternal.class, (Object)parameter);
    }

    private static DefaultGradleProject buildWithoutChildren(ProjectInternal project, IsolatedGradleProjectInternal isolatedModel) {
        DefaultGradleProject model = new DefaultGradleProject();
        model.setProjectIdentifier(isolatedModel.getProjectIdentifier()).setName(isolatedModel.getName()).setDescription(isolatedModel.getDescription()).setBuildDirectory(isolatedModel.getBuildDirectory()).setProjectDirectory(isolatedModel.getProjectDirectory()).setBuildTreePath(project.getIdentityPath().getPath());
        model.getBuildScript().setSourceFile(isolatedModel.getBuildScript().getSourceFile());
        Collection<LaunchableGradleTask> isolatedTasks = isolatedModel.getTasks();
        if (!isolatedTasks.isEmpty()) {
            model.setTasks(isolatedTasks.stream().map(it -> IsolatedProjectsSafeGradleProjectBuilder.buildProjectTask(model, it)).collect(Collectors.toList()));
        }
        return model;
    }

    private static LaunchableGradleProjectTask buildProjectTask(DefaultGradleProject owner, LaunchableGradleTask model) {
        LaunchableGradleProjectTask target = new LaunchableGradleProjectTask();
        target.setPath(model.getPath()).setName(model.getName()).setGroup(model.getGroup()).setDisplayName(model.getDisplayName()).setDescription(model.getDescription()).setPublic(model.isPublic()).setProjectIdentifier(model.getProjectIdentifier()).setBuildTreePath(model.getBuildTreePath());
        target.setProject(owner);
        return target;
    }

    private static IsolatedGradleProjectParameter createParameter(boolean realizeTasks) {
        return () -> realizeTasks;
    }
}

