/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.impl;

import java.util.function.Supplier;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInResult;
import org.gradle.internal.enterprise.GradleEnterprisePluginCheckInService;
import org.gradle.internal.enterprise.GradleEnterprisePluginMetadata;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceFactory;
import org.gradle.internal.enterprise.GradleEnterprisePluginServiceRef;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapter;
import org.gradle.internal.enterprise.impl.DefaultGradleEnterprisePluginAdapterFactory;
import org.gradle.util.internal.VersionNumber;

public class DefaultGradleEnterprisePluginCheckInService
implements GradleEnterprisePluginCheckInService {
    private final GradleEnterprisePluginManager manager;
    private final DefaultGradleEnterprisePluginAdapterFactory pluginAdapterFactory;
    private final boolean isConfigurationCacheEnabled;
    private final boolean isIsolatedProjectsEnabled;
    public static final String UNSUPPORTED_TOGGLE = "org.gradle.internal.unsupported-enterprise-plugin";
    public static final String UNSUPPORTED_TOGGLE_MESSAGE = "Enterprise plugin unsupported due to secret toggle";
    public static final VersionNumber MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING = VersionNumber.version((int)3, (int)12);
    public static final String UNSUPPORTED_PLUGIN_DUE_TO_CONFIGURATION_CACHING_MESSAGE = String.format("Gradle Enterprise plugin has been disabled as it is incompatible with this version of Gradle and the configuration caching feature - please upgrade to version %s.%s or later of the Gradle Enterprise plugin to restore functionality.", MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.getMajor(), MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.getMinor());
    public static final VersionNumber MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_ISOLATED_PROJECTS = VersionNumber.version((int)3, (int)15);
    public static final String UNSUPPORTED_PLUGIN_DUE_TO_ISOLATED_PROJECTS_MESSAGE = "Gradle Enterprise plugin has been disabled as it is incompatible with the isolated projects feature";
    public static final VersionNumber MINIMUM_SUPPORTED_PLUGIN_VERSION_SINCE_GRADLE_9 = VersionNumber.parse((String)"3.13.1");
    private static final String DISABLE_TEST_ACCELERATION_PROPERTY = "gradle.internal.testacceleration.disableImplicitApplication";

    public DefaultGradleEnterprisePluginCheckInService(BuildModelParameters buildModelParameters, GradleEnterprisePluginManager manager, DefaultGradleEnterprisePluginAdapterFactory pluginAdapterFactory) {
        this.manager = manager;
        this.pluginAdapterFactory = pluginAdapterFactory;
        this.isConfigurationCacheEnabled = buildModelParameters.isConfigurationCache();
        this.isIsolatedProjectsEnabled = buildModelParameters.isIsolatedProjects();
    }

    @Override
    public GradleEnterprisePluginCheckInResult checkIn(GradleEnterprisePluginMetadata pluginMetadata, GradleEnterprisePluginServiceFactory serviceFactory) {
        if (Boolean.getBoolean(UNSUPPORTED_TOGGLE)) {
            return this.checkInUnsupportedResult(UNSUPPORTED_TOGGLE_MESSAGE);
        }
        String pluginVersion = pluginMetadata.getVersion();
        VersionNumber pluginBaseVersion = VersionNumber.parse((String)pluginVersion).getBaseVersion();
        if (this.isUnsupportedWithIsolatedProjects(pluginBaseVersion)) {
            System.setProperty(DISABLE_TEST_ACCELERATION_PROPERTY, "true");
            return this.checkInUnsupportedResult(UNSUPPORTED_PLUGIN_DUE_TO_ISOLATED_PROJECTS_MESSAGE);
        }
        if (this.isUnsupportedWithConfigurationCaching(pluginBaseVersion)) {
            return this.checkInUnsupportedResult(UNSUPPORTED_PLUGIN_DUE_TO_CONFIGURATION_CACHING_MESSAGE);
        }
        if (DefaultGradleEnterprisePluginCheckInService.isDeprecatedPluginVersion(pluginBaseVersion)) {
            DefaultGradleEnterprisePluginCheckInService.nagAboutDeprecatedPluginVersion(pluginVersion);
        }
        DefaultGradleEnterprisePluginAdapter adapter = this.pluginAdapterFactory.create(serviceFactory);
        GradleEnterprisePluginServiceRef ref = adapter.getPluginServiceRef();
        this.manager.registerAdapter((GradleEnterprisePluginAdapter)adapter);
        return DefaultGradleEnterprisePluginCheckInService.checkInResult(null, () -> ref);
    }

    private GradleEnterprisePluginCheckInResult checkInUnsupportedResult(String unsupportedMessage) {
        this.manager.unsupported();
        return DefaultGradleEnterprisePluginCheckInService.checkInResult(unsupportedMessage, () -> {
            throw new IllegalStateException();
        });
    }

    private static GradleEnterprisePluginCheckInResult checkInResult(final String unsupportedMessage, final Supplier<GradleEnterprisePluginServiceRef> pluginServiceRefSupplier) {
        return new GradleEnterprisePluginCheckInResult(){

            @Override
            public String getUnsupportedMessage() {
                return unsupportedMessage;
            }

            @Override
            public GradleEnterprisePluginServiceRef getPluginServiceRef() {
                return (GradleEnterprisePluginServiceRef)pluginServiceRefSupplier.get();
            }
        };
    }

    private boolean isUnsupportedWithConfigurationCaching(VersionNumber pluginBaseVersion) {
        return this.isConfigurationCacheEnabled && MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_CONFIGURATION_CACHING.compareTo(pluginBaseVersion) > 0;
    }

    private boolean isUnsupportedWithIsolatedProjects(VersionNumber pluginBaseVersion) {
        return this.isIsolatedProjectsEnabled && MINIMUM_SUPPORTED_PLUGIN_VERSION_FOR_ISOLATED_PROJECTS.compareTo(pluginBaseVersion) > 0;
    }

    private static boolean isDeprecatedPluginVersion(VersionNumber pluginBaseVersion) {
        return MINIMUM_SUPPORTED_PLUGIN_VERSION_SINCE_GRADLE_9.compareTo(pluginBaseVersion) > 0;
    }

    private static void nagAboutDeprecatedPluginVersion(String pluginVersion) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateIndirectUsage((String)("Gradle Enterprise plugin " + pluginVersion)).startingWithGradle9(String.format("only Gradle Enterprise plugin %s.%s.%s or newer is supported", MINIMUM_SUPPORTED_PLUGIN_VERSION_SINCE_GRADLE_9.getMajor(), MINIMUM_SUPPORTED_PLUGIN_VERSION_SINCE_GRADLE_9.getMinor(), MINIMUM_SUPPORTED_PLUGIN_VERSION_SINCE_GRADLE_9.getMicro())).withUpgradeGuideSection(8, "unsupported_ge_plugin_3.13")).nagUser();
    }
}

