/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.Licensing;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.builders.StartDirBuilder;
import org.eclipse.jetty.start.builders.StartIniBuilder;
import org.eclipse.jetty.start.fileinits.MavenLocalRepoFileInitializer;
import org.eclipse.jetty.start.fileinits.TestFileInitializer;
import org.eclipse.jetty.start.fileinits.UriFileInitializer;
import org.eclipse.jetty.start.graph.CriteriaSetPredicate;
import org.eclipse.jetty.start.graph.Selection;
import org.eclipse.jetty.start.graph.UniqueCriteriaPredicate;

public class BaseBuilder {
    private static final String EXITING_LICENSE_NOT_ACKNOWLEDGED = "Exiting: license not acknowledged!";
    private final BaseHome baseHome;
    private final List<FileInitializer> fileInitializers;
    private final StartArgs startArgs;

    public BaseBuilder(BaseHome baseHome, StartArgs args) {
        this.baseHome = baseHome;
        this.startArgs = args;
        this.fileInitializers = new ArrayList<FileInitializer>();
        if (args.isTestingModeEnabled()) {
            this.fileInitializers.add(new TestFileInitializer());
        } else if (args.isDownload()) {
            Path localRepoDir = args.getMavenLocalRepoDir();
            if (localRepoDir != null) {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome, localRepoDir));
            } else {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome));
            }
            this.fileInitializers.add(new UriFileInitializer(baseHome));
        }
    }

    private void ackLicenses() throws IOException {
        if (this.startArgs.isLicenseCheckRequired()) {
            if (this.startArgs.isApproveAllLicenses()) {
                StartLog.info("All Licenses Approved via Command Line Option", new Object[0]);
            } else {
                Licensing licensing = new Licensing();
                for (Module module : this.startArgs.getAllModules().getSelected()) {
                    if (module.hasFiles(this.baseHome, this.startArgs.getProperties())) continue;
                    licensing.addModule(module);
                }
                if (licensing.hasLicenses()) {
                    StartLog.debug("Requesting License Acknowledgement", new Object[0]);
                    if (!licensing.acknowledgeLicenses()) {
                        StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
                        System.exit(1);
                    }
                }
            }
        }
    }

    public boolean build() throws IOException {
        Config builder;
        Modules modules = this.startArgs.getAllModules();
        boolean dirty = false;
        String dirCriteria = "<add-to-startd>";
        String iniCriteria = "<add-to-start-ini>";
        Selection startDirSelection = new Selection(dirCriteria);
        Selection startIniSelection = new Selection(iniCriteria);
        ArrayList<String> startDNames = new ArrayList<String>();
        startDNames.addAll(this.startArgs.getAddToStartdIni());
        ArrayList<String> startIniNames = new ArrayList<String>();
        startIniNames.addAll(this.startArgs.getAddToStartIni());
        int count = 0;
        count += modules.selectNodes(startDNames, startDirSelection);
        count += modules.selectNodes(startIniNames, startIniSelection);
        CriteriaSetPredicate ambiguousPredicate = new CriteriaSetPredicate(dirCriteria, iniCriteria);
        List ambiguous = modules.getMatching(ambiguousPredicate);
        if (ambiguous.size() > 0) {
            StringBuilder warn = new StringBuilder();
            warn.append("Ambiguous module locations detected, defaulting to --add-to-start for the following module selections:");
            warn.append(" [");
            for (int i = 0; i < ambiguous.size(); ++i) {
                if (i > 0) {
                    warn.append(", ");
                }
                warn.append(((Module)ambiguous.get(i)).getName());
            }
            warn.append(']');
            StartLog.warn(warn.toString(), new Object[0]);
        }
        StartLog.debug("Adding %s new module(s)", count);
        this.ackLicenses();
        UniqueCriteriaPredicate startDMatcher = new UniqueCriteriaPredicate(dirCriteria);
        UniqueCriteriaPredicate startIniMatcher = new UniqueCriteriaPredicate(iniCriteria);
        List startDModules = modules.getMatching(startDMatcher);
        List startIniModules = modules.getMatching(startIniMatcher);
        ArrayList<FileArg> files = new ArrayList<FileArg>();
        if (!startDModules.isEmpty()) {
            builder = new StartDirBuilder(this);
            for (Module mod : startDModules) {
                if (ambiguous.contains(mod)) continue;
                if (mod.isSkipFilesValidation()) {
                    StartLog.debug("Skipping [files] validation on %s", mod.getName());
                    continue;
                }
                dirty |= ((StartDirBuilder)builder).addModule(mod);
                for (String file : mod.getFiles()) {
                    files.add(new FileArg(mod, this.startArgs.getProperties().expand(file)));
                }
            }
        }
        if (!startIniModules.isEmpty()) {
            builder = new StartIniBuilder(this);
            for (Module mod : startIniModules) {
                if (mod.isSkipFilesValidation()) {
                    StartLog.debug("Skipping [files] validation on %s", mod.getName());
                    continue;
                }
                dirty |= ((StartIniBuilder)builder).addModule(mod);
                for (String file : mod.getFiles()) {
                    files.add(new FileArg(mod, this.startArgs.getProperties().expand(file)));
                }
            }
        }
        files.addAll(this.startArgs.getFiles());
        return dirty |= this.processFileResources(files);
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    public StartArgs getStartArgs() {
        return this.startArgs;
    }

    private boolean processFileResource(FileArg arg, Path file) throws IOException {
        if (this.startArgs.isDownload() && arg.uri != null) {
            if (!file.startsWith(this.baseHome.getBasePath())) {
                throw new IOException("For security reasons, Jetty start is unable to process maven file resource not in ${jetty.base} - " + file);
            }
            FS.ensureDirectoryExists(file.getParent());
            URI uri = URI.create(arg.uri);
            for (FileInitializer finit : this.fileInitializers) {
                if (!finit.init(uri, file, arg.location)) continue;
                return true;
            }
            return false;
        }
        boolean isDir = arg.location.endsWith("/");
        if (FS.exists(file)) {
            if (isDir) {
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    throw new IOException("Invalid: path should be a directory (but isn't): " + file);
                }
                if (!FS.canReadDirectory(file)) {
                    throw new IOException("Unable to read directory: " + file);
                }
            } else if (!FS.canReadFile(file)) {
                throw new IOException("Unable to read file: " + file);
            }
            return false;
        }
        if (isDir) {
            StartLog.log("MKDIR", this.baseHome.toShortForm(file));
            return FS.ensureDirectoryExists(file);
        }
        String shortRef = this.baseHome.toShortForm(file);
        if (this.startArgs.isTestingModeEnabled()) {
            StartLog.log("TESTING MODE", "Skipping required file check on: %s", shortRef);
            return true;
        }
        StartLog.warn("Missing Required File: %s", this.baseHome.toShortForm(file));
        this.startArgs.setRun(false);
        if (arg.uri != null) {
            StartLog.warn("  Can be downloaded From: %s", arg.uri);
            StartLog.warn("  Run start.jar --create-files to download", new Object[0]);
        }
        return true;
    }

    private boolean processFileResources(List<FileArg> files) throws IOException {
        if (files == null || files.isEmpty()) {
            return false;
        }
        boolean dirty = false;
        ArrayList<String> failures = new ArrayList<String>();
        for (FileArg arg : files) {
            Path file = this.baseHome.getBasePath(arg.location);
            try {
                dirty |= this.processFileResource(arg, file);
            }
            catch (Throwable t) {
                StartLog.warn(t);
                failures.add(String.format("[%s] %s - %s", t.getClass().getSimpleName(), t.getMessage(), file.toAbsolutePath().toString()));
            }
        }
        if (!failures.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("Failed to process all file resources.");
            for (String failure : failures) {
                err.append(System.lineSeparator()).append(" - ").append(failure);
            }
            StartLog.warn(err.toString(), new Object[0]);
            throw new RuntimeException(err.toString());
        }
        return dirty;
    }

    public static interface Config {
        public boolean addModule(Module var1) throws IOException;
    }
}

