/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.LdifUtility;
import com.ca.directory.jxplorer.DataQuery;
import com.ca.directory.jxplorer.DataSource;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.broker.Broker;
import com.ca.directory.jxplorer.broker.SchemaBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitorInputStream;

public class LdifImport {
    DataSource dataSource;
    File readFile;
    SmartTree tree;
    Frame owner;
    SchemaBroker schema;
    boolean offline = true;
    LdifUtility ldifutil = new LdifUtility();
    static final boolean debug = true;
    static ProgressMonitorInputStream pmonitor;
    private static Logger log;

    public LdifImport(DataSource dataSource, SmartTree mrTree, Frame owner, SchemaBroker schema) {
        this.owner = owner;
        this.schema = schema;
        this.tree = mrTree;
        DN base = this.tree.getCurrentDN();
        boolean bl = this.offline = this.tree.getRootDN() == null || this.tree.getRootDN().toString().equals(SmartTree.NODATA);
        if (base == null || this.tree.getRootDN() == null || this.offline) {
            base = new DN();
        }
        this.dataSource = dataSource;
        this.openFile();
    }

    public void openFile() {
        JFileChooser chooser = new JFileChooser(JXplorer.getProperty("ldif.homeDir"));
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"ldif", "ldi"}, "Ldif Files (*.ldif, *.ldi)"));
        int option = chooser.showOpenDialog(this.owner);
        if (option == 0) {
            this.readFile = chooser.getSelectedFile();
            if (this.readFile == null) {
                CBUtility.error(CBIntText.get("Please select a file"));
            } else {
                JXplorer.setProperty("ldif.homeDir", chooser.getSelectedFile().getParent());
                this.ldifutil.setFileDir(chooser.getSelectedFile().getParent());
                this.doFileRead(this.readFile);
            }
            if (this.owner instanceof JXplorer && this.offline) {
                ((JXplorer)this.owner).getMainMenu().setConnected(false);
            }
        }
    }

    protected void doFileRead(File readFile) {
        if (readFile == null) {
            CBUtility.error(CBIntText.get("unable to read null ldif file"), null);
        }
        final File myFile = readFile;
        this.dataSource.extendedRequest(new DataQuery(256){

            public void doExtendedRequest(Broker b) {
                try {
                    FileInputStream rawBytes = new FileInputStream(myFile);
                    pmonitor = new ProgressMonitorInputStream(LdifImport.this.owner, CBIntText.get("Reading ldif file"), rawBytes);
                }
                catch (FileNotFoundException e) {
                    CBUtility.error(CBIntText.get("Unable to read the ldif file ''{0}''.", new String[]{myFile.toString()}), e);
                    return;
                }
                LdifImport.this.readLdifTree("", pmonitor, "", "", b, this);
                if (b.getException() != null) {
                    CBUtility.error(CBIntText.get("There were one or more errors reading the ldif file\n(See the log for more details)"), b.getException());
                    b.clearException();
                }
                LdifImport.this.closeDown();
            }
        });
    }

    public void readLdifTree(String treeApex, InputStream textStream, String origPrefix, String newPrefix, Broker b, DataQuery query) {
        DN newDN = null;
        DXEntry apex = null;
        if (origPrefix == null) {
            origPrefix = "";
        }
        int numEntriesRead = 0;
        if (newPrefix == null) {
            origPrefix = null;
        }
        if (origPrefix != null && origPrefix.equals(newPrefix)) {
            origPrefix = null;
            newPrefix = null;
        }
        treeApex = treeApex.toLowerCase();
        BufferedReader readText = null;
        try {
            readText = new BufferedReader(new InputStreamReader(textStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            CBUtility.error(CBIntText.get("Unexpected problem - Unable to read the ldif file-not utf8 reader available  "), e);
            return;
        }
        DXEntry newEntry = null;
        String line = "";
        try {
            readText.mark(256);
            line = readText.readLine();
            if (!line.toLowerCase().startsWith("version")) {
                readText.reset();
            }
            ArrayList<String> list = new ArrayList<String>();
            try {
                while ((newEntry = this.ldifutil.readLdifEntry(readText)) != null) {
                    if (query.isCancelled()) {
                        return;
                    }
                    int size = newEntry.getDN().size();
                    if (size != 0) {
                        newDN = newEntry.getDN();
                        if (apex == null || apex.getDN().size() > size) {
                            apex = newEntry;
                        }
                        this.translateToUnicode(newEntry);
                        b.unthreadedModify(null, newEntry);
                        if (!list.contains(this.getRoot(b, newDN))) {
                            list.add(this.getRoot(b, newDN));
                        }
                    } else {
                        log.warning("skipping ldif entry with no dn: ");
                    }
                    pmonitor.getProgressMonitor().setNote(CBIntText.get("reading entry # ") + ++numEntriesRead);
                }
            }
            catch (InterruptedIOException e) {
                return;
            }
            catch (IOException e2) {
                CBUtility.error(CBIntText.get("unable to read ldif file"), e2);
                return;
            }
            catch (NamingException e) {
                CBUtility.error(CBIntText.get("An error occured while processing the LDIF file: "), e);
                return;
            }
            if (this.tree.getRootDN() == null || this.tree.getRootDN().toString().equals(SmartTree.NODATA)) {
                for (int i = 0; i < list.size(); ++i) {
                    String root = list.get(i).toString();
                    this.tree.setRoot(root);
                    this.tree.getRootNode().setStructural(true);
                }
            }
            if (apex != null && apex.getDN() != null && apex.getDN().size() > 1) {
                this.tree.refresh(apex.getDN().parentDN());
            }
        }
        catch (IOException e) {
            log.warning("Unable to read file " + this.readFile.toString());
        }
        catch (Exception e2) {
            log.warning("error parsing file " + this.readFile.toString());
            log.warning("Error occured reading line: " + (line == null ? "*null line*" : line) + "\n   (debug info: err was : " + e2 + "\n  ");
            e2.printStackTrace();
        }
    }

    private String getRoot(Broker b, DN lastKnownDN) {
        DN root;
        if (b == null) {
            log.warning("error: no data source available in ldif import/view");
            return null;
        }
        if (lastKnownDN == null) {
            log.warning("error: no DN available in ldif import/view");
            return null;
        }
        DN test = root = lastKnownDN;
        try {
            while (root != null || root.size() > 0) {
                test = root.parentDN();
                if (test == null || !b.unthreadedExists(test) || test.size() == 0) {
                    return root.toString();
                }
                root = test;
            }
        }
        catch (NamingException e) {
            log.warning("Error testing root node " + test + "\n" + e);
        }
        log.warning("Unable to determine root node from " + lastKnownDN);
        return null;
    }

    private void closeDown() {
        try {
            if (pmonitor != null) {
                pmonitor.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void translateToUnicode(DXEntry entry) {
        if (!this.offline) {
            return;
        }
        try {
            NamingEnumeration atts = entry.getAll();
            while (atts.hasMoreElements()) {
                DXAttribute att = (DXAttribute)atts.nextElement();
                for (int i = 0; i < att.size(); ++i) {
                    byte[] seq;
                    if (att.get(i) instanceof String || !CBParse.isUTF8(seq = (byte[])att.get(i))) continue;
                    try {
                        String s = new String(seq, "UTF8");
                        att.remove(i);
                        att.add(i, s);
                        att.setString(true);
                        continue;
                    }
                    catch (Exception e) {
                        log.warning("couldn't convert: " + att.getID() + "\n       " + e);
                    }
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    static {
        log = Logger.getLogger(LdifImport.class.getName());
    }
}

