/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.LinkedList;
import java.util.function.Predicate;
import org.netbeans.modules.languages.hcl.ast.HCLElement;

public final class HCLTreeWalker {
    private HCLTreeWalker() {
    }

    public static void depthFirst(HCLElement root, Predicate<Step> t) {
        LinkedList<Step> process = new LinkedList<Step>();
        process.push(new Step(null, root, 0));
        while (!process.isEmpty()) {
            Step current = (Step)process.pop();
            if (!t.test(current)) continue;
            for (HCLElement hCLElement : current.node.elements()) {
                process.push(new Step(current.node, hCLElement, current.depth + 1));
            }
        }
    }

    public static void breadthFirst(HCLElement root, Predicate<Step> t) {
        LinkedList<Step> process = new LinkedList<Step>();
        process.add(new Step(null, root, 0));
        while (!process.isEmpty()) {
            Step current = (Step)process.pop();
            if (!t.test(current)) continue;
            for (HCLElement hCLElement : current.node.elements()) {
                process.add(new Step(current.node, hCLElement, current.depth + 1));
            }
        }
    }

    public record Step(HCLElement parent, HCLElement node, int depth) {
    }
}

