/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.util.concurrent.Future;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.java.lsp.server.debugging.NbProtocolServer;
import org.netbeans.modules.java.lsp.server.protocol.NbLspServer;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class LspSession {
    private final ProxyLookup.Controller lspServices = new ProxyLookup.Controller();
    private final ProxyLookup.Controller dapServices = new ProxyLookup.Controller();
    private final Lookup sessionLookup = new ProxyLookup(new Lookup[]{new ProxyLookup(this.lspServices), new ProxyLookup(this.dapServices), Lookup.getDefault()});
    private volatile NbLspServer lspServer;
    private volatile NbProtocolServer dapServer;

    LspSession() {
    }

    void setLspServer(NbLspServer lspServer) {
        LspSession.setServerLookup(lspServer, this.lspServices);
        this.lspServer = lspServer;
    }

    void setDapServer(NbProtocolServer dapServer) {
        LspSession.setServerLookup(dapServer, this.dapServices);
        this.dapServer = dapServer;
    }

    private static void setServerLookup(ScheduledServer server, ProxyLookup.Controller lookupControler) {
        if (server == null) {
            lookupControler.setLookups(new Lookup[0]);
        } else {
            Lookup l = server.getServerLookup();
            if (l != null) {
                lookupControler.setLookups(new Lookup[]{l});
            }
        }
    }

    @CheckForNull
    public NbLspServer getLspServer() {
        return this.lspServer;
    }

    public Lookup getLookup() {
        return this.sessionLookup;
    }

    @CheckForNull
    public NbProtocolServer getDapServer() {
        return this.dapServer;
    }

    public static interface ScheduledServer {
        public Future<Void> getRunningFuture();

        default public Lookup getServerLookup() {
            return null;
        }
    }
}

