/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.lsp.server.progress.LspInternalHandle;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorkerWithModel;
import org.netbeans.modules.progress.spi.TaskModel;

public class LspProgressUIWorker
implements ProgressUIWorkerWithModel {
    private static final Logger LOG = Logger.getLogger(LspProgressUIWorker.class.getName());
    private TaskModel taskModel;

    public void setModel(TaskModel model) {
        this.taskModel = model;
    }

    public void showPopup() {
    }

    public void processProgressEvent(ProgressEvent event) {
        InternalHandle h = event.getSource();
        if (!(h instanceof LspInternalHandle)) {
            return;
        }
        LspInternalHandle lsHandle = (LspInternalHandle)h;
        switch (event.getType()) {
            case 0: {
                lsHandle.sendStartMessage(event);
                break;
            }
            case 1: 
            case 5: {
                lsHandle.sendProgress(event);
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                lsHandle.sendFinish(event);
                break;
            }
            default: {
                LOG.log(Level.INFO, "Unexpected progress event type for {0}: {1}", new Object[]{lsHandle, event.getType()});
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent event) {
    }
}

