/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AppVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="releaseDate")
    private final String releaseDate;
    @JsonProperty(value="endOfSupport")
    private final String endOfSupport;
    @JsonProperty(value="supportedAppName")
    private final String supportedAppName;
    @JsonProperty(value="isCertified")
    private final Boolean isCertified;

    @Deprecated
    @ConstructorProperties(value={"releaseDate", "endOfSupport", "supportedAppName", "isCertified"})
    public AppVersionSummary(String releaseDate, String endOfSupport, String supportedAppName, Boolean isCertified) {
        this.releaseDate = releaseDate;
        this.endOfSupport = endOfSupport;
        this.supportedAppName = supportedAppName;
        this.isCertified = isCertified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getEndOfSupport() {
        return this.endOfSupport;
    }

    public String getSupportedAppName() {
        return this.supportedAppName;
    }

    public Boolean getIsCertified() {
        return this.isCertified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(", endOfSupport=").append(String.valueOf(this.endOfSupport));
        sb.append(", supportedAppName=").append(String.valueOf(this.supportedAppName));
        sb.append(", isCertified=").append(String.valueOf(this.isCertified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppVersionSummary)) {
            return false;
        }
        AppVersionSummary other = (AppVersionSummary)((Object)o);
        return Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.endOfSupport, other.endOfSupport) && Objects.equals(this.supportedAppName, other.supportedAppName) && Objects.equals(this.isCertified, other.isCertified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + (this.endOfSupport == null ? 43 : this.endOfSupport.hashCode());
        result = result * 59 + (this.supportedAppName == null ? 43 : this.supportedAppName.hashCode());
        result = result * 59 + (this.isCertified == null ? 43 : this.isCertified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="releaseDate")
        private String releaseDate;
        @JsonProperty(value="endOfSupport")
        private String endOfSupport;
        @JsonProperty(value="supportedAppName")
        private String supportedAppName;
        @JsonProperty(value="isCertified")
        private Boolean isCertified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public Builder endOfSupport(String endOfSupport) {
            this.endOfSupport = endOfSupport;
            this.__explicitlySet__.add("endOfSupport");
            return this;
        }

        public Builder supportedAppName(String supportedAppName) {
            this.supportedAppName = supportedAppName;
            this.__explicitlySet__.add("supportedAppName");
            return this;
        }

        public Builder isCertified(Boolean isCertified) {
            this.isCertified = isCertified;
            this.__explicitlySet__.add("isCertified");
            return this;
        }

        public AppVersionSummary build() {
            AppVersionSummary model = new AppVersionSummary(this.releaseDate, this.endOfSupport, this.supportedAppName, this.isCertified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AppVersionSummary model) {
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            if (model.wasPropertyExplicitlySet("endOfSupport")) {
                this.endOfSupport(model.getEndOfSupport());
            }
            if (model.wasPropertyExplicitlySet("supportedAppName")) {
                this.supportedAppName(model.getSupportedAppName());
            }
            if (model.wasPropertyExplicitlySet("isCertified")) {
                this.isCertified(model.getIsCertified());
            }
            return this;
        }
    }
}

