/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class FieldRedeclarationHintError
extends HintErrorRule {
    public String getDisplayName() {
        return Bundle.FieldRedeclarationHintErrorDisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredClasses(fileScope), hints, fileObject);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypeScopes(ModelUtils.getDeclaredTraits(fileScope), hints, fileObject);
        }
    }

    private void checkTypeScopes(Collection<? extends TypeScope> typeScopes, List<Hint> hints, FileObject fileObject) {
        for (TypeScope typeScope : typeScopes) {
            for (FieldElement field : this.getRedeclaredFields(typeScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                hints.add(new Hint((Rule)this, Bundle.FieldRedeclarationCustom(field.getName()), fileObject, field.getNameRange(), null, 500));
            }
        }
    }

    private Set<FieldElement> getRedeclaredFields(TypeScope typeScope) {
        Collection<? extends FieldElement> declaredFields;
        if (typeScope instanceof ClassScope) {
            declaredFields = ((ClassScope)typeScope).getDeclaredFields();
        } else if (typeScope instanceof TraitScope) {
            declaredFields = ((TraitScope)typeScope).getDeclaredFields();
        } else {
            return Collections.emptySet();
        }
        HashSet<FieldElement> redeclaredFields = new HashSet<FieldElement>();
        HashMap<String, FieldElement> firstDeclaredFields = new HashMap<String, FieldElement>();
        for (FieldElement fieldElement : declaredFields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return Collections.emptySet();
            }
            if (fieldElement.isAnnotation()) continue;
            String fieldName = fieldElement.getName();
            FieldElement firstDeclaredField = (FieldElement)firstDeclaredFields.get(fieldName);
            if (firstDeclaredField == null) {
                firstDeclaredFields.put(fieldName, fieldElement);
                continue;
            }
            if (firstDeclaredField.getOffset() > fieldElement.getOffset()) {
                FieldElement oldField = firstDeclaredFields.replace(fieldName, fieldElement);
                redeclaredFields.add(oldField);
                continue;
            }
            redeclaredFields.add(fieldElement);
        }
        return redeclaredFields;
    }
}

