/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table.celleditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.db.dataview.table.celleditor.AlwaysEnable;
import org.netbeans.modules.db.dataview.table.celleditor.MonitorableStreamTransfer;
import org.netbeans.modules.db.dataview.table.celleditor.StringTableCellEditor;
import org.netbeans.modules.db.dataview.util.CharsetSelector;
import org.netbeans.modules.db.dataview.util.EncodingHelper;
import org.netbeans.modules.db.dataview.util.FileBackedBlob;
import org.netbeans.modules.db.dataview.util.LobHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class BlobFieldTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
AlwaysEnable {
    private static final Logger LOG = Logger.getLogger(BlobFieldTableCellEditor.class.getName());
    private static final String EDIT = "edit";
    private static File lastFile;
    private static Charset lastSelectedCharset;
    private Blob currentValue;
    private JButton button = new JButton();
    private JPopupMenu popup;
    private JTable table;
    private int currentRow;
    private int currentColumn;
    private int currentModelColumn;
    private int currentModelRow;
    private JMenuItem saveContentMenuItem;
    private JMenuItem miOpenImageMenuItem;
    private JMenuItem miOpenAsTextMenuItem;
    private JMenuItem miLobLoadAction;
    private JMenuItem miLobNullAction;

    public BlobFieldTableCellEditor() {
        this.button.setActionCommand(EDIT);
        this.button.addActionListener(this);
        this.button.setContentAreaFilled(false);
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.button.setRolloverEnabled(false);
        this.button.setAlignmentX(0.0f);
        this.button.setHorizontalAlignment(2);
        this.button.setFont(new Font(this.button.getFont().getFamily(), 2, 9));
        this.popup = new JPopupMenu();
        this.miOpenImageMenuItem = new JMenuItem("Open as Image");
        this.miOpenImageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.openAsImage(BlobFieldTableCellEditor.this.currentValue);
                BlobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.popup.add(this.miOpenImageMenuItem);
        this.miOpenAsTextMenuItem = new JMenuItem("Open as Text");
        this.miOpenAsTextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.openAsText();
                BlobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.popup.add(this.miOpenAsTextMenuItem);
        this.popup.addSeparator();
        this.saveContentMenuItem = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"saveLob.title"));
        this.saveContentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.saveLobToFile(BlobFieldTableCellEditor.this.currentValue);
                BlobFieldTableCellEditor.this.fireEditingCanceled();
            }
        });
        this.popup.add(this.saveContentMenuItem);
        this.miLobLoadAction = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"loadLob.title"));
        this.miLobLoadAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Blob newValue = BlobFieldTableCellEditor.this.loadLobFromFile();
                if (newValue != null) {
                    BlobFieldTableCellEditor.this.currentValue = newValue;
                }
                BlobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(this.miLobLoadAction);
        this.miLobNullAction = new JMenuItem(NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"nullLob.title"));
        this.miLobNullAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlobFieldTableCellEditor.this.currentValue = null;
                BlobFieldTableCellEditor.this.fireEditingStopped();
            }
        });
        this.popup.add(this.miLobNullAction);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (EDIT.equals(e.getActionCommand())) {
            this.popup.show(this.button, 0, this.button.getHeight());
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentValue = (Blob)value;
        int modelRow = table.convertRowIndexToModel(row);
        int modelColumn = table.convertColumnIndexToModel(column);
        boolean editable = table.getModel().isCellEditable(modelRow, modelColumn);
        if (this.currentValue != null) {
            this.saveContentMenuItem.setEnabled(true);
            this.miOpenImageMenuItem.setEnabled(true);
            this.button.setText(LobHelper.blobToString(this.currentValue));
        } else {
            this.saveContentMenuItem.setEnabled(false);
            this.miOpenImageMenuItem.setEnabled(false);
            this.button.setText("<NULL>");
        }
        this.miLobLoadAction.setEnabled(editable);
        this.miLobNullAction.setEnabled(editable);
        this.table = table;
        this.currentColumn = column;
        this.currentRow = row;
        this.currentModelColumn = table.convertColumnIndexToModel(column);
        this.currentModelRow = table.convertRowIndexToModel(row);
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return super.isCellEditable(anEvent);
    }

    private void saveLobToFile(Blob b) {
        if (b == null) {
            return;
        }
        JFileChooser c = new JFileChooser();
        c.setCurrentDirectory(lastFile);
        int fileDialogState = c.showSaveDialog(this.table);
        if (fileDialogState == 0) {
            File f;
            lastFile = f = c.getSelectedFile();
            try {
                InputStream is = b.getBinaryStream();
                FileOutputStream fos = new FileOutputStream(f);
                if (!this.doTransfer(is, fos, (int)b.length(), "Saving to file: " + f.toString())) {
                    f.delete();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOError while saving BLOB to file", ex);
                this.displayError(f, ex, false);
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while saving BLOB to file", ex);
                this.displayError(f, ex, false);
            }
        }
    }

    private Blob loadLobFromFile() {
        JFileChooser c = new JFileChooser();
        c.setCurrentDirectory(lastFile);
        FileBackedBlob result = null;
        int fileDialogState = c.showOpenDialog(this.table);
        if (fileDialogState == 0) {
            File f;
            lastFile = f = c.getSelectedFile();
            try {
                FileInputStream fis = new FileInputStream(f);
                result = new FileBackedBlob();
                if (!this.doTransfer(fis, result.setBinaryStream(1L), (int)f.length(), "Loading file: " + f.toString())) {
                    result = null;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "IOError while loading BLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
            catch (SQLException ex) {
                LOG.log(Level.INFO, "SQLException while loading BLOB from file", ex);
                this.displayError(f, ex, true);
                result = null;
            }
        }
        return result;
    }

    private boolean doTransfer(InputStream is, OutputStream os, Integer size, String title) throws IOException {
        MonitorableStreamTransfer ft = new MonitorableStreamTransfer(is, os, size);
        Throwable t = size == null || size > 0x100000 ? (Throwable)ProgressUtils.showProgressDialogAndRun((ProgressRunnable)ft, (String)title, (boolean)false) : ft.run(null);
        is.close();
        os.close();
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t != null) {
            throw new RuntimeException(t);
        }
        return !ft.isCancel();
    }

    private void displayError(File f, Exception ex, boolean read) {
        String messageMsg;
        String titleMsg;
        DialogDisplayer dd = DialogDisplayer.getDefault();
        String errorObjectMsg = ex instanceof SQLException ? NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"lobErrorObject.database") : NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"lobErrorObject.file");
        if (!read) {
            titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobSaveToFileError.title");
            messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobSaveToFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        } else {
            titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobReadFromFileError.title");
            messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"blobReadFromFileError.message", (Object)errorObjectMsg, (Object)f.getAbsolutePath(), (Object)ex.getLocalizedMessage());
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)messageMsg, titleMsg, 2, 2, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION);
        dd.notifyLater(nd);
    }

    private void openAsImage(Blob b) {
        if (b == null) {
            return;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(b.getBinaryStream());
            Iterator<ImageReader> irs = ImageIO.getImageReaders(iis);
            if (irs.hasNext()) {
                FileSystem fs = FileUtil.createMemoryFileSystem();
                FileObject fob = fs.getRoot().createData(Long.toString(System.currentTimeMillis()), irs.next().getFormatName());
                OutputStream os = fob.getOutputStream();
                os.write(b.getBytes(1L, (int)b.length()));
                os.close();
                DataObject data = DataObject.find((FileObject)fob);
                OpenCookie cookie = (OpenCookie)data.getLookup().lookup(OpenCookie.class);
                if (cookie != null) {
                    cookie.open();
                    return;
                }
            }
            this.displayErrorOpenImage("openImageErrorNotImage.message");
        }
        catch (SQLException ex) {
            LOG.log(Level.INFO, "SQLException while opening BLOB as file", ex);
            this.displayErrorOpenImage("openImageErrorDB.message");
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "IOError while opening BLOB as file", ex);
        }
    }

    private void displayErrorOpenImage(String messageProperty) {
        DialogDisplayer dd = DialogDisplayer.getDefault();
        String messageMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)messageProperty);
        String titleMsg = NbBundle.getMessage(BlobFieldTableCellEditor.class, (String)"openImageError.title");
        NotifyDescriptor nd = new NotifyDescriptor((Object)messageMsg, titleMsg, 2, 2, new Object[]{NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.CANCEL_OPTION);
        dd.notifyLater(nd);
    }

    protected void openAsText() {
        Charset detectedCharset = this.detectEncoding();
        final CharsetSelector charsetSelector = new CharsetSelector();
        charsetSelector.setSelectedItem(detectedCharset == null ? lastSelectedCharset : detectedCharset);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        final JTextArea textArea = new JTextArea(20, 80);
        textArea.setDropTarget(null);
        textArea.setText(this.getTextFromCurrentCell(charsetSelector.getSelectedItem()));
        textArea.setCaretPosition(0);
        textArea.setEditable(this.table.getModel().isCellEditable(this.currentModelRow, this.currentModelColumn));
        JScrollPane pane = new JScrollPane(textArea);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 256;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)new JLabel("Charset-Encoding: "), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 256;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)charsetSelector, gbc);
        JButton reloadButton = new JButton("Reload");
        reloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textArea.setText(BlobFieldTableCellEditor.this.getTextFromCurrentCell(charsetSelector.getSelectedItem()));
                lastSelectedCharset = charsetSelector.getSelectedItem();
            }
        });
        gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        panel.add((Component)reloadButton, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)pane, gbc);
        pane.addHierarchyListener(new StringTableCellEditor.MakeResizableListener(panel));
        Frame parent = WindowManager.getDefault().getMainWindow();
        if (this.table.isCellEditable(this.currentRow, this.currentColumn)) {
            int result = JOptionPane.showOptionDialog(parent, panel, this.table.getColumnName(this.currentColumn), 2, -1, null, null, null);
            if (result == 0) {
                try {
                    this.table.setValueAt(new FileBackedBlob(new ByteArrayInputStream(textArea.getText().getBytes(charsetSelector.getSelectedItem()))), this.currentRow, this.currentColumn);
                    lastSelectedCharset = charsetSelector.getSelectedItem();
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            JOptionPane.showMessageDialog(parent, panel, this.table.getColumnName(this.currentColumn), -1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Charset detectEncoding() {
        if (this.currentValue == null) {
            return null;
        }
        InputStream blobStream = null;
        try {
            blobStream = this.currentValue.getBinaryStream();
            BufferedInputStream inputStream = new BufferedInputStream(blobStream);
            String charsetName = EncodingHelper.detectEncoding(inputStream);
            Charset result = null;
            if (charsetName != null) {
                result = Charset.forName(charsetName);
            }
            Charset charset = result;
            return charset;
        }
        catch (IOException | SQLException ex) {
            LOG.log(Level.FINE, "Failed to read BLOB contents.", ex);
        }
        finally {
            if (blobStream != null) {
                try {
                    blobStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTextFromCurrentCell(Charset charset) {
        if (this.currentValue == null) {
            return "";
        }
        InputStream blobStream = null;
        try {
            int read;
            blobStream = this.currentValue.getBinaryStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(blobStream, charset));
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1024];
            while ((read = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, read);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException | SQLException ex) {
            LOG.log(Level.FINE, "Failed to read BLOB contents.", ex);
        }
        finally {
            if (blobStream != null) {
                try {
                    blobStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    static {
        lastSelectedCharset = Charset.defaultCharset();
    }
}

