/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.ContextASTEvaluator;
import org.netbeans.modules.languages.features.SemanticHighlightsLayer;
import org.netbeans.modules.languages.parser.SyntaxError;

class UsagesASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<UsagesASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<UsagesASTEvaluator>>();
    private Document document;
    private ParserManagerImpl parserManager;
    private Set<DatabaseDefinition> definitions;
    private List<DatabaseItem> unresolvedUsages;
    private List<Boolean> unresolvedUsages_declaration_precedes_ussage;
    private static AttributeSet unusedParameterAttributeSet;
    private static AttributeSet syntaxErrorAttributeSet;
    private static AttributeSet parameterAttributeSet;
    private static AttributeSet unusedLocalVariableAttributeSet;
    private static AttributeSet unresolvedUssageAttributeSet;
    private static AttributeSet localVariableAttributeSet;
    private static AttributeSet unusedFieldAttributeSet;
    private static AttributeSet fieldAttributeSet;

    static void register(Document document) {
        if (UsagesASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<UsagesASTEvaluator>(new UsagesASTEvaluator(document)));
    }

    static void unregister(Document document) {
        UsagesASTEvaluator evaluator = UsagesASTEvaluator.get(document);
        if (evaluator != null) {
            ParserManager.get(document).removeASTEvaluator(evaluator);
        }
        cache.remove(document);
    }

    static UsagesASTEvaluator get(Document document) {
        WeakReference<UsagesASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (UsagesASTEvaluator)weakReference.get();
    }

    static void addDatabaseDefinition(Document document, DatabaseDefinition definition) {
        UsagesASTEvaluator evaluator = UsagesASTEvaluator.get(document);
        evaluator.definitions.add(definition);
    }

    UsagesASTEvaluator(Document document) {
        this.document = document;
        this.parserManager = (ParserManagerImpl)ParserManager.get(document);
        this.parserManager.addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode root) {
        this.unresolvedUsages = null;
        this.definitions = new HashSet<DatabaseDefinition>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode root) {
        if (this.unresolvedUsages != null) {
            Iterator<DatabaseItem> it = this.unresolvedUsages.iterator();
            Iterator<Boolean> it2 = this.unresolvedUsages_declaration_precedes_ussage.iterator();
            while (it.hasNext()) {
                if (this.parserManager != null && this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                DatabaseUsage usage = (DatabaseUsage)it.next();
                DatabaseContext context = (DatabaseContext)it.next();
                boolean declaration_precedes_ussage = it2.next();
                DatabaseDefinition definition = context.getDefinition(usage.getName(), usage.getOffset());
                if (definition != null) {
                    if (declaration_precedes_ussage && definition.getOffset() > usage.getOffset()) continue;
                    definition.addUsage(usage);
                    context.addUsage(usage);
                    usage.setDatabaseDefinition(definition);
                    this.highlightUssage(usage, definition);
                    if (!this.definitions.contains(definition)) continue;
                    this.highlightDefinition(definition);
                    this.definitions.remove(definition);
                    continue;
                }
                this.highlightUnresolvedUssage(usage);
            }
            this.unresolvedUsages = null;
        }
        Iterator<DatabaseDefinition> it2 = this.definitions.iterator();
        while (it2.hasNext()) {
            this.highlightUnusedDefinition(it2.next());
        }
        for (SyntaxError syntaxError : this.parserManager.getSyntaxErrors()) {
            this.highlightSyntaxError(syntaxError, root);
        }
        SemanticHighlightsLayer.update(this.document);
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> path, Feature feature) {
        SyntaxContext sc = SyntaxContext.create(this.document, ASTPath.create(path));
        if (!feature.getBoolean("condition", sc, true)) {
            return;
        }
        ASTItem leaf = path.get(path.size() - 1);
        DatabaseContext context = ContextASTEvaluator.getCurrentContext(this.document, leaf.getOffset());
        String name = ((String)feature.getValue("name", sc)).trim();
        boolean declaration_precedes_ussage = feature.getBoolean("declaration_precedes_usage", true);
        DatabaseDefinition definition = context.getDefinition(name, leaf.getOffset());
        if (definition != null && definition.getOffset() == leaf.getOffset()) {
            return;
        }
        if (definition != null && declaration_precedes_ussage && definition.getOffset() > leaf.getOffset()) {
            return;
        }
        DatabaseUsage usage = new DatabaseUsage(name, leaf.getOffset(), leaf.getEndOffset());
        if (definition != null) {
            definition.addUsage(usage);
            usage.setDatabaseDefinition(definition);
            context.addUsage(usage);
            this.highlightUssage(usage, definition);
            if (this.definitions.contains(definition)) {
                this.highlightDefinition(definition);
                this.definitions.remove(definition);
            }
        } else {
            if (this.unresolvedUsages == null) {
                this.unresolvedUsages = new ArrayList<DatabaseItem>();
                this.unresolvedUsages_declaration_precedes_ussage = new ArrayList<Boolean>();
            }
            this.unresolvedUsages.add(usage);
            this.unresolvedUsages.add(context);
            this.unresolvedUsages_declaration_precedes_ussage.add(declaration_precedes_ussage);
        }
        ContextASTEvaluator.setEvaluated(this.document, true);
    }

    @Override
    public String getFeatureName() {
        return "SEMANTIC_USAGE";
    }

    private void highlightUssage(DatabaseUsage usage, DatabaseDefinition definition) {
        if ("parameter".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, usage.getOffset(), usage.getEndOffset(), UsagesASTEvaluator.getParameterAttributes());
        } else if ("local".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, usage.getOffset(), usage.getEndOffset(), UsagesASTEvaluator.getLocalVariableAttributes());
        } else if ("field".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, usage.getOffset(), usage.getEndOffset(), UsagesASTEvaluator.getFieldAttributes());
        }
    }

    private void highlightUnresolvedUssage(DatabaseUsage usage) {
    }

    private void highlightSyntaxError(SyntaxError syntaxError, ASTNode root) {
        ASTItem item = syntaxError.getItem();
        if (item.getLength() == 0) {
            int offset = item.getOffset();
            if (offset >= root.getEndOffset()) {
                offset = root.getEndOffset() - 1;
            }
            item = root.findPath(offset).getLeaf();
        }
        SemanticHighlightsLayer.addHighlight(this.document, item.getOffset(), item.getEndOffset(), UsagesASTEvaluator.getSyntaxErrorAttributes());
    }

    private void highlightDefinition(DatabaseDefinition definition) {
        if ("parameter".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getParameterAttributes());
        } else if ("variable".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getLocalVariableAttributes());
        } else if ("field".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getFieldAttributes());
        }
    }

    private void highlightUnusedDefinition(DatabaseDefinition definition) {
        if ("parameter".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getUnusedParameterAttributes());
        } else if ("field".equals(definition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getUnusedFieldAttributes());
        } else {
            SemanticHighlightsLayer.addHighlight(this.document, definition.getOffset(), definition.getEndOffset(), UsagesASTEvaluator.getUnusedLocalVariableAttributes());
        }
    }

    private static AttributeSet getUnusedParameterAttributes() {
        if (unusedParameterAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            unusedParameterAttributeSet = sas;
        }
        return unusedParameterAttributeSet;
    }

    private static AttributeSet getSyntaxErrorAttributes() {
        if (syntaxErrorAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(EditorStyleConstants.WaveUnderlineColor, Color.red);
            syntaxErrorAttributeSet = sas;
        }
        return syntaxErrorAttributeSet;
    }

    private static AttributeSet getParameterAttributes() {
        if (parameterAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            parameterAttributeSet = sas;
        }
        return parameterAttributeSet;
    }

    private static AttributeSet getUnusedLocalVariableAttributes() {
        if (unusedLocalVariableAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            unusedLocalVariableAttributeSet = sas;
        }
        return unusedLocalVariableAttributeSet;
    }

    private static AttributeSet getUnresolvedUssageAttributes() {
        if (unresolvedUssageAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(EditorStyleConstants.WaveUnderlineColor, Color.red);
            unresolvedUssageAttributeSet = sas;
        }
        return unresolvedUssageAttributeSet;
    }

    private static AttributeSet getLocalVariableAttributes() {
        if (localVariableAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            localVariableAttributeSet = sas;
        }
        return localVariableAttributeSet;
    }

    private static AttributeSet getUnusedFieldAttributes() {
        if (unusedFieldAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            StyleConstants.setForeground(sas, new Color(0, 153, 0));
            unusedFieldAttributeSet = sas;
        }
        return unusedFieldAttributeSet;
    }

    private static AttributeSet getFieldAttributes() {
        if (fieldAttributeSet == null) {
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setForeground(sas, new Color(0, 153, 0));
            fieldAttributeSet = sas;
        }
        return fieldAttributeSet;
    }
}

