/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.output;

import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.netbeans.modules.gsf.testrunner.ui.output.OutputDocument;
import org.openide.awt.GraphicsUtils;

final class OutputView
extends PlainView {
    private final Segment SEGMENT = new Segment();
    private final OutputDocument.RootElement rootElement;
    private int selStart;
    private int selEnd;
    private static Color selectedErr = UIManager.getColor("nb.output.err.foreground.selected");
    private static Color unselectedErr;
    private Color selectedFg;
    private Color unselectedFg;

    OutputView(Element element) {
        super(element);
        this.rootElement = (OutputDocument.RootElement)element;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        Container container = this.getContainer();
        if (container instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)container;
            this.selStart = textComp.getSelectionStart();
            this.selEnd = textComp.getSelectionEnd();
            this.unselectedFg = textComp.isEnabled() ? textComp.getForeground() : textComp.getDisabledTextColor();
            this.selectedFg = textComp.getCaret().isSelectionVisible() ? textComp.getSelectedTextColor() : this.unselectedFg;
        }
        super.paint(g, a);
    }

    @Override
    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        OutputDocument.DocElement docElem = this.rootElement.getDocElement(lineIndex);
        try {
            this.drawLine(docElem, g, x, y);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("cannot draw line " + lineIndex);
        }
    }

    private void drawLine(OutputDocument.DocElement elem, Graphics g, int x, int y) throws BadLocationException {
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        boolean isError = elem.isError;
        if (this.selStart == this.selEnd || this.selectedFg == this.unselectedFg) {
            x = this.drawText(g, x, y, p0, p1, isError, false, elem);
        } else if (p0 >= this.selStart && p0 <= this.selEnd && p1 >= this.selStart && p1 <= this.selEnd) {
            x = this.drawText(g, x, y, p0, p1, isError, true, elem);
        } else if (this.selStart >= p0 && this.selStart <= p1) {
            if (this.selEnd >= p0 && this.selEnd <= p1) {
                x = this.drawText(g, x, y, p0, this.selStart, isError, false, elem);
                x = this.drawText(g, x, y, this.selStart, this.selEnd, isError, true, elem);
                x = this.drawText(g, x, y, this.selEnd, p1, isError, false, elem);
            } else {
                x = this.drawText(g, x, y, p0, this.selStart, isError, false, elem);
                x = this.drawText(g, x, y, this.selStart, p1, isError, true, elem);
            }
        } else if (this.selEnd >= p0 && this.selEnd <= p1) {
            x = this.drawText(g, x, y, p0, this.selEnd, isError, true, elem);
            x = this.drawText(g, x, y, this.selEnd, p1, isError, false, elem);
        } else {
            x = this.drawText(g, x, y, p0, p1, isError, false, elem);
        }
    }

    private int drawText(Graphics g, int x, int y, int startOffset, int endOffset, boolean error, boolean selected, OutputDocument.DocElement docElem) throws BadLocationException {
        Segment s = EventQueue.isDispatchThread() ? this.SEGMENT : new Segment();
        s.array = docElem.getChars();
        s.offset = startOffset - docElem.offset;
        s.count = endOffset - startOffset;
        g.setColor(this.getColor(error, selected));
        return Utilities.drawTabbedText(s, x, y, g, (TabExpander)this, startOffset);
    }

    private Color getColor(boolean error, boolean selected) {
        return error ? (selected ? selectedErr : unselectedErr) : (selected ? this.selectedFg : this.unselectedFg);
    }

    static {
        if (selectedErr == null) {
            selectedErr = new Color(164, 0, 0);
        }
        if ((unselectedErr = UIManager.getColor("nb.output.err.foreground")) == null) {
            unselectedErr = selectedErr;
        }
    }
}

