/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.timers.TimesCollectorPeer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;

public class Install
extends ModuleInstall {
    static final boolean ENABLED;
    private static Handler timers;
    private static PropertyChangeListener docTracker;
    private static String INSTANCES;

    public void restored() {
        if (!ENABLED) {
            return;
        }
        Logger log = Logger.getLogger("TIMER");
        log.setUseParentHandlers(false);
        log.setLevel(Level.FINE);
        log.addHandler(timers);
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)docTracker);
    }

    static {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ENABLED = assertionsEnabled || Boolean.getBoolean("org.netbeans.modules.timers.enable");
        timers = new TimerHandler();
        docTracker = new ActivatedDocumentListener();
        INSTANCES = "Important instances";
    }

    private static class TimerHandler
    extends Handler {
        TimerHandler() {
        }

        @Override
        public void publish(LogRecord rec) {
            Object[] args;
            String message = rec.getMessage();
            if (rec.getResourceBundle() != null) {
                try {
                    message = rec.getResourceBundle().getString(rec.getMessage());
                    if (rec.getParameters() != null) {
                        message = MessageFormat.format(message, rec.getParameters());
                    }
                }
                catch (MissingResourceException ex) {
                    Logger.getAnonymousLogger().log(Level.INFO, null, ex);
                }
            }
            if ((args = rec.getParameters()) == null || args[0] == null) {
                return;
            }
            if (args.length == 1) {
                TimesCollectorPeer.getDefault().reportReference(INSTANCES, rec.getMessage(), message, args[0]);
                return;
            }
            if (args.length < 2) {
                return;
            }
            Object key = args[0];
            if (args[1] instanceof Number) {
                TimesCollectorPeer.getDefault().reportTime(key, rec.getMessage(), message, ((Number)args[1]).longValue());
            } else if (!(args[1] instanceof Boolean)) {
                String txt = message.startsWith("[M]") ? message : "[M] " + message;
                TimesCollectorPeer.getDefault().reportReference(key, rec.getMessage(), txt, args[1]);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static class ActivatedDocumentListener
    implements PropertyChangeListener {
        ActivatedDocumentListener() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            JTextComponent jtc = EditorRegistry.focusedComponent();
            if (jtc == null) {
                return;
            }
            Document active = jtc.getDocument();
            Object sourceProperty = active.getProperty("stream");
            if (!(sourceProperty instanceof DataObject)) {
                return;
            }
            FileObject activeFile = ((DataObject)sourceProperty).getPrimaryFile();
            TimesCollectorPeer.getDefault().select(activeFile);
        }
    }
}

