/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.beans.PropertyEditor;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.ValuePropertyEditor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.TablePropertyEditorsModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class VariablesPropertyEditorsModel
implements TablePropertyEditorsModel {
    private static final Map<Variable, PropertyEditorRef> propertyEditors = new WeakHashMap<Variable, PropertyEditorRef>();
    private ContextProvider contextProvider;

    public VariablesPropertyEditorsModel(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyEditor getPropertyEditor(Object node, String columnID) throws UnknownTypeException {
        if (("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) && node instanceof Variable) {
            Object pe = null;
            Map<Variable, PropertyEditorRef> map = propertyEditors;
            synchronized (map) {
                PropertyEditorRef ref = propertyEditors.get((Variable)node);
                if (ref != null) {
                    pe = ref.get();
                }
                if (pe == null) {
                    pe = new ValuePropertyEditor(this.contextProvider);
                    propertyEditors.put((Variable)node, new PropertyEditorRef((PropertyEditor)pe));
                }
                return pe;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ValuePropertyEditor getExistingValuePropertyEditor(Variable var) {
        Map<Variable, PropertyEditorRef> map = propertyEditors;
        synchronized (map) {
            PropertyEditorRef ref = propertyEditors.get(var);
            if (ref != null) {
                return (ValuePropertyEditor)((Object)ref.getFromEDT());
            }
        }
        return null;
    }

    private static final class PropertyEditorRef
    extends SoftReference<PropertyEditor> {
        private final Thread createdBy = Thread.currentThread();
        private final boolean isEDT = SwingUtilities.isEventDispatchThread();

        public PropertyEditorRef(PropertyEditor referent) {
            super(referent);
        }

        @Override
        public PropertyEditor get() {
            if (Thread.currentThread() != this.createdBy) {
                return null;
            }
            return (PropertyEditor)super.get();
        }

        PropertyEditor getFromEDT() {
            if (this.isEDT) {
                return (PropertyEditor)super.get();
            }
            return null;
        }
    }
}

