/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.ServerStreamConnection;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfig;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfigImpl;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.server.XmlRpcHttpServer;
import org.apache.xmlrpc.server.XmlRpcHttpServerConfig;
import org.apache.xmlrpc.util.HttpUtil;

public class XmlRpcServletServer
extends XmlRpcHttpServer {
    protected XmlRpcHttpRequestConfigImpl newConfig(HttpServletRequest pRequest) {
        return new XmlRpcHttpRequestConfigImpl();
    }

    protected XmlRpcHttpRequestConfigImpl getConfig(HttpServletRequest pRequest) {
        XmlRpcHttpRequestConfigImpl result = this.newConfig(pRequest);
        XmlRpcHttpServerConfig serverConfig = (XmlRpcHttpServerConfig)this.getConfig();
        result.setBasicEncoding(serverConfig.getBasicEncoding());
        result.setContentLengthOptional(serverConfig.isContentLengthOptional() && pRequest.getHeader("Content-Length") == null);
        result.setEnabledForExtensions(serverConfig.isEnabledForExtensions());
        result.setGzipCompressing(HttpUtil.isUsingGzipEncoding(pRequest.getHeader("Content-Encoding")));
        result.setGzipRequesting(HttpUtil.isUsingGzipEncoding(pRequest.getHeaders("Accept-Encoding")));
        result.setEncoding(pRequest.getCharacterEncoding());
        result.setEnabledForExceptions(serverConfig.isEnabledForExceptions());
        HttpUtil.parseAuthorization(result, pRequest.getHeader("Authorization"));
        return result;
    }

    protected ServletStreamConnection newStreamConnection(HttpServletRequest pRequest, HttpServletResponse pResponse) {
        return new ServletStreamConnection(pRequest, pResponse);
    }

    public void execute(HttpServletRequest pRequest, HttpServletResponse pResponse) throws ServletException, IOException {
        XmlRpcHttpRequestConfigImpl config = this.getConfig(pRequest);
        ServletStreamConnection ssc = this.newStreamConnection(pRequest, pResponse);
        try {
            super.execute(config, ssc);
        }
        catch (XmlRpcException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean isContentLengthRequired(XmlRpcStreamRequestConfig pConfig) {
        boolean isRequired;
        if (!pConfig.isEnabledForExtensions()) {
            return true;
        }
        boolean bl = isRequired = !((XmlRpcHttpServerConfig)this.getConfig()).isContentLengthOptional();
        if (pConfig instanceof XmlRpcHttpRequestConfig) {
            isRequired |= !((XmlRpcHttpRequestConfig)pConfig).isContentLengthOptional();
        }
        return isRequired;
    }

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, ServerStreamConnection pConnection, int pSize) throws IOException {
        if (pSize != -1) {
            ((ServletStreamConnection)pConnection).getResponse().setContentLength(pSize);
        }
        return super.getOutputStream(pConfig, pConnection, pSize);
    }

    protected void setResponseHeader(ServerStreamConnection pConnection, String pHeader, String pValue) {
        ((ServletStreamConnection)pConnection).getResponse().setHeader(pHeader, pValue);
    }

    protected static class ServletStreamConnection
    implements ServerStreamConnection {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        protected ServletStreamConnection(HttpServletRequest pRequest, HttpServletResponse pResponse) {
            this.request = pRequest;
            this.response = pResponse;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public InputStream newInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public OutputStream newOutputStream() throws IOException {
            this.response.setContentType("text/xml");
            return this.response.getOutputStream();
        }

        public void close() throws IOException {
            this.response.getOutputStream().close();
        }
    }
}

