/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.actions;

import com.sun.jdi.ObjectReference;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.netbeans.modules.debugger.jpda.visual.RemoteFXScreenshot;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.RetrievalException;
import org.netbeans.modules.debugger.jpda.visual.actions.GestureSubmitter;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.ComponentBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class TakeScreenshotActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private BPListener bpListener;
    private DebuggerManagerAdapter enableListener = null;

    public TakeScreenshotActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.addEngineListener();
        this.bpListener = new BPListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this.bpListener), (Object)DebuggerManager.getDebuggerManager()));
    }

    public Set getActions() {
        return Collections.singleton("takeScreenshot");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        String msg = null;
        this.setEnabled("takeScreenshot", false);
        try {
            ProgressHandle ph = this.createProgress();
            RemoteScreenshot[] screenshots = null;
            boolean taken = false;
            try {
                RemoteScreenshot screenshot;
                int i;
                screenshots = RemoteAWTScreenshot.takeCurrent(this.debugger);
                for (i = 0; i < screenshots.length; ++i) {
                    screenshot = screenshots[i];
                    screenshot.getScreenshotUIManager().open();
                    this.bpListener.addScreenshot(screenshot);
                }
                if (screenshots != null && screenshots.length != 0) {
                    GestureSubmitter.logSnapshotTaken("Swing", this.debugger);
                    taken = true;
                }
                screenshots = RemoteFXScreenshot.takeCurrent(this.debugger);
                for (i = 0; i < screenshots.length; ++i) {
                    screenshot = screenshots[i];
                    screenshot.getScreenshotUIManager().open();
                    this.bpListener.addScreenshot(screenshot);
                }
                if (screenshots != null && screenshots.length != 0) {
                    GestureSubmitter.logSnapshotTaken("JavaFX", this.debugger);
                    taken = true;
                }
            }
            finally {
                ph.finish();
            }
            if (!taken) {
                msg = NbBundle.getMessage(TakeScreenshotActionProvider.class, (String)"MSG_NoScreenshots");
            }
        }
        catch (RetrievalException ex) {
            msg = ex.getLocalizedMessage();
            if (ex.getCause() != null) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        finally {
            this.setEnabled("takeScreenshot", true);
        }
        if (msg != null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private ProgressHandle createProgress() {
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(TakeScreenshotActionProvider.class, (String)"MSG_TakingApplicationScreenshot"));
        ph.setInitialDelay(500);
        ph.start();
        return ph;
    }

    private void addEngineListener() {
        if (this.enableListener != null) {
            return;
        }
        this.enableListener = new DebuggerManagerAdapter(){

            public void propertyChange(PropertyChangeEvent evt) {
                TakeScreenshotActionProvider.this.setEnabled("takeScreenshot", RemoteServices.hasServiceAccess(TakeScreenshotActionProvider.this.debugger));
            }
        };
        RemoteServices.addServiceListener((PropertyChangeListener)this.enableListener);
    }

    private class BPListener
    implements DebuggerManagerListener {
        private final Set<RemoteScreenshot> screenshots = Collections.newSetFromMap(new WeakHashMap());

        private BPListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addScreenshot(RemoteScreenshot screenshot) {
            Breakpoint[] breakpoints;
            Set<RemoteScreenshot> set = this.screenshots;
            synchronized (set) {
                this.screenshots.add(screenshot);
            }
            for (Breakpoint b : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!(b instanceof ComponentBreakpoint)) continue;
                this.markBreakpoint(screenshot, (ComponentBreakpoint)b);
            }
        }

        private void markBreakpoint(RemoteScreenshot screenshot, ComponentBreakpoint b) {
            ComponentInfo ci;
            ObjectReference oc;
            ComponentBreakpoint.ComponentDescription cd = b.getComponent();
            if (cd != null && (oc = cd.getComponent(TakeScreenshotActionProvider.this.debugger)) != null && (ci = this.findComponentInfo(screenshot.getComponentInfo(), oc)) != null) {
                screenshot.getScreenshotUIManager().markBreakpoint(ci);
            }
        }

        private void unmarkBreakpoint(RemoteScreenshot screenshot, ComponentBreakpoint b) {
            ComponentInfo ci;
            ObjectReference oc;
            ComponentBreakpoint.ComponentDescription cd = b.getComponent();
            if (cd != null && (oc = cd.getComponent(TakeScreenshotActionProvider.this.debugger)) != null && (ci = this.findComponentInfo(screenshot.getComponentInfo(), oc)) != null) {
                screenshot.getScreenshotUIManager().unmarkBreakpoint(ci);
            }
        }

        private ComponentInfo findComponentInfo(ComponentInfo ci, ObjectReference oc) {
            ObjectReference or;
            if (ci instanceof JavaComponentInfo && oc.equals(or = ((JavaComponentInfo)ci).getComponent())) {
                return ci;
            }
            for (ComponentInfo sci : ci.getSubComponents()) {
                ComponentInfo fci = this.findComponentInfo(sci, oc);
                if (fci == null) continue;
                return fci;
            }
            return null;
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void breakpointAdded(Breakpoint breakpoint) {
            if (!(breakpoint instanceof ComponentBreakpoint)) return;
            RemoteScreenshot[] remoteScreenshotArray = this.screenshots;
            synchronized (this.screenshots) {
                RemoteScreenshot[] scrs = this.screenshots.toArray(new RemoteScreenshot[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (RemoteScreenshot screenshot : scrs) {
                    this.markBreakpoint(screenshot, (ComponentBreakpoint)breakpoint);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void breakpointRemoved(Breakpoint breakpoint) {
            if (!(breakpoint instanceof ComponentBreakpoint)) return;
            RemoteScreenshot[] remoteScreenshotArray = this.screenshots;
            synchronized (this.screenshots) {
                RemoteScreenshot[] scrs = this.screenshots.toArray(new RemoteScreenshot[0]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (RemoteScreenshot screenshot : scrs) {
                    this.unmarkBreakpoint(screenshot, (ComponentBreakpoint)breakpoint);
                }
                return;
            }
        }

        public void initWatches() {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void sessionAdded(Session session) {
        }

        public void sessionRemoved(Session session) {
        }

        public void engineAdded(DebuggerEngine engine) {
        }

        public void engineRemoved(DebuggerEngine engine) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }
}

