/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.NEXUS;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.creator.LegacyDocumentUpdater;
import org.apache.maven.index.locator.JavadocLocator;
import org.apache.maven.index.locator.Locator;
import org.apache.maven.index.locator.Sha1Locator;
import org.apache.maven.index.locator.SignatureLocator;
import org.apache.maven.index.locator.SourcesLocator;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="min")
public class MinimalArtifactInfoIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    private static final char FS = "|".charAt(0);
    public static final String ID = "min";
    public static final IndexerField FLD_INFO;
    public static final IndexerField FLD_GROUP_ID_KW;
    public static final IndexerField FLD_GROUP_ID;
    public static final IndexerField FLD_ARTIFACT_ID_KW;
    public static final IndexerField FLD_ARTIFACT_ID;
    public static final IndexerField FLD_VERSION_KW;
    public static final IndexerField FLD_VERSION;
    public static final IndexerField FLD_PACKAGING;
    public static final IndexerField FLD_EXTENSION;
    public static final IndexerField FLD_CLASSIFIER;
    public static final IndexerField FLD_NAME;
    public static final IndexerField FLD_DESCRIPTION;
    public static final IndexerField FLD_LAST_MODIFIED;
    public static final IndexerField FLD_SHA1;
    private Locator jl = new JavadocLocator();
    private Locator sl = new SourcesLocator();
    private Locator sigl = new SignatureLocator();
    private Locator sha1l = new Sha1Locator();

    public MinimalArtifactInfoIndexCreator() {
        super(ID);
    }

    @Override
    public void populateArtifactInfo(ArtifactContext ac) {
        Model model;
        File artifact = ac.getArtifact();
        File pom = ac.getPom();
        ArtifactInfo ai = ac.getArtifactInfo();
        if (pom != null && pom.isFile()) {
            ai.setLastModified(pom.lastModified());
            ai.setFileExtension("pom");
        }
        if (pom != null && pom.isFile()) {
            if (ai.getClassifier() != null) {
                ai.setSourcesExists(ArtifactAvailability.NOT_AVAILABLE);
                ai.setJavadocExists(ArtifactAvailability.NOT_AVAILABLE);
            } else {
                File sources = this.sl.locate(pom);
                if (!sources.exists()) {
                    ai.setSourcesExists(ArtifactAvailability.NOT_PRESENT);
                } else {
                    ai.setSourcesExists(ArtifactAvailability.PRESENT);
                }
                File javadoc = this.jl.locate(pom);
                if (!javadoc.exists()) {
                    ai.setJavadocExists(ArtifactAvailability.NOT_PRESENT);
                } else {
                    ai.setJavadocExists(ArtifactAvailability.PRESENT);
                }
            }
        }
        if ((model = ac.getPomModel()) != null) {
            ai.setName(model.getName());
            ai.setDescription(model.getDescription());
            if (ai.getClassifier() == null) {
                if (model.getPackaging() != null) {
                    ai.setPackaging(model.getPackaging());
                } else {
                    ai.setPackaging("jar");
                }
            }
        }
        if ("pom".equals(ai.getPackaging())) {
            artifact = pom;
        }
        if (artifact != null) {
            File signature = this.sigl.locate(artifact);
            ai.setSignatureExists(signature.exists() ? ArtifactAvailability.PRESENT : ArtifactAvailability.NOT_PRESENT);
            File sha1 = this.sha1l.locate(artifact);
            if (sha1.exists()) {
                try {
                    ai.setSha1(StringUtils.chomp((String)FileUtils.fileRead((File)sha1)).trim().split(" ")[0]);
                }
                catch (IOException e) {
                    ac.addError(e);
                }
            }
            ai.setLastModified(artifact.lastModified());
            ai.setSize(artifact.length());
            ai.setFileExtension(this.getExtension(artifact, ac.getGav()));
        }
    }

    private String getExtension(File artifact, Gav gav) {
        if (gav != null && StringUtils.isNotBlank((String)gav.getExtension())) {
            return gav.getExtension();
        }
        String artifactFileName = artifact.getName().toLowerCase();
        if (artifactFileName.endsWith("tar.gz")) {
            return "tar.gz";
        }
        if (artifactFileName.equals("tar.bz2")) {
            return "tar.bz2";
        }
        return FileUtils.getExtension((String)artifactFileName);
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        String info = ArtifactInfo.nvl(ai.getPackaging()) + "|" + ai.getLastModified() + "|" + ai.getSize() + "|" + ai.getSourcesExists().toString() + "|" + ai.getJavadocExists().toString() + "|" + ai.getSignatureExists().toString() + "|" + ai.getFileExtension();
        doc.add((IndexableField)FLD_INFO.toField(info));
        doc.add((IndexableField)FLD_GROUP_ID_KW.toField(ai.getGroupId()));
        doc.add((IndexableField)FLD_ARTIFACT_ID_KW.toField(ai.getArtifactId()));
        doc.add((IndexableField)FLD_VERSION_KW.toField(ai.getVersion()));
        doc.add((IndexableField)FLD_GROUP_ID.toField(ai.getGroupId()));
        doc.add((IndexableField)FLD_ARTIFACT_ID.toField(ai.getArtifactId()));
        doc.add((IndexableField)FLD_VERSION.toField(ai.getVersion()));
        doc.add((IndexableField)FLD_EXTENSION.toField(ai.getFileExtension()));
        if (ai.getName() != null) {
            doc.add((IndexableField)FLD_NAME.toField(ai.getName()));
        }
        if (ai.getDescription() != null) {
            doc.add((IndexableField)FLD_DESCRIPTION.toField(ai.getDescription()));
        }
        if (ai.getPackaging() != null) {
            doc.add((IndexableField)FLD_PACKAGING.toField(ai.getPackaging()));
        }
        if (ai.getClassifier() != null) {
            doc.add((IndexableField)FLD_CLASSIFIER.toField(ai.getClassifier()));
        }
        if (ai.getSha1() != null) {
            doc.add((IndexableField)FLD_SHA1.toField(ai.getSha1()));
        }
    }

    @Override
    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        this.updateDocument(ai, doc);
        if (ai.getPrefix() != null) {
            doc.add((IndexableField)new Field(ArtifactInfo.PLUGIN_PREFIX, (CharSequence)ai.getPrefix(), (IndexableFieldType)IndexerField.KEYWORD_STORED));
        }
        if (ai.getGoals() != null) {
            doc.add((IndexableField)new StoredField(ArtifactInfo.PLUGIN_GOALS, ArtifactInfo.lst2str(ai.getGoals())));
        }
        doc.removeField(ArtifactInfo.GROUP_ID);
        doc.add((IndexableField)new Field(ArtifactInfo.GROUP_ID, (CharSequence)ai.getGroupId(), (IndexableFieldType)IndexerField.KEYWORD_NOT_STORED));
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo ai) {
        String sha1;
        String description;
        String name;
        String info;
        boolean res = false;
        String uinfo = doc.get(ArtifactInfo.UINFO);
        if (uinfo != null) {
            int start = 0;
            int end = uinfo.indexOf(FS);
            ai.setGroupId(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            ai.setArtifactId(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            ai.setVersion(uinfo.substring(start, end));
            start = end + 1;
            end = uinfo.indexOf(FS, start);
            if (end == -1) {
                end = uinfo.length();
            }
            ai.setClassifier(ArtifactInfo.renvl(uinfo.substring(start, end)));
            if (end != uinfo.length()) {
                start = end + 1;
                end = uinfo.length();
                ai.setFileExtension(uinfo.substring(start, end));
            }
            res = true;
        }
        if ((info = doc.get(ArtifactInfo.INFO)) != null) {
            int start = 0;
            int end = info.indexOf(FS);
            ai.setPackaging(ArtifactInfo.renvl(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setLastModified(Long.parseLong(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setSize(Long.parseLong(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setSourcesExists(ArtifactAvailability.fromString(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            ai.setJavadocExists(ArtifactAvailability.fromString(info.substring(start, end)));
            start = end + 1;
            end = info.indexOf(FS, start);
            if (end == -1) {
                end = info.length();
            }
            ai.setSignatureExists(ArtifactAvailability.fromString(info.substring(start, end)));
            if (end != info.length()) {
                start = end + 1;
                end = info.length();
                ai.setFileExtension(info.substring(start, end));
            } else if (ai.getClassifier() != null || "pom".equals(ai.getPackaging()) || "war".equals(ai.getPackaging()) || "ear".equals(ai.getPackaging())) {
                ai.setFileExtension(ai.getPackaging());
            } else {
                ai.setFileExtension("jar");
            }
            res = true;
        }
        if ((name = doc.get(ArtifactInfo.NAME)) != null) {
            ai.setName(name);
            res = true;
        }
        if ((description = doc.get(ArtifactInfo.DESCRIPTION)) != null) {
            ai.setDescription(description);
            res = true;
        }
        if ("null".equals(ai.getPackaging())) {
            ai.setPackaging(null);
        }
        if ((sha1 = doc.get(ArtifactInfo.SHA1)) != null) {
            ai.setSha1(sha1);
        }
        return res;
    }

    public String toString() {
        return ID;
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_INFO, FLD_GROUP_ID_KW, FLD_GROUP_ID, FLD_ARTIFACT_ID_KW, FLD_ARTIFACT_ID, FLD_VERSION_KW, FLD_VERSION, FLD_PACKAGING, FLD_CLASSIFIER, FLD_NAME, FLD_DESCRIPTION, FLD_LAST_MODIFIED, FLD_SHA1);
    }

    static {
        if ("|".length() != 1) {
            throw new IllegalStateException("field format changed");
        }
        FLD_INFO = new IndexerField(NEXUS.INFO, IndexerFieldVersion.V1, "i", "Artifact INFO (not indexed, stored)", StoredField.TYPE);
        FLD_GROUP_ID_KW = new IndexerField(MAVEN.GROUP_ID, IndexerFieldVersion.V1, "g", "Artifact GroupID (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_GROUP_ID = new IndexerField(MAVEN.GROUP_ID, IndexerFieldVersion.V3, "groupId", "Artifact GroupID (tokenized)", IndexerField.ANALYZED_NOT_STORED);
        FLD_ARTIFACT_ID_KW = new IndexerField(MAVEN.ARTIFACT_ID, IndexerFieldVersion.V1, "a", "Artifact ArtifactID (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_ARTIFACT_ID = new IndexerField(MAVEN.ARTIFACT_ID, IndexerFieldVersion.V3, "artifactId", "Artifact ArtifactID (tokenized)", IndexerField.ANALYZED_NOT_STORED);
        FLD_VERSION_KW = new IndexerField(MAVEN.VERSION, IndexerFieldVersion.V1, "v", "Artifact Version (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_VERSION = new IndexerField(MAVEN.VERSION, IndexerFieldVersion.V3, "version", "Artifact Version (tokenized)", IndexerField.ANALYZED_NOT_STORED);
        FLD_PACKAGING = new IndexerField(MAVEN.PACKAGING, IndexerFieldVersion.V1, "p", "Artifact Packaging (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_EXTENSION = new IndexerField(MAVEN.EXTENSION, IndexerFieldVersion.V1, "e", "Artifact extension (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_CLASSIFIER = new IndexerField(MAVEN.CLASSIFIER, IndexerFieldVersion.V1, "l", "Artifact classifier (as keyword)", IndexerField.KEYWORD_NOT_STORED);
        FLD_NAME = new IndexerField(MAVEN.NAME, IndexerFieldVersion.V1, "n", "Artifact name (tokenized, stored)", IndexerField.ANALYZED_STORED);
        FLD_DESCRIPTION = new IndexerField(MAVEN.DESCRIPTION, IndexerFieldVersion.V1, "d", "Artifact description (tokenized, stored)", IndexerField.ANALYZED_STORED);
        FLD_LAST_MODIFIED = new IndexerField(MAVEN.LAST_MODIFIED, IndexerFieldVersion.V1, "m", "Artifact last modified (not indexed, stored)", StoredField.TYPE);
        FLD_SHA1 = new IndexerField(MAVEN.SHA1, IndexerFieldVersion.V1, "1", "Artifact SHA1 checksum (as keyword, stored)", IndexerField.KEYWORD_STORED);
    }
}

