/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class ProjectsView
extends JPanel
implements ExplorerManager.Provider,
VetoableChangeListener {
    private final AbstractNode rootNode;
    private final ExplorerManager em;
    private final ProjectOutlineView view;
    private Node[] selectedNodes;
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static Image FOLDER_ICON;

    public ProjectsView(Map<Project, Set<Project>> projectsToBeOpened) {
        this.rootNode = new AbstractNode((Children)new ProjectsChildren(projectsToBeOpened));
        this.em = new ExplorerManager();
        this.view = new ProjectOutlineView();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.view), "Center");
        this.em.addVetoableChangeListener((VetoableChangeListener)this);
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public void addSelectionChangeListener(PropertyChangeListener l) {
        this.em.addPropertyChangeListener(l);
    }

    public void removeSelectionChangeListener(PropertyChangeListener l) {
        this.em.removePropertyChangeListener(l);
    }

    public Set<Project> getSelectedProjects() {
        Node[] nodes;
        HashSet<Project> projects = new HashSet<Project>();
        for (Node node : nodes = this.selectedNodes) {
            Project p = (Project)node.getLookup().lookup(Project.class);
            if (p == null) continue;
            projects.add(p);
        }
        return projects;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes;
            for (Node node : nodes = (Node[])evt.getNewValue()) {
                if (node instanceof ProjectNode) continue;
                throw new PropertyVetoException("", evt);
            }
            if (nodes.length > 0) {
                this.selectedNodes = nodes;
            }
        }
    }

    private static Image getFolderIcon() {
        if (FOLDER_ICON == null) {
            Image base;
            Icon baseIcon = UIManager.getIcon(ICON_KEY_UIMANAGER);
            if (baseIcon != null) {
                base = ImageUtilities.icon2Image((Icon)baseIcon);
            } else {
                base = (Image)UIManager.get(ICON_KEY_UIMANAGER_NB);
                if (base == null) {
                    base = ImageUtilities.loadImage((String)"org/openide/loaders/defaultFolder.gif");
                }
            }
            FOLDER_ICON = base;
        }
        return FOLDER_ICON;
    }

    private class ProjectsChildren
    extends Children.Keys<ProjectNode> {
        private Map<Project, Set<Project>> projects;

        public ProjectsChildren(Map<Project, Set<Project>> projects) {
            this.projects = projects;
        }

        protected Node[] createNodes(ProjectNode key) {
            return new ProjectNode[]{key};
        }

        protected void addNotify() {
            this.refreshKeys();
        }

        public void refreshKeys() {
            Project parent = (Project)this.getNode().getLookup().lookup(Project.class);
            Set<Project> childrenProjects = this.projects.get(parent);
            LinkedList<ProjectNode> keys = new LinkedList<ProjectNode>();
            for (Project p : childrenProjects) {
                keys.add(new ProjectNode(p, (Children)(this.projects.get(p).size() == 0 ? LEAF : new ProjectsChildren(this.projects))));
            }
            this.setKeys(keys);
        }
    }

    private class ProjectOutlineView
    extends OutlineView {
        public ProjectOutlineView() {
            this.getOutline().setShowHorizontalLines(true);
            this.getOutline().setShowVerticalLines(false);
            this.getOutline().setRootVisible(false);
            this.setVerticalScrollBarPolicy(22);
            this.setHorizontalScrollBarPolicy(30);
            this.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectsView.class, (String)"ACSD_ProjectOutlineView"));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectsView.class, (String)"ACSN_ProjectOutlineView"));
            this.setPopupAllowed(true);
            this.setupColumns();
            this.setDefaultColumnSizes();
        }

        private void setupColumns() {
            Node.Property[] columns = new Node.Property[1];
            String columnName = NbBundle.getMessage(ProjectsView.class, (String)"LBL_Path");
            String columnDesc = NbBundle.getMessage(ProjectsView.class, (String)"LBL_PathDesc");
            columns[0] = new ColumnDescriptor<String>("path", String.class, columnName, columnDesc);
            this.setProperties(columns);
        }

        private void setDefaultColumnSizes() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int width = ProjectOutlineView.this.getWidth();
                    ProjectOutlineView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 40 / 100);
                    ProjectOutlineView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 60 / 100);
                }
            });
        }

        public void addNotify() {
            ExplorerManager em = ExplorerManager.find((Component)((Object)this));
            em.setRootContext((Node)ProjectsView.this.rootNode);
            em.setExploredContext((Node)ProjectsView.this.rootNode);
            this.expandNode((Node)ProjectsView.this.rootNode);
            super.addNotify();
        }
    }

    private final class ProjectNode
    extends AbstractNode {
        static final String PROPERTY_NAME_PATH = "path";
        private final ProjectInformation info;

        public ProjectNode(Project p, Children children) {
            super(children, Lookups.singleton((Object)p));
            this.info = ProjectUtils.getInformation((Project)p);
            this.setProperties();
        }

        private void setProperties() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set ps = Sheet.createPropertiesSet();
            ps.put((Node.Property)new LocalPathProperty());
            sheet.put(ps);
            this.setSheet(sheet);
        }

        public Image getIcon(int type) {
            Icon icon = this.info.getIcon();
            if (icon == null) {
                Logger.getLogger(ProjectsView.class.getName()).log(Level.WARNING, "Null project icon for {0}:{1}", new Object[]{this.info.getDisplayName(), this.info.getProject()});
                return ProjectsView.getFolderIcon();
            }
            return ImageUtilities.icon2Image((Icon)icon);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        public String getName() {
            return this.info.getName();
        }

        private class LocalPathProperty
        extends PropertySupport.ReadOnly<String> {
            public LocalPathProperty() {
                super(ProjectNode.PROPERTY_NAME_PATH, String.class, ProjectNode.PROPERTY_NAME_PATH, ProjectNode.PROPERTY_NAME_PATH);
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return ((Project)ProjectNode.this.getLookup().lookup(Project.class)).getProjectDirectory().getPath();
            }
        }
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() {
            return null;
        }
    }
}

