/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spring;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileLocationProvider;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GradleSpringConfigProvider
implements SpringConfigFileProvider,
SpringConfigFileLocationProvider {
    private final Project project;

    public GradleSpringConfigProvider(Project project) {
        this.project = project;
    }

    public Set<File> getConfigFiles() {
        HashSet<File> ret = new HashSet<File>();
        GradleJavaSourceSet ss = (GradleJavaSourceSet)GradleJavaProject.get((Project)this.project).getSourceSets().get("main");
        if (ss != null) {
            for (File resourcesDir : ss.getResourcesDirs()) {
                FileObject dir = FileUtil.toFileObject((File)resourcesDir);
                if (dir == null) continue;
                this.collectConfigs(dir, false, ret);
                if ((dir = dir.getFileObject("spring")) == null) continue;
                this.collectConfigs(dir, true, ret);
            }
        }
        return Collections.unmodifiableSet(ret);
    }

    public FileObject getLocation() {
        FileObject ret;
        block1: {
            File resourcesDir;
            ret = null;
            GradleJavaSourceSet ss = (GradleJavaSourceSet)GradleJavaProject.get((Project)this.project).getSourceSets().get("main");
            if (ss == null) break block1;
            Iterator iterator = ss.getResourcesDirs().iterator();
            while (iterator.hasNext() && (ret = FileUtil.toFileObject((File)(resourcesDir = (File)iterator.next()))) == null) {
            }
        }
        return ret;
    }

    private void collectConfigs(FileObject dir, boolean recursive, Set<File> configFiles) {
        for (FileObject fo : dir.getChildren()) {
            if ("text/x-springconfig+xml".equals(fo.getMIMEType())) {
                configFiles.add(FileUtil.toFile((FileObject)fo));
            }
            if (!recursive || !fo.isFolder()) continue;
            this.collectConfigs(fo, recursive, configFiles);
        }
    }
}

