/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.primefaces.push.EventBusFactory;
import org.primefaces.push.PushContext;
import org.primefaces.push.PushContextFactory;
import org.primefaces.push.PushContextImpl;
import org.primefaces.push.impl.PushEndpointProcessor;
import org.primefaces.push.impl.PushObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushServlet
extends AtmosphereServlet {
    private final Logger logger = LoggerFactory.getLogger((String)PushServlet.class.getName());

    public PushServlet() {
        this(false);
    }

    public PushServlet(boolean isFilter) {
        super(isFilter, true);
    }

    public PushServlet(boolean isFilter, boolean autoDetectHandlers) {
        super(isFilter, autoDetectHandlers);
    }

    protected PushServlet configureFramework(ServletConfig sc) throws ServletException {
        PushContext c;
        if (this.framework == null) {
            this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(AtmosphereFramework.class.getName());
            if (this.framework == null) {
                this.framework = this.newAtmosphereFramework();
            }
        }
        if (PushContextImpl.class.isAssignableFrom((c = PushContextFactory.getDefault().getPushContext()).getClass())) {
            this.framework().asyncSupportListener((AsyncSupportListener)PushContextImpl.class.cast(c));
        }
        this.framework.interceptor((AtmosphereInterceptor)new AtmosphereResourceLifecycleInterceptor()).interceptor((AtmosphereInterceptor)new TrackMessageSizeInterceptor()).addAnnotationPackage(PushEndpointProcessor.class).objectFactory((AtmosphereObjectFactory)new PushObjectFactory());
        EventBusFactory f = new EventBusFactory();
        this.framework.getAtmosphereConfig().properties().put("evenBus", f.eventBus());
        this.framework.getAtmosphereConfig().startupHook(new AtmosphereConfig.StartupHook(){

            public void started(AtmosphereFramework framework) {
                PushServlet.this.configureMetaBroadcasterCache(framework);
            }
        });
        this.framework.init(sc);
        if (this.framework.getAtmosphereHandlers().size() == 0) {
            this.logger.error("No Annotated class using @PushEndpoint found. Push will not work.");
        }
        return this;
    }

    protected void configureMetaBroadcasterCache(AtmosphereFramework framework) {
        MetaBroadcaster.getDefault().cache((MetaBroadcaster.MetaBroadcasterCache)new MetaBroadcaster.ThirtySecondsCache(MetaBroadcaster.getDefault(), framework.getAtmosphereConfig()));
    }

    protected AtmosphereFramework newAtmosphereFramework() {
        return new AtmosphereFramework(this.isFilter, this.autoDetectHandlers);
    }

    public AtmosphereFramework framework() {
        if (this.framework == null) {
            this.framework = this.newAtmosphereFramework();
        }
        return this.framework;
    }
}

