/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.project;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.WsdlNamespaceHandler;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class WSUtils {
    private static final String WSIMPORT_BAD_VERSION = "wsimport.bad.version";
    private static String SUN_DOMAIN_12_DTD_SUFFIX = "lib" + File.separator + "dtds" + File.separator + "sun-domain_1_2.dtd";
    private static String SUN_DOMAIN_13_DTD_SUFFIX = "lib" + File.separator + "dtds" + File.separator + "sun-domain_1_3.dtd";
    private static final String JAX_WS_XML_PATH = "nbproject/jax-ws.xml";
    public static final String JAX_WS_ENDORSED = "JAX-WS-ENDORSED";
    private static final String ENDORSED = "classpath/endorsed";
    private static final String DEFAULT_PACKAGE_NAME = "org.netbeans.ws";

    public static FileObject retrieveResource(FileObject targetFolder, URI source) throws UnknownHostException, URISyntaxException, IOException {
        try {
            Iterator iterator;
            Map map;
            Retriever retriever = Retriever.getDefault();
            FileObject result = retriever.retrieveResource(targetFolder, source);
            if (result == null && (map = retriever.getRetrievedResourceExceptionMap()) != null && (iterator = map.entrySet().iterator()).hasNext()) {
                Map.Entry entry = iterator.next();
                RetrieveEntry key = (RetrieveEntry)entry.getKey();
                Exception exc = (Exception)entry.getValue();
                if (exc instanceof IOException) {
                    throw (IOException)exc;
                }
                if (exc instanceof URISyntaxException) {
                    throw (URISyntaxException)exc;
                }
                IOException ex = new IOException(NbBundle.getMessage(WSUtils.class, (String)"ERR_retrieveResource", (Object)key.getCurrentAddress()));
                ex.initCause(exc);
                throw ex;
            }
            return result;
        }
        catch (RuntimeException ex) {
            throw (IOException)new IOException(ex.getLocalizedMessage()).initCause(ex);
        }
    }

    public static String findProperServiceName(String name, JaxWsModel jaxWsModel) {
        if (jaxWsModel.findServiceByName(name) == null) {
            return name;
        }
        int i = 1;
        String destName;
        while (jaxWsModel.findServiceByName(destName = name + "_" + i) != null) {
            ++i;
        }
        return destName;
    }

    public static void retrieveJaxWsFromResource(FileObject projectDir) throws IOException {
        final String jaxWsContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
        final FileObject nbprojFo = projectDir.getFileObject("nbproject");
        assert (nbprojFo != null) : "Cannot find nbproject directory";
        FileSystem fs = nbprojFo.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject jaxWsFo = FileUtil.createData((FileObject)nbprojFo, (String)"jax-ws.xml");
                FileLock lock = jaxWsFo.lock();
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new OutputStreamWriter(jaxWsFo.getOutputStream(lock), StandardCharsets.UTF_8));
                    bw.write(jaxWsContent);
                }
                finally {
                    lock.releaseLock();
                    if (bw != null) {
                        bw.close();
                    }
                }
            }
        });
    }

    public static void retrieveHandlerConfigFromResource(final FileObject targetDir, final String handlerConfigName) throws IOException {
        final String handlerContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/handler.xml"));
        FileSystem fs = targetDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject handlerFo = FileUtil.createData((FileObject)targetDir, (String)handlerConfigName);
                FileLock lock = handlerFo.lock();
                BufferedWriter bw = null;
                OutputStream os = null;
                try {
                    os = handlerFo.getOutputStream(lock);
                    bw = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
                    bw.write(handlerContent);
                    bw.close();
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    public static String getJAXWSVersion(File appSvrRoot) {
        if (appSvrRoot == null) {
            return "jaxws20";
        }
        File dtdFile_12 = new File(appSvrRoot, SUN_DOMAIN_12_DTD_SUFFIX);
        File dtdFile_13 = new File(appSvrRoot, SUN_DOMAIN_13_DTD_SUFFIX);
        if (dtdFile_12.exists() && !dtdFile_13.exists()) {
            return "jaxws20";
        }
        return "jaxws21";
    }

    public static void generateSunJaxwsFile(final FileObject targetDir) throws IOException {
        final String sunJaxwsContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/sun-jaxws.xml"));
        FileSystem fs = targetDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject sunJaxwsFo = FileUtil.createData((FileObject)targetDir, (String)"sun-jaxws.xml");
                FileLock lock = sunJaxwsFo.lock();
                BufferedWriter bw = null;
                OutputStream os = null;
                OutputStreamWriter osw = null;
                try {
                    os = sunJaxwsFo.getOutputStream(lock);
                    osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                    bw = new BufferedWriter(osw);
                    bw.write(sunJaxwsContent);
                }
                finally {
                    if (bw != null) {
                        bw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        });
    }

    private static String readResource(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append(lineSep);
            line = br.readLine();
        }
        br.close();
        return sb.toString();
    }

    public static void removeImplClass(Project project, String implClass) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String resource = implClass.replace('.', '/') + ".java";
        if (sources != null) {
            SourceGroup[] srcGroup = sources.getSourceGroups("java");
            for (int i = 0; i < srcGroup.length; ++i) {
                FileObject srcRoot = srcGroup[i].getRootFolder();
                final FileObject implClassFo = srcRoot.getFileObject(resource);
                if (implClassFo == null) continue;
                try {
                    FileSystem fs = implClassFo.getFileSystem();
                    fs.runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() {
                            WSUtils.deleteFile(implClassFo);
                        }
                    });
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFile(FileObject f) {
        FileLock lock = null;
        try {
            SaveCookie save;
            DataObject dObj = DataObject.find((FileObject)f);
            if (dObj != null && (save = (SaveCookie)dObj.getLookup().lookup(SaveCookie.class)) != null) {
                save.save();
            }
            lock = f.lock();
            f.delete(lock);
        }
        catch (IOException e) {
            NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"MSG_Unable_Delete_File", (Object)f.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static void copyFiles(FileObject sourceFolder, FileObject targetFolder) throws IOException {
        FileObject[] children = sourceFolder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isFolder()) {
                String folderName = children[i].getNameExt();
                if (folderName.startsWith(".")) continue;
                FileObject folder = targetFolder.getFileObject(children[i].getNameExt());
                if (folder == null) {
                    folder = targetFolder.createFolder(children[i].getNameExt());
                }
                WSUtils.copyFiles(children[i], folder);
                continue;
            }
            String fileName = children[i].getName();
            if (fileName.startsWith(".")) continue;
            String fileExt = children[i].getExt();
            FileObject oldFile = targetFolder.getFileObject(fileName, fileExt);
            if (oldFile != null) {
                oldFile.delete();
            }
            children[i].copy(targetFolder, fileName, fileExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject backupAndGenerateJaxWs(FileObject projectDir, FileObject oldJaxWs, RuntimeException reason) throws IOException {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"ERR_corruptedJaxWs", (Object)oldJaxWs.getPath(), (Object)reason.getMessage()), 0));
        FileObject parent = oldJaxWs.getParent();
        FileObject oldBackup = parent.getFileObject("jax-ws.xml.old");
        FileLock lock = null;
        if (oldBackup != null) {
            try {
                lock = oldBackup.lock();
                oldBackup.delete(lock);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        try {
            lock = oldJaxWs.lock();
            oldJaxWs.rename(lock, "jax-ws.xml", "old");
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
        WSUtils.retrieveJaxWsFromResource(projectDir);
        return projectDir.getFileObject(JAX_WS_XML_PATH);
    }

    private static String getJaxWsApiDir() {
        File jaxwsApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxws22/api/jakarta.xml.ws-api.jar", null, false);
        if (jaxwsApi != null) {
            File jaxbApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
            return jaxwsApi.getParent() + (jaxbApi != null ? ":" + jaxbApi.getParent() : "");
        }
        return null;
    }

    public static void addJaxWsApiEndorsed(Project project, FileObject srcRoot) throws IOException {
        ClassPath classPath;
        Library jaxWsApiLib = LibraryManager.getDefault().getLibrary(JAX_WS_ENDORSED);
        if (!WSUtils.isJaxWs22InJDK(srcRoot)) {
            ClassPath classPath2;
            if (jaxWsApiLib == null) {
                jaxWsApiLib = WSUtils.createJaxWsApiLibrary();
            }
            if ((classPath2 = ClassPath.getClassPath((FileObject)srcRoot, (String)ENDORSED)) == null || classPath2.findResource("javax/xml/ws/EndpointContext.class") == null) {
                ProjectClassPathModifier.addLibraries((Library[])new Library[]{jaxWsApiLib}, (FileObject)srcRoot, (String)ENDORSED);
            }
        } else if (jaxWsApiLib != null && (classPath = ClassPath.getClassPath((FileObject)srcRoot, (String)ENDORSED)) != null && classPath.findResource("javax/xml/ws/EndpointContext.class") != null) {
            try {
                ProjectClassPathModifier.removeLibraries((Library[])new Library[]{jaxWsApiLib}, (FileObject)srcRoot, (String)ENDORSED);
            }
            catch (UnsupportedOperationException ex) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, null, ex);
            }
        }
    }

    private static boolean isJaxWs22InJDK(FileObject srcRoot) {
        ClassPath cp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
        return cp != null && cp.findResource("javax/xml/ws/EndpointContext.class") != null;
    }

    public static Library createJaxWsApiLibrary() throws IOException {
        List<URL> apiJars = WSUtils.getJaxWsApiJars();
        if (apiJars.size() > 0) {
            Map<String, List<URL>> map = Collections.singletonMap("classpath", apiJars);
            return LibraryManager.getDefault().createLibrary("j2se", JAX_WS_ENDORSED, map);
        }
        return null;
    }

    private static List<URL> getJaxWsApiJars() throws IOException {
        URL url;
        ArrayList<URL> urls = new ArrayList<URL>();
        File apiJar = InstalledFileLocator.getDefault().locate("modules/ext/jaxws22/api/jakarta.xml.ws-api.jar", null, false);
        if (apiJar != null) {
            url = new URL("jar:nbinst://org.netbeans.modules.websvc.jaxws21api/modules/ext/jaxws22/api/jakarta.xml.ws-api.jar!/");
            urls.add(url);
        }
        if ((apiJar = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false)) != null) {
            url = new URL("jar:nbinst://org.netbeans.libs.jaxb/modules/ext/jaxb/api/jaxb-api.jar!/");
            urls.add(url);
        }
        return urls;
    }

    public static FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject(JAX_WS_XML_PATH);
    }

    public static FileObject createJaxWsFileObject(final Project project) throws IOException {
        try {
            return (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                public FileObject run() throws IOException {
                    JaxWsModel jaxWsModel;
                    WSUtils.retrieveJaxWsFromResource(project.getProjectDirectory());
                    FileObject jaxWsFo = WSUtils.findJaxWsFileObject(project);
                    assert (jaxWsFo != null) : "Cannot find jax-ws.xml in project's nbproject directory";
                    if (jaxWsFo != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                        jaxWsModel.setJaxWsFile(jaxWsFo);
                    }
                    return jaxWsFo;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    public static EditableProperties getEditableProperties(final Project prj, final String propertiesPath) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        ep = new EditableProperties();
                        try (InputStream is = null;){
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    public static void storeEditableProperties(final Project prj, final String propertiesPath, final EditableProperties ep) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject propertiesFo = prj.getProjectDirectory().getFileObject(propertiesPath);
                    if (propertiesFo != null) {
                        try (OutputStream os = null;){
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static String getPackageNameFromNamespace(String ns) {
        String base = ns;
        int doubleSlashIndex = ns.indexOf("//");
        if (doubleSlashIndex >= 0) {
            base = ns.substring(doubleSlashIndex + 2);
        } else {
            int colonIndex = ns.indexOf(":");
            if (colonIndex >= 0) {
                base = ns.substring(colonIndex + 1);
            }
        }
        StringTokenizer tokens = new StringTokenizer(base, "/");
        if (tokens.countTokens() > 0) {
            ArrayList<String> packageParts = new ArrayList<String>();
            ArrayList<String> nsParts = new ArrayList<String>();
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (part.length() < 0) continue;
                nsParts.add(part);
            }
            if (nsParts.size() > 0) {
                int i;
                StringTokenizer tokens1 = new StringTokenizer((String)nsParts.get(0), ".");
                int countTokens = tokens1.countTokens();
                if (countTokens > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    while (tokens1.hasMoreTokens()) {
                        list.add(tokens1.nextToken());
                    }
                    for (i = countTokens - 1; i >= 0; --i) {
                        String part = (String)list.get(i);
                        if (i <= 0 && "www".equals(part)) continue;
                        packageParts.add(((String)list.get(i)).toLowerCase());
                    }
                } else {
                    return DEFAULT_PACKAGE_NAME;
                }
                for (int i2 = 1; i2 < nsParts.size(); ++i2) {
                    packageParts.add(((String)nsParts.get(i2)).toLowerCase());
                }
                StringBuffer buf = new StringBuffer((String)packageParts.get(0));
                for (i = 1; i < packageParts.size(); ++i) {
                    buf.append("." + (String)packageParts.get(i));
                }
                return buf.toString();
            }
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public static String getPackageNameForWsdl(File wsdl) {
        WsdlNamespaceHandler handler;
        block5: {
            handler = new WsdlNamespaceHandler();
            try {
                handler.parse(wsdl);
            }
            catch (ParserConfigurationException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
            catch (SAXException ex) {
                if ("sax_parser_finished_correctly".equals(ex.getMessage())) break block5;
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        String targetNamespace = handler.getTargetNamespace();
        if (targetNamespace != null) {
            return WSUtils.getPackageNameFromNamespace(targetNamespace);
        }
        return null;
    }

    public static FileObject retrieveJaxWsCatalogFromResource(final FileObject webInf) throws IOException {
        assert (webInf != null) : "WEB-INF (META-INF) directory";
        final String jaxWsContent = WSUtils.readResource(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws-catalog.xml"));
        FileSystem fs = webInf.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject jaxWsCatalog = FileUtil.createData((FileObject)webInf, (String)"jax-ws-catalog.xml");
                FileLock lock = jaxWsCatalog.lock();
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new OutputStreamWriter(jaxWsCatalog.getOutputStream(lock), StandardCharsets.UTF_8));
                    bw.write(jaxWsContent);
                }
                finally {
                    lock.releaseLock();
                    if (bw != null) {
                        bw.close();
                    }
                }
            }
        });
        return webInf.getFileObject("jax-ws-catalog.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasClients(FileObject jaxWsFo) throws IOException {
        boolean found = false;
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)jaxWsFo)), StandardCharsets.UTF_8));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains("<client ")) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasServiceOrClient(FileObject jaxWsFo) throws IOException {
        boolean found = false;
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileUtil.toFile((FileObject)jaxWsFo)), StandardCharsets.UTF_8));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains("<client ") && !line.contains("<service ")) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public static Properties identifyWsimport(AntProjectHelper helper) {
        if (helper == null) {
            return null;
        }
        EditableProperties props = helper.getProperties("nbproject/project.properties");
        String wsImportCp = props.getProperty("j2ee.platform.wsimport.classpath");
        if (wsImportCp == null || wsImportCp.length() == 0) {
            return null;
        }
        PropertyEvaluator evaluator = helper.getStandardPropertyEvaluator();
        String[] roots = wsImportCp.split(":");
        ArrayList<FileObject> cpItems = new ArrayList<FileObject>(roots.length);
        for (String root : roots) {
            String wsImportCpItem = evaluator.evaluate(root);
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(wsImportCpItem)));
            if (fileObject == null) continue;
            if (fileObject.isFolder()) {
                cpItems.add(fileObject);
                continue;
            }
            if (!FileUtil.isArchiveFile((FileObject)fileObject)) continue;
            cpItems.add(FileUtil.getArchiveRoot((FileObject)fileObject));
        }
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])cpItems.toArray(new FileObject[0]));
        FileObject wsImport = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (wsImport == null) {
            return null;
        }
        FileObject wsImportRoot = classPath.findOwnerRoot(wsImport);
        FileObject manifest = wsImportRoot.getFileObject("META-INF/MANIFEST.MF");
        try {
            Manifest mnfst = new Manifest(manifest.getInputStream());
            String version = mnfst.getMainAttributes().getValue("Implementation-Version");
            if (version == null) {
                return null;
            }
            if (version.startsWith("2.2.")) {
                if (evaluator.getProperty(WSIMPORT_BAD_VERSION) != null) {
                    WSUtils.setProjectProperty(helper, WSIMPORT_BAD_VERSION, null);
                }
                return null;
            }
            if (version.startsWith("2.2")) {
                FileObject badRoot = FileUtil.getArchiveFile((FileObject)wsImport);
                if (badRoot == null) {
                    badRoot = classPath.findOwnerRoot(wsImport);
                }
                NotifyDescriptor.Message notifyDescriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"ERR_WsimportBadVersion", (Object)version, (Object)badRoot.getPath()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
                Properties properties = new Properties();
                properties.put(WSIMPORT_BAD_VERSION, Boolean.TRUE.toString());
                WSUtils.setProjectProperty(helper, WSIMPORT_BAD_VERSION, Boolean.TRUE.toString());
                return properties;
            }
            if (evaluator.getProperty(WSIMPORT_BAD_VERSION) != null) {
                WSUtils.setProjectProperty(helper, WSIMPORT_BAD_VERSION, null);
            }
            return null;
        }
        catch (IOException e) {
            Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, null, e);
            return null;
        }
        catch (MutexException e) {
            Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, null, e);
            return null;
        }
    }

    private static void setProjectProperty(final AntProjectHelper helper, final String propertyName, final String value) throws MutexException, IOException {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                    if (value == null) {
                        ep.remove((Object)propertyName);
                    } else {
                        ep.setProperty(propertyName, value);
                    }
                    helper.putProperties("nbproject/project.properties", ep);
                    Project project = FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory());
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                }
            }
        });
    }
}

