/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.storage.json.internal;

import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.openhab.core.storage.json.internal.JsonStorage;
import org.openhab.core.storage.json.internal.migration.BridgeImplTypeMigrator;
import org.openhab.core.storage.json.internal.migration.PersistedTransformationTypeMigrator;
import org.openhab.core.storage.json.internal.migration.ThingImplTypeMigrator;
import org.openhab.core.storage.json.internal.migration.TypeMigrator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.openhab.core.storage.json", configurationPid={"org.openhab.storage.json"}, property={"service.pid=org.openhab.storage.json", "storage.format=json"})
@ConfigurableService(category="system", label="Json Storage", description_uri="system:json_storage")
@NonNullByDefault
public class JsonStorageService
implements StorageService {
    private static final int MAX_FILENAME_LENGTH = 127;
    private static final Map<String, List<TypeMigrator>> MIGRATORS = Map.of("org.openhab.core.thing.Thing", List.of(new BridgeImplTypeMigrator(), new ThingImplTypeMigrator()), "org.openhab.core.transform.TransformationConfiguration", List.of(new PersistedTransformationTypeMigrator()));
    private final Logger logger = LoggerFactory.getLogger(JsonStorageService.class);
    private String dbFolderName = "jsondb";
    protected static final String CONFIG_URI = "system:json_storage";
    private static final String CFG_MAX_BACKUP_FILES = "backup_files";
    private static final String CFG_WRITE_DELAY = "write_delay";
    private static final String CFG_MAX_DEFER_DELAY = "max_defer_delay";
    private int maxBackupFiles = 5;
    private int writeDelay = 500;
    private int maxDeferredPeriod = 60000;
    private final Map<String, JsonStorage<Object>> storageList = new HashMap<String, JsonStorage<Object>>();

    @Activate
    protected void activate(@Nullable Map<String, Object> properties) {
        File backup;
        this.dbFolderName = OpenHAB.getUserDataFolder() + File.separator + this.dbFolderName;
        File folder = new File(this.dbFolderName);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(backup = new File(this.dbFolderName, "backup")).exists()) {
            backup.mkdirs();
        }
        this.logger.debug("Json Storage Service: Activated.");
        if (properties == null || properties.isEmpty()) {
            return;
        }
        Object value = properties.get(CFG_MAX_BACKUP_FILES);
        try {
            if (value != null) {
                this.maxBackupFiles = Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{value, CFG_MAX_BACKUP_FILES, this.maxBackupFiles});
        }
        value = properties.get(CFG_WRITE_DELAY);
        try {
            if (value != null) {
                this.writeDelay = Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{value, CFG_WRITE_DELAY, this.writeDelay});
        }
        value = properties.get(CFG_MAX_DEFER_DELAY);
        try {
            if (value != null) {
                this.maxDeferredPeriod = Integer.parseInt((String)value);
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Value {} for {} is invalid. Using {}.", new Object[]{value, CFG_MAX_DEFER_DELAY, this.maxDeferredPeriod});
        }
    }

    @Deactivate
    protected void deactivate() {
        for (JsonStorage<Object> storage : this.storageList.values()) {
            storage.flush();
        }
        this.logger.debug("Json Storage Service: Deactivated.");
    }

    public <T> Storage<T> getStorage(String name, @Nullable ClassLoader classLoader) {
        JsonStorage<Object> oldStorage;
        File legacyFile = new File(this.dbFolderName, name + ".json");
        File file = new File(this.dbFolderName, this.urlEscapeUnwantedChars(name) + ".json");
        if (legacyFile.exists()) {
            file = legacyFile;
        }
        if ((oldStorage = this.storageList.get(name)) != null) {
            oldStorage.flush();
        }
        JsonStorage newStorage = new JsonStorage(file, classLoader, this.maxBackupFiles, this.writeDelay, this.maxDeferredPeriod, MIGRATORS.getOrDefault(name, List.of()));
        this.storageList.put(name, newStorage);
        return newStorage;
    }

    public <T> Storage<T> getStorage(String name) {
        return this.getStorage(name, null);
    }

    protected String urlEscapeUnwantedChars(String s) {
        String result = URLEncoder.encode(s, StandardCharsets.UTF_8);
        int length = Math.min(result.length(), 127);
        return result.substring(0, length);
    }
}

